/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.hive.PartitionUpdate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPartitionUpdate {
    private static final JsonCodec<PartitionUpdate> CODEC = JsonCodec.jsonCodec(PartitionUpdate.class);

    @Test
    public void testRoundTrip() {
        PartitionUpdate expected = new PartitionUpdate("test", PartitionUpdate.UpdateMode.APPEND, "/writePath", "/targetPath", (List)ImmutableList.of((Object)new PartitionUpdate.FileWriteInfo(".file1", "file1", Optional.empty()), (Object)new PartitionUpdate.FileWriteInfo(".file3", "file3", Optional.empty())), 123L, 456L, 789L, false);
        PartitionUpdate actual = (PartitionUpdate)CODEC.fromJson(CODEC.toJson((Object)expected));
        Assert.assertEquals((String)actual.getName(), (String)"test");
        Assert.assertEquals((Object)actual.getUpdateMode(), (Object)PartitionUpdate.UpdateMode.APPEND);
        Assert.assertEquals((Object)actual.getWritePath(), (Object)new Path("/writePath"));
        Assert.assertEquals((Object)actual.getTargetPath(), (Object)new Path("/targetPath"));
        Assert.assertEquals((Collection)actual.getFileWriteInfos(), (Collection)ImmutableList.of((Object)new PartitionUpdate.FileWriteInfo(".file1", "file1", Optional.empty()), (Object)new PartitionUpdate.FileWriteInfo(".file3", "file3", Optional.empty())));
        Assert.assertEquals((long)actual.getRowCount(), (long)123L);
        Assert.assertEquals((long)actual.getInMemoryDataSizeInBytes(), (long)456L);
        Assert.assertEquals((long)actual.getOnDiskDataSizeInBytes(), (long)789L);
    }
}

