/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestStreamingAggregationPlan
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createQueryRunner(ImmutableList.of((Object)TpchTable.ORDERS, (Object)TpchTable.LINE_ITEM, (Object)TpchTable.CUSTOMER, (Object)TpchTable.NATION), (Map<String, String>)ImmutableMap.of((Object)"experimental.pushdown-subfields-enabled", (Object)"true"), Optional.empty());
    }

    @Test
    public void testUnsortedTable() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_customer WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT custkey, COUNT(*) FROM test_customer \nWHERE ds = '2021-07-11' GROUP BY 1", this.aggregationPlanWithNoStreaming("test_customer", false, "custkey"));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_customer");
        }
    }

    @Test
    public void testBucketedAndSortedBySameKey() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_customer2 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            queryRunner.execute("INSERT INTO test_customer2 \nSELECT *, '2021-07-12' as ds FROM tpch.sf1.customer LIMIT 1000");
            this.assertPlan("SELECT custkey, COUNT(*) FROM test_customer2 \nWHERE ds = '2021-07-11' GROUP BY 1", this.aggregationPlanWithNoStreaming("test_customer2", false, "custkey"));
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT custkey, COUNT(*) FROM test_customer2 \nWHERE ds = '2021-07-11' GROUP BY 1", PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"custkey"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (List)ImmutableList.of())), (List)ImmutableList.of((Object)"custkey"), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"test_customer2", (Map)ImmutableMap.of((Object)"custkey", (Object)"custkey")))})}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_customer2");
        }
    }

    @Test
    public void testBucketedAndSortedByDifferentKeys() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_customer3 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['name'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT custkey, COUNT(*) FROM test_customer3 \nWHERE ds = '2021-07-11' GROUP BY 1", PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"custkey"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (List)ImmutableList.of())), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"test_customer3", (Map)ImmutableMap.of((Object)"custkey", (Object)"custkey")))})}));
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT name, COUNT(*) FROM test_customer3 \nWHERE ds = '2021-07-11' GROUP BY 1", this.aggregationPlanWithNoStreaming("test_customer3", true, "name"));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_customer3");
        }
    }

    @Test
    public void testBucketedByPrefixOfSortedKeys() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_customer4 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey', 'name'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT custkey, name, COUNT(*) FROM test_customer4 \nWHERE ds = '2021-07-11' GROUP BY 1, 2", PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"custkey", "name"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (List)ImmutableList.of())), (List)ImmutableList.of((Object)"custkey", (Object)"name"), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"test_customer4", (Map)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"name", (Object)"name")))})}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_customer4");
        }
    }

    @Test
    public void testSortedByPrefixOfBucketedKeys() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_customer5 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey', 'name'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT custkey, COUNT(*) FROM test_customer5 \nWHERE ds = '2021-07-11' GROUP BY 1", this.aggregationPlanWithNoStreaming("test_customer5", false, "custkey"));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_customer5");
        }
    }

    @Test
    public void testGroupbySameKeysOfSortedbyKeys() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_customer6 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey', 'name'], \n  sorted_by = ARRAY['custkey', 'name'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT custkey, name, COUNT(*) FROM test_customer6 \nWHERE ds = '2021-07-11' GROUP BY 1, 2", PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"custkey", "name"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (List)ImmutableList.of())), (List)ImmutableList.of((Object)"custkey", (Object)"name"), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"test_customer6", (Map)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"name", (Object)"name")))})}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_customer6");
        }
    }

    @Test
    public void testGroupbySameKeysOfSortedbyKeysWithReverseOrder() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_customer6_2 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey', 'name'], \n  sorted_by = ARRAY['custkey', 'name'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT name, custkey, COUNT(*) FROM test_customer6_2 \nWHERE ds = '2021-07-11' GROUP BY 1, 2", PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"custkey", "name"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (List)ImmutableList.of())), (List)ImmutableList.of((Object)"custkey", (Object)"name"), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"test_customer6_2", (Map)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"name", (Object)"name")))})}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_customer6_2");
        }
    }

    @Test
    public void testGroupbyKeysNotPrefixOfSortedKeys() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_customer8 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey', 'name'], \n  sorted_by = ARRAY['custkey', 'name'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT name, COUNT(*) FROM test_customer8 \nWHERE ds = '2021-07-11' GROUP BY 1", this.aggregationPlanWithNoStreaming("test_customer8", true, "name"));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_customer8");
        }
    }

    @Test
    public void testGroupbyKeysPrefixOfSortedKeys() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_customer9 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey', 'name'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT custkey, COUNT(*) FROM test_customer9 \nWHERE ds = '2021-07-11' GROUP BY 1", PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"custkey"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (List)ImmutableList.of())), (List)ImmutableList.of((Object)"custkey"), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"test_customer9", (Map)ImmutableMap.of((Object)"custkey", (Object)"custkey")))})}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_customer9");
        }
    }

    @Test
    public void testQueryingMultiplePartitions() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_customer10 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            queryRunner.execute("INSERT INTO test_customer10 \nSELECT *, '2021-07-12' as ds FROM tpch.sf1.customer LIMIT 1000");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT custkey, COUNT(*) FROM test_customer10 \nWHERE ds = '2021-07-11' or ds = '2021-07-12' GROUP BY 1", this.aggregationPlanWithNoStreaming("test_customer10", false, "custkey"));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_customer10");
        }
    }

    private Session orderBasedExecutionEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "order_based_execution_enabled", "true").build();
    }

    private PlanMatchPattern aggregationPlanWithNoStreaming(String tableName, boolean hasProject, String ... groupingKeys) {
        ImmutableMap.Builder columnReferencesBuilder = ImmutableMap.builder();
        for (String groupingKey : groupingKeys) {
            columnReferencesBuilder.put((Object)groupingKey, (Object)groupingKey);
        }
        PlanMatchPattern tableScanPattern = PlanMatchPattern.tableScan((String)tableName, (Map)columnReferencesBuilder.build());
        return PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])groupingKeys), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (boolean)false, (List)ImmutableList.of((Object)PlanMatchPattern.anySymbol()))), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.FINAL, (PlanMatchPattern)PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])groupingKeys), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (List)ImmutableList.of())), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.PARTIAL, (PlanMatchPattern)(hasProject ? PlanMatchPattern.node(ProjectNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{tableScanPattern}) : tableScanPattern))})}))});
    }
}

