/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.PartitionMutator;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePageSinkMetadata;
import com.facebook.presto.hive.metastore.HivePartitionMutator;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.thrift.BridgingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.TestingHiveCluster;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastore;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorCommitHandle;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.fs.Path;

public class TestingSemiTransactionalHiveMetastore
extends SemiTransactionalHiveMetastore {
    private static final String HOST = "dummy";
    private static final int PORT = 1111;
    private final Map<HiveTableHandle, Table> tablesMap = new HashMap<HiveTableHandle, Table>();
    private final Map<HiveTableHandle, List<String>> partitionsMap = new HashMap<HiveTableHandle, List<String>>();
    private List<String> partitionNames;

    private TestingSemiTransactionalHiveMetastore(HdfsEnvironment hdfsEnvironment, ExtendedHiveMetastore delegate, ListeningExecutorService renameExecutor, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, boolean undoMetastoreOperationsEnabled, ColumnConverterProvider columnConverterProvider) {
        super(hdfsEnvironment, delegate, renameExecutor, skipDeletionForAlter, skipTargetCleanupOnRollback, undoMetastoreOperationsEnabled, columnConverterProvider);
    }

    public static TestingSemiTransactionalHiveMetastore create() {
        HiveClientConfig config = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(config, metastoreClientConfig), (Set)ImmutableSet.of(), config);
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        TestingHiveCluster hiveCluster = new TestingHiveCluster(metastoreClientConfig, HOST, 1111);
        HiveColumnConverterProvider columnConverterProvider = HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER;
        BridgingHiveMetastore delegate = new BridgingHiveMetastore((HiveMetastore)new ThriftHiveMetastore((HiveCluster)hiveCluster, metastoreClientConfig, hdfsEnvironment), (PartitionMutator)new HivePartitionMutator());
        ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-%s"));
        ListeningExecutorService renameExecutor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        return new TestingSemiTransactionalHiveMetastore(hdfsEnvironment, (ExtendedHiveMetastore)delegate, renameExecutor, false, false, true, (ColumnConverterProvider)columnConverterProvider);
    }

    public void addTable(String database, String tableName, Table table, List<String> partitions) {
        HiveTableHandle hiveTableHandle = new HiveTableHandle(database, tableName);
        this.tablesMap.put(hiveTableHandle, table);
        this.partitionsMap.put(hiveTableHandle, partitions);
        this.partitionNames = partitions;
    }

    public synchronized List<String> getAllDatabases(MetastoreContext metastoreContext) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized Optional<Database> getDatabase(MetastoreContext metastoreContext, String databaseName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized Optional<List<String>> getAllTables(MetastoreContext metastoreContext, String databaseName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized Optional<Table> getTable(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return this.getTable(metastoreContext, new HiveTableHandle(databaseName, tableName));
    }

    public Optional<Table> getTable(MetastoreContext metastoreContext, HiveTableHandle hiveTableHandle) {
        return Optional.ofNullable(this.tablesMap.get(hiveTableHandle));
    }

    public synchronized Set<ColumnStatisticType> getSupportedColumnStatistics(MetastoreContext metastoreContext, Type type) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized PartitionStatistics getTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized Map<String, PartitionStatistics> getPartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Set<String> partitionNames) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized HivePageSinkMetadata generatePageSinkMetadata(MetastoreContext metastoreContext, SchemaTableName schemaTableName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized Optional<List<String>> getAllViews(MetastoreContext metastoreContext, String databaseName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void createDatabase(MetastoreContext metastoreContext, Database database) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void dropDatabase(MetastoreContext metastoreContext, String schemaName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void renameDatabase(MetastoreContext metastoreContext, String source, String target) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void setTableStatistics(MetastoreContext metastoreContext, Table table, PartitionStatistics tableStatistics) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void setPartitionStatistics(MetastoreContext metastoreContext, Table table, Map<List<String>, PartitionStatistics> partitionStatisticsMap) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void createTable(ConnectorSession session, Table table, PrincipalPrivileges principalPrivileges, Optional<Path> currentPath, boolean ignoreExisting, PartitionStatistics statistics) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void dropTable(HdfsContext context, String databaseName, String tableName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void replaceView(MetastoreContext metastoreContext, String databaseName, String tableName, Table table, PrincipalPrivileges principalPrivileges) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void renameTable(MetastoreContext metastoreContext, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void addColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void renameColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void dropColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String columnName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void finishInsertIntoExistingTable(ConnectorSession session, String databaseName, String tableName, Path currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void truncateUnpartitionedTable(ConnectorSession session, String databaseName, String tableName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void setPartitionNames(List<String> partitionNames) {
        this.partitionNames = partitionNames;
    }

    public synchronized Optional<List<String>> getPartitionNames(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return Optional.ofNullable(this.partitionNames);
    }

    public synchronized Optional<List<String>> getPartitionNamesByFilter(MetastoreContext metastoreContext, HiveTableHandle hiveTableHandle, Map<Column, Domain> effectivePredicate) {
        return Optional.ofNullable(this.partitionsMap.get(hiveTableHandle));
    }

    public synchronized Optional<Partition> getPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionValues) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized Map<String, Optional<Partition>> getPartitionsByNames(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionNames) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void addPartition(ConnectorSession session, String databaseName, String tableName, String tablePath, boolean isNewTable, Partition partition, Path currentLocation, PartitionStatistics statistics) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void dropPartition(ConnectorSession session, String databaseName, String tableName, String tablePath, List<String> partitionValues) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void finishInsertIntoExistingPartition(ConnectorSession session, String databaseName, String tableName, String tablePath, List<String> partitionValues, Path currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void createRole(MetastoreContext metastoreContext, String role, String grantor) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void dropRole(MetastoreContext metastoreContext, String role) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized Set<String> listRoles(MetastoreContext metastoreContext) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void grantRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, PrestoPrincipal grantor) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void revokeRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, PrestoPrincipal grantor) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized Set<RoleGrant> listRoleGrants(MetastoreContext metastoreContext, PrestoPrincipal principal) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized Set<HivePrivilegeInfo> listTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal principal) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void grantTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void revokeTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void declareIntentionToWrite(HdfsContext context, MetastoreContext metastoreContext, LocationHandle.WriteMode writeMode, Path stagingPathRoot, Optional<Path> tempPathRoot, SchemaTableName schemaTableName, boolean temporaryTable) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized ConnectorCommitHandle commit() {
        throw new UnsupportedOperationException("method not implemented");
    }

    public synchronized void rollback() {
        throw new UnsupportedOperationException("method not implemented");
    }
}

