/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.benchmark;

import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.benchmark.FileFormat;
import com.facebook.presto.hive.benchmark.HiveFileFormatBenchmark;
import java.io.IOException;
import org.testng.annotations.Test;

public class TestHiveFileFormatBenchmark {
    @Test
    public void testSomeFormats() throws Exception {
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.LINEITEM, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.LINEITEM, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_ORC);
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.LINEITEM, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_PAGE);
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.LINEITEM, HiveCompressionCodec.SNAPPY, FileFormat.HIVE_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_ORC);
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_PAGE);
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.HIVE_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.LARGE_MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.LARGE_MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_ORC);
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.LARGE_MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_PAGE);
        TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.LARGE_MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.HIVE_RCBINARY);
    }

    @Test
    public void testAllCompression() throws Exception {
        for (HiveCompressionCodec codec : HiveCompressionCodec.values()) {
            TestHiveFileFormatBenchmark.executeBenchmark(HiveFileFormatBenchmark.DataSet.LINEITEM, codec, FileFormat.PRESTO_RCBINARY);
        }
    }

    @Test
    public void testAllDataSets() throws Exception {
        for (HiveFileFormatBenchmark.DataSet dataSet : HiveFileFormatBenchmark.DataSet.values()) {
            TestHiveFileFormatBenchmark.executeBenchmark(dataSet, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_RCBINARY);
        }
    }

    private static void executeBenchmark(HiveFileFormatBenchmark.DataSet dataSet, HiveCompressionCodec codec, FileFormat format) throws IOException {
        HiveFileFormatBenchmark benchmark = new HiveFileFormatBenchmark(dataSet, codec, format);
        try {
            benchmark.setup();
            benchmark.read(new HiveFileFormatBenchmark.CompressionCounter());
            benchmark.write(new HiveFileFormatBenchmark.CompressionCounter());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed " + (Object)((Object)dataSet) + " " + codec + " " + (Object)((Object)format), e);
        }
        finally {
            benchmark.tearDown();
        }
    }
}

