/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.containers;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.testing.containers.BaseTestContainer;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.containers.Network;

public class HiveHadoopContainer
extends BaseTestContainer {
    private static final Logger log = Logger.get(HiveHadoopContainer.class);
    private static final String IMAGE_VERSION = "10";
    public static final String DEFAULT_IMAGE = "prestodb/hdp2.6-hive:10";
    public static final String HIVE3_IMAGE = "prestodb/hive3.1-hive:10";
    public static final String HOST_NAME = "hadoop-master";
    public static final int PROXY_PORT = 1180;
    public static final int HIVE_SERVER_PORT = 10000;
    public static final int HIVE_METASTORE_PORT = 9083;

    public static Builder builder() {
        return new Builder();
    }

    private HiveHadoopContainer(String image, String hostName, Set<Integer> ports, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int startupRetryLimit) {
        super(image, hostName, ports, filesToMount, envVars, network, startupRetryLimit);
    }

    protected void startContainer() {
        super.startContainer();
        log.info(String.format("HiveHadoop container started with address for HiveServer: http://%s, HiveMetastore: http://%s and SocksProxy: http://%s", this.getHiveServerEndpoint().toString(), this.getHiveMetastoreEndpoint().toString(), this.getMappedHdfsSocksProxy().toString()));
    }

    public HostAndPort getMappedHdfsSocksProxy() {
        return this.getMappedHostAndPortForExposedPort(1180);
    }

    public HostAndPort getHiveServerEndpoint() {
        return this.getMappedHostAndPortForExposedPort(10000);
    }

    public HostAndPort getHiveMetastoreEndpoint() {
        return this.getMappedHostAndPortForExposedPort(9083);
    }

    public static class Builder
    extends BaseTestContainer.Builder<Builder, HiveHadoopContainer> {
        private Builder() {
            this.image = HiveHadoopContainer.DEFAULT_IMAGE;
            this.hostName = HiveHadoopContainer.HOST_NAME;
            this.exposePorts = ImmutableSet.of((Object)9083, (Object)1180);
        }

        public HiveHadoopContainer build() {
            return new HiveHadoopContainer(this.image, this.hostName, this.exposePorts, this.filesToMount, this.envVars, this.network, this.startupRetryLimit);
        }
    }
}

