/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.containers;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.facebook.presto.hive.containers.HiveHadoopContainer;
import com.facebook.presto.testing.containers.MinIOContainer;
import com.facebook.presto.util.AutoCloseableCloser;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testcontainers.containers.Network;

public class HiveMinIODataLake
implements Closeable {
    public static final String ACCESS_KEY = "accesskey";
    public static final String SECRET_KEY = "secretkey";
    private final String bucketName;
    private final MinIOContainer minIOContainer;
    private final HiveHadoopContainer hiveHadoopContainer;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final AutoCloseableCloser closer = AutoCloseableCloser.create();

    public HiveMinIODataLake(String bucketName, Map<String, String> hiveHadoopFilesToMount) {
        this(bucketName, hiveHadoopFilesToMount, "prestodb/hdp2.6-hive:10");
    }

    public HiveMinIODataLake(String bucketName, Map<String, String> hiveHadoopFilesToMount, String hiveHadoopImage) {
        this.bucketName = Objects.requireNonNull(bucketName, "bucketName is null");
        Network network = (Network)this.closer.register((AutoCloseable)Network.newNetwork());
        this.minIOContainer = (MinIOContainer)this.closer.register((AutoCloseable)((MinIOContainer.Builder)((MinIOContainer.Builder)MinIOContainer.builder().withNetwork(network)).withEnvVars((Map)ImmutableMap.builder().put((Object)"MINIO_ACCESS_KEY", (Object)ACCESS_KEY).put((Object)"MINIO_SECRET_KEY", (Object)SECRET_KEY).build())).build());
        ImmutableMap.Builder filesToMount = ImmutableMap.builder().putAll(hiveHadoopFilesToMount);
        String hadoopCoreSitePath = "/etc/hadoop/conf/core-site.xml";
        if (hiveHadoopImage == "prestodb/hive3.1-hive:10") {
            hadoopCoreSitePath = "/opt/hadoop/etc/hadoop/core-site.xml";
            filesToMount.put((Object)"hive_s3_insert_overwrite/hive-site.xml", (Object)"/opt/hive/conf/hive-site.xml");
        }
        filesToMount.put((Object)"hive_s3_insert_overwrite/hadoop-core-site.xml", (Object)hadoopCoreSitePath);
        this.hiveHadoopContainer = (HiveHadoopContainer)((Object)this.closer.register((AutoCloseable)((Object)((HiveHadoopContainer.Builder)((HiveHadoopContainer.Builder)((HiveHadoopContainer.Builder)HiveHadoopContainer.builder().withFilesToMount((Map)filesToMount.build())).withImage(hiveHadoopImage)).withNetwork(network)).build())));
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        try {
            this.minIOContainer.start();
            this.hiveHadoopContainer.start();
            AmazonS3 s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration("http://localhost:" + this.minIOContainer.getMinioApiEndpoint().getPort(), "us-east-1"))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(ACCESS_KEY, SECRET_KEY)))).build();
            s3Client.createBucket(this.bucketName);
        }
        finally {
            this.isStarted.set(true);
        }
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.closer.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop HiveMinioDataLake", e);
        }
        finally {
            this.isStarted.set(false);
        }
    }

    public MinIOContainer getMinio() {
        return this.minIOContainer;
    }

    public HiveHadoopContainer getHiveHadoop() {
        return this.hiveHadoopContainer;
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }
}

