/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.geospatial;

import com.facebook.presto.Session;
import com.facebook.presto.geospatial.TestGeoRelations;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HivePlugin;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.file.FileHiveMetastore;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.Test;
import org.testng.internal.collections.Pair;

public class TestSpatialJoins
extends AbstractTestQueryFramework {
    private static final String POLYGONS_SQL = "VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)";
    private static final String POINTS_SQL = "VALUES (-0.1, -0.1, 'x', 1), (2.1, 2.1, 'y', 2), (7.1, 7.2, 'z', 3), (null, 1.2, 'null', 4)";

    private static String getRelationalGeometriesSql() {
        StringBuilder sql = new StringBuilder("VALUES ");
        for (int i = 0; i < TestGeoRelations.RELATION_GEOMETRIES_WKT.size(); ++i) {
            sql.append(String.format("(%s, %s)", TestGeoRelations.RELATION_GEOMETRIES_WKT.get(i), i));
            if (i == TestGeoRelations.RELATION_GEOMETRIES_WKT.size() - 1) continue;
            sql.append(", ");
        }
        return sql.toString();
    }

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = new DistributedQueryRunner(TestingSession.testSessionBuilder().setSource(TestSpatialJoins.class.getSimpleName()).setCatalog("hive").setSchema("default").build(), 4);
        File dataDirectory = queryRunner.getCoordinator().getDataDirectory().resolve("hive_data").toFile();
        HiveClientConfig hiveClientConfig = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(hiveClientConfig, metastoreClientConfig), (Set)ImmutableSet.of(), hiveClientConfig);
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        FileHiveMetastore metastore = new FileHiveMetastore(hdfsEnvironment, dataDirectory.toURI().toString(), "test");
        HiveColumnConverterProvider columnConverterProvider = HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER;
        metastore.createDatabase(new MetastoreContext("test_user", "test_queryId", Optional.empty(), Optional.empty(), Optional.empty(), false, (ColumnConverterProvider)columnConverterProvider), Database.builder().setDatabaseName("default").setOwnerName("public").setOwnerType(PrincipalType.ROLE).build());
        queryRunner.installPlugin((Plugin)new HivePlugin("hive", Optional.of(metastore)));
        queryRunner.createCatalog("hive", "hive");
        return queryRunner;
    }

    @Test
    public void testBroadcastSpatialJoinContains() {
        this.testSpatialJoinContains(this.getSession());
    }

    @Test
    public void testDistributedSpatialJoinContains() {
        this.assertUpdate(String.format("CREATE TABLE contains_partitioning AS SELECT spatial_partitioning(ST_GeometryFromText(wkt)) as v FROM (%s) as a (wkt, name, id)", POLYGONS_SQL), 1L);
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("spatial_partitioning_table_name", "contains_partitioning").build();
        this.testSpatialJoinContains(session);
    }

    private void testSpatialJoinContains(Session session) {
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES (-0.1, -0.1, 'x', 1), (2.1, 2.1, 'y', 2), (7.1, 7.2, 'z', 3), (null, 1.2, 'null', 4)) AS a (latitude, longitude, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(longitude, latitude))", "SELECT * FROM (VALUES ('a', 'x'), ('b', 'y'), ('c', 'y'), ('d', 'z'))");
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES (-0.1, -0.1, 'x', 1), (2.1, 2.1, 'y', 2), (7.1, 7.2, 'z', 3), (null, 1.2, 'null', 4)) AS a (latitude, longitude, name, id) JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Contains(ST_GeometryFromText(wkt), ST_Point(longitude, latitude))", "SELECT * FROM (VALUES ('a', 'x'), ('b', 'y'), ('c', 'y'), ('d', 'z'))");
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "SELECT * FROM (VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('c', 'b'))");
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "SELECT * FROM (VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('c', 'b'))");
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id), (VALUES (-0.1, -0.1, 'x', 1), (2.1, 2.1, 'y', 2), (7.1, 7.2, 'z', 3), (null, 1.2, 'null', 4)) AS a (latitude, longitude, name, id) WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(longitude, latitude))", "SELECT * FROM (VALUES ('a', 'x'), ('b', 'y'), ('c', 'y'), ('d', 'z'))");
        this.assertQuery(session, "SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Contains(ST_GeometryFromText(a.wkt), ST_GeometryFromText(b.wkt))", "SELECT * FROM (VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('b', 'c'))");
    }

    @Test
    public void testBroadcastSpatialJoinContainsWithExtraConditions() {
        this.assertQuery("SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt)) AND a.name != b.name", "SELECT * FROM (VALUES ('c', 'b'))");
        this.assertQuery("SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt)) AND a.name != b.name", "SELECT * FROM (VALUES ('c', 'b'))");
    }

    @Test
    public void testBroadcastSpatialJoinContainsWithStatefulExtraCondition() {
        String pointsX = TestSpatialJoins.generatePointsSql(0.0, 0.0, 1.0, 1.0, 10000, "x");
        String pointsY = TestSpatialJoins.generatePointsSql(2.0, 2.0, 2.5, 2.5, 10000, "y");
        this.assertQuery("SELECT b.name, a.name FROM (" + pointsX + " UNION ALL " + pointsY + ") AS a (latitude, longitude, name, id), (" + POLYGONS_SQL + ") AS b (wkt, name, id) WHERE ST_Contains(ST_GeometryFromText(wkt), ST_Point(longitude, latitude)) AND stateful_sleeping_sum(0.001, 100, a.id, b.id) <= 3", "SELECT * FROM (VALUES ('a', 'x1'), ('a', 'x2'), ('b', 'y1'))");
    }

    private static String generatePointsSql(double minX, double minY, double maxX, double maxY, int pointCount, String prefix) {
        return String.format("SELECT %s + n * %f, %s + n * %f, '%s' || CAST (n AS VARCHAR), n FROM (SELECT sequence(1, %s) as numbers) CROSS JOIN UNNEST (numbers) AS t(n)", minX, (maxX - minX) / (double)pointCount, minY, (maxY - minY) / (double)pointCount, prefix, pointCount);
    }

    @Test
    public void testBroadcastSpatialJoinContainsWithEmptyBuildSide() {
        this.assertQueryReturnsEmptyResult("SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE b.name = 'invalid' AND ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))");
    }

    @Test
    public void testBroadcastSpatialJoinContainsWithEmptyProbeSide() {
        this.assertQueryReturnsEmptyResult("SELECT b.name, a.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE a.name = 'invalid' AND ST_Contains(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))");
    }

    @Test
    public void testBroadcastSpatialJoinIntersects() {
        this.testSpatialJoinIntersects(this.getSession());
    }

    @Test
    public void testDistributedSpatialJoinIntersects() {
        this.assertUpdate(String.format("CREATE TABLE intersects_partitioning AS SELECT spatial_partitioning(ST_GeometryFromText(wkt)) as v FROM (%s) as a (wkt, name, id)", POLYGONS_SQL), 1L);
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("spatial_partitioning_table_name", "intersects_partitioning").build();
        this.testSpatialJoinIntersects(session);
    }

    private void testSpatialJoinIntersects(Session session) {
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "SELECT * FROM VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c')");
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "SELECT * FROM VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c')");
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Intersects(ST_GeometryFromText(a.wkt), ST_GeometryFromText(b.wkt))", "SELECT * FROM VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c')");
    }

    @Test
    public void testBroadcastSpatialJoinIntersectsWithExtraConditions() {
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))    AND a.name != b.name", "SELECT * FROM VALUES ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c')");
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))    AND a.name != b.name", "SELECT * FROM VALUES ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c')");
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id), (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) WHERE ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))    AND a.name < b.name", "SELECT * FROM VALUES ('a', 'c'), ('b', 'c')");
    }

    @Test
    public void testBroadcastDistanceQuery() {
        this.testDistanceQuery(this.getSession());
    }

    @Test
    public void testDistributedDistanceQuery() {
        this.assertUpdate(String.format("CREATE TABLE distance_partitioning AS SELECT spatial_partitioning(ST_Point(x, y)) as v FROM (VALUES (0, 0, '0_0'), (1, 0, '1_0'), (3, 0, '3_0'), (10, 0, '10_0')) as a (x, y, name)", new Object[0]), 1L);
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("spatial_partitioning_table_name", "distance_partitioning").build();
        this.testDistanceQuery(session);
    }

    private void testDistanceQuery(Session session) {
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES (0, 0, '0_0'), (1, 0, '1_0'), (3, 0, '3_0'), (10, 0, '10_0')) as a (x, y, name), (VALUES (0, 1, '0_1'), (1, 1, '1_1'), (3, 1, '3_1'), (10, 1, '10_1')) as b (x, y, name) WHERE ST_Distance(ST_Point(a.x, a.y), ST_Point(b.x, b.y)) <= 1.5", "SELECT * FROM VALUES ('0_0', '0_1'), ('0_0', '1_1'), ('1_0', '0_1'), ('1_0', '1_1'), ('3_0', '3_1'), ('10_0', '10_1')");
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES (0, 0, '0_0'), (1, 0, '1_0'), (3, 0, '3_0'), (10, 0, '10_0')) as a (x, y, name), (VALUES (0, 1, '0_1'), (1, 1, '1_1'), (3, 1, '3_1'), (10, 1, '10_1')) as b (x, y, name) WHERE ST_Distance(ST_Point(b.x, b.y), ST_Point(a.x, a.y)) <= 1.5", "SELECT * FROM VALUES ('0_0', '0_1'), ('0_0', '1_1'), ('1_0', '0_1'), ('1_0', '1_1'), ('3_0', '3_1'), ('10_0', '10_1')");
        this.assertQuery(session, "SELECT a.name, b.name FROM (VALUES (0, 0, '0_0'), (1, 0, '1_0'), (3, 0, '3_0'), (10, 0, '10_0')) as a (x, y, name), (VALUES (0, 1, '0_1'), (1, 1, '1_1'), (3, 1, '3_1'), (10, 1, '10_1')) as b (x, y, name) WHERE ST_Distance(ST_Point(a.x, a.y), ST_Point(b.x, b.y)) <= sqrt(b.x * b.x + b.y * b.y)", "SELECT * FROM VALUES ('0_0', '0_1'), ('0_0', '1_1'), ('0_0', '3_1'), ('0_0', '10_1'), ('1_0', '1_1'), ('1_0', '3_1'), ('1_0', '10_1'), ('3_0', '3_1'), ('3_0', '10_1'), ('10_0', '10_1')");
    }

    @Test
    public void testBroadcastSpatialLeftJoin() {
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) LEFT JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "SELECT * FROM VALUES ('a', 'a'), ('b', 'b'), ('c', 'c'), ('d', 'd'), ('a', 'c'), ('c', 'a'), ('c', 'b'), ('b', 'c'), ('empty', null), ('null', null)");
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) LEFT JOIN (VALUES (null, 'null', 1)) AS b (wkt, name, id) ON ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "SELECT * FROM VALUES ('a', null), ('b', null), ('c', null), ('d', null), ('empty', null), ('null', null)");
        this.assertQuery("SELECT a.name, b.name FROM (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS a (wkt, name, id) LEFT JOIN (VALUES ('POLYGON ((-0.5 -0.6, 1.5 0, 1 1, 0 1, -0.5 -0.6))', 'a', 1), ('POLYGON ((2 2, 3 2, 2.5 3, 2 2))', 'b', 2), ('POLYGON ((0.8 0.7, 0.8 4, 5 4, 4.5 0.8, 0.8 0.7))', 'c', 3), ('POLYGON ((7 7, 11 7, 11 11, 7 7))', 'd', 4), ('POLYGON EMPTY', 'empty', 5), (null, 'null', 6)) AS b (wkt, name, id) ON a.name > b.name AND ST_Intersects(ST_GeometryFromText(b.wkt), ST_GeometryFromText(a.wkt))", "SELECT * FROM VALUES ('a', null), ('b', null), ('c', 'a'), ('c', 'b'), ('d', null), ('empty', null), ('null', null)");
    }

    private void testRelationshipSpatialJoin(Session session, String relation, List<Pair<Integer, Integer>> expectedPairs) {
        String whereClause;
        StringBuilder expected = new StringBuilder("SELECT * FROM VALUES ");
        for (int i = 0; i < expectedPairs.size(); ++i) {
            Pair<Integer, Integer> pair = expectedPairs.get(i);
            expected.append(String.format("(%d, %d)", pair.first(), pair.second()));
            if (i == expectedPairs.size() - 1) continue;
            expected.append(", ");
        }
        switch (relation) {
            case "ST_Contains": {
                whereClause = "WHERE a.id != b.id";
                break;
            }
            case "ST_Equals": {
                whereClause = "";
                break;
            }
            default: {
                whereClause = "WHERE a.id < b.id";
            }
        }
        this.assertQuery(session, String.format("SELECT a.id, b.id FROM (%s) AS a (wkt, id) JOIN (%s) AS b (wkt, id) ON %s(ST_GeometryFromText(a.wkt), ST_GeometryFromText(b.wkt)) %s", TestSpatialJoins.getRelationalGeometriesSql(), TestSpatialJoins.getRelationalGeometriesSql(), relation, whereClause), expected.toString());
    }

    @Test
    public void testRelationshipBroadcastSpatialJoin() {
        this.testRelationshipSpatialJoin(this.getSession(), "ST_Equals", TestGeoRelations.EQUALS_PAIRS);
        this.testRelationshipSpatialJoin(this.getSession(), "ST_Contains", TestGeoRelations.CONTAINS_PAIRS);
        this.testRelationshipSpatialJoin(this.getSession(), "ST_Touches", TestGeoRelations.TOUCHES_PAIRS);
        this.testRelationshipSpatialJoin(this.getSession(), "ST_Overlaps", TestGeoRelations.OVERLAPS_PAIRS);
        this.testRelationshipSpatialJoin(this.getSession(), "ST_Crosses", TestGeoRelations.CROSSES_PAIRS);
    }

    @Test
    public void testSphericalSpatialJoin() {
        double tooSmallRadius = 10.0;
        double sufficientRadius = 111200.0;
        this.assertSphericalSpatialJoin("<", sufficientRadius, true);
        this.assertSphericalSpatialJoin("<", tooSmallRadius, false);
        this.assertSphericalSpatialJoin("<=", sufficientRadius, true);
        this.assertSphericalSpatialJoin("<=", tooSmallRadius, false);
    }

    private void assertSphericalSpatialJoin(String comparison, double radius, boolean shouldMatch) {
        String expected = shouldMatch ? "SELECT 'p0', 'p1'" : "SELECT * FROM (VALUES 1) LIMIT 0";
        this.assertQuery(String.format("SELECT a.name, b.name FROM ( VALUES (to_spherical_geography(ST_Point(0, 0)), 'p0') ) as a(point, name) JOIN ( VALUES (to_spherical_geography(ST_Point(0, 1)), 'p1') ) as b(point, name) ON ST_Distance(a.point, b.point) %s %s", comparison, radius), expected);
    }
}

