/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.hudi;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.hudi.HudiTestingDataGenerator;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.file.FileHiveMetastore;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class HudiTestUtils {
    private static final Logger log = Logger.get(HudiTestUtils.class);
    public static final String DATA_DIR = "data";

    private HudiTestUtils() {
    }

    public static DistributedQueryRunner createQueryRunner(Map<String, String> serverConfig, Map<String, String> connectorConfig, Function<Optional<ExtendedHiveMetastore>, Plugin> connectorPluginFactory, String connectorName, String catalogName, String defaultSchema) throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog(catalogName).setSchema(defaultSchema).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setExtraProperties(serverConfig).build();
        Path catalogDirectory = queryRunner.getCoordinator().getDataDirectory().resolve("catalog");
        ExtendedHiveMetastore metastore = HudiTestUtils.createFileHiveMetastore(catalogDirectory.toString());
        Path testingDataDirectory = queryRunner.getCoordinator().getDataDirectory().resolve(DATA_DIR);
        HudiTestingDataGenerator generator = new HudiTestingDataGenerator(metastore, defaultSchema, testingDataDirectory);
        generator.generateData();
        generator.generateMetadata();
        queryRunner.installPlugin(connectorPluginFactory.apply(Optional.of(metastore)));
        queryRunner.createCatalog(catalogName, connectorName, connectorConfig);
        log.info("Using %s as catalog directory ", new Object[]{catalogDirectory});
        log.info("Using %s as testing data directory", new Object[]{testingDataDirectory});
        return queryRunner;
    }

    private static ExtendedHiveMetastore createFileHiveMetastore(String catalogDir) {
        HiveClientConfig hiveClientConfig = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(hiveClientConfig, metastoreClientConfig), (Set)ImmutableSet.of(), hiveClientConfig);
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        return new FileHiveMetastore(hdfsEnvironment, catalogDir, "test");
    }
}

