/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.hudi;

import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.security.PrincipalType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;

public class HudiTestingDataGenerator {
    private static final String OWNER_PUBLIC = "public";
    private static final MetastoreContext METASTORE_CONTEXT = new MetastoreContext("test_user", "test_queryId", Optional.empty(), Optional.empty(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
    private static final PrincipalPrivileges PRINCIPAL_PRIVILEGES = new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of());
    private static final StorageFormat STORAGE_FORMAT_COPY_ON_WRITE = StorageFormat.create((String)ParquetHiveSerDe.class.getName(), (String)HoodieParquetInputFormat.class.getName(), (String)MapredParquetOutputFormat.class.getName());
    private static final StorageFormat STORAGE_FORMAT_MERGE_ON_READ = StorageFormat.create((String)ParquetHiveSerDe.class.getName(), (String)HoodieParquetRealtimeInputFormat.class.getName(), (String)MapredParquetOutputFormat.class.getName());
    public static final List<Column> DATA_COLUMNS = ImmutableList.of((Object)HudiTestingDataGenerator.column("volume", HiveType.HIVE_LONG), (Object)HudiTestingDataGenerator.column("ts", HiveType.HIVE_STRING), (Object)HudiTestingDataGenerator.column("symbol", HiveType.HIVE_STRING), (Object)HudiTestingDataGenerator.column("year", HiveType.HIVE_INT), (Object)HudiTestingDataGenerator.column("month", HiveType.HIVE_STRING), (Object)HudiTestingDataGenerator.column("high", HiveType.HIVE_DOUBLE), (Object)HudiTestingDataGenerator.column("low", HiveType.HIVE_DOUBLE), (Object)HudiTestingDataGenerator.column("key", HiveType.HIVE_STRING), (Object)HudiTestingDataGenerator.column("date", HiveType.HIVE_STRING), (Object)HudiTestingDataGenerator.column("close", HiveType.HIVE_DOUBLE), (Object)HudiTestingDataGenerator.column("open", HiveType.HIVE_DOUBLE), (Object)HudiTestingDataGenerator.column("day", HiveType.HIVE_STRING), (Object[])new Column[0]);
    public static final List<Column> PARTITION_COLUMNS = ImmutableList.of((Object)HudiTestingDataGenerator.column("dt", HiveType.HIVE_STRING));
    public static final List<Column> HUDI_META_COLUMNS = ImmutableList.of((Object)HudiTestingDataGenerator.column("_hoodie_commit_time", HiveType.HIVE_STRING), (Object)HudiTestingDataGenerator.column("_hoodie_commit_seqno", HiveType.HIVE_STRING), (Object)HudiTestingDataGenerator.column("_hoodie_record_key", HiveType.HIVE_STRING), (Object)HudiTestingDataGenerator.column("_hoodie_partition_path", HiveType.HIVE_STRING), (Object)HudiTestingDataGenerator.column("_hoodie_file_name", HiveType.HIVE_STRING));
    private final Path dataDirectory;
    private final ExtendedHiveMetastore metastore;
    private final String schemaName;

    public HudiTestingDataGenerator(ExtendedHiveMetastore metastore, String schemaName, Path dataDirectory) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.schemaName = Objects.requireNonNull(schemaName, "catalogName is null");
        this.dataDirectory = Objects.requireNonNull(dataDirectory, "dataDirectory is null");
    }

    public void generateData() {
        try (InputStream stream = Resources.getResource((String)"hudi-testing-data.zip").openStream();){
            HudiTestingDataGenerator.unzip(stream, this.dataDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void generateMetadata() {
        Database database = Database.builder().setDatabaseName(this.schemaName).setOwnerName(OWNER_PUBLIC).setOwnerType(PrincipalType.ROLE).build();
        this.metastore.createDatabase(METASTORE_CONTEXT, database);
        this.createTable(HoodieTableType.COPY_ON_WRITE, "stock_ticks_cow", "stock_ticks_cow", true);
        this.addPartition(HoodieTableType.COPY_ON_WRITE, "stock_ticks_cow", (List<String>)ImmutableList.of((Object)"dt=2018-08-31"), "stock_ticks_cow/2018/08/31");
        this.createTable(HoodieTableType.COPY_ON_WRITE, "stock_ticks_mor_ro", "stock_ticks_mor", true);
        this.addPartition(HoodieTableType.COPY_ON_WRITE, "stock_ticks_mor_ro", (List<String>)ImmutableList.of((Object)"dt=2018-08-31"), "stock_ticks_mor/2018/08/31");
        this.createTable(HoodieTableType.MERGE_ON_READ, "stock_ticks_mor_rt", "stock_ticks_mor", true);
        this.addPartition(HoodieTableType.MERGE_ON_READ, "stock_ticks_mor_rt", (List<String>)ImmutableList.of((Object)"dt=2018-08-31"), "stock_ticks_mor/2018/08/31");
        this.createTable(HoodieTableType.COPY_ON_WRITE, "stock_ticks_cown", this.dataDirectory.resolve("stock_ticks_cown").toString(), false);
        this.createTable(HoodieTableType.COPY_ON_WRITE, "stock_ticks_morn_ro", this.dataDirectory.resolve("stock_ticks_morn").toString(), false);
        this.createTable(HoodieTableType.MERGE_ON_READ, "stock_ticks_morn_rt", this.dataDirectory.resolve("stock_ticks_morn").toString(), false);
        this.createTable(HoodieTableType.COPY_ON_WRITE, "stock_ticks_morn_only_log_ro", this.dataDirectory.resolve("stock_ticks_morn_only_log").toString(), false);
        this.createTable(HoodieTableType.MERGE_ON_READ, "stock_ticks_morn_only_log_rt", this.dataDirectory.resolve("stock_ticks_morn_only_log").toString(), false);
    }

    private void createTable(HoodieTableType type, String name, String relativePath, boolean partitioned) {
        Table table = Table.builder().setDatabaseName(this.schemaName).setTableName(name).setTableType(PrestoTableType.EXTERNAL_TABLE).setOwner(OWNER_PUBLIC).setDataColumns(this.allDataColumns()).setPartitionColumns((List)(partitioned ? PARTITION_COLUMNS : ImmutableList.of())).setParameters((Map)ImmutableMap.of((Object)"serialization.format", (Object)"1", (Object)"EXTERNAL", (Object)"TRUE")).withStorage(HudiTestingDataGenerator.buildingStorage(type, "file://" + this.dataDirectory.resolve(relativePath))).build();
        this.metastore.createTable(METASTORE_CONTEXT, table, PRINCIPAL_PRIVILEGES);
    }

    private void addPartition(HoodieTableType type, String tableName, List<String> partitionNames, String relativePath) {
        ArrayList<PartitionWithStatistics> partitions = new ArrayList<PartitionWithStatistics>();
        for (String partitionName : partitionNames) {
            Partition partition = Partition.builder().setDatabaseName(this.schemaName).setTableName(tableName).setValues(MetastoreUtil.extractPartitionValues((String)partitionName)).withStorage(HudiTestingDataGenerator.buildingStorage(type, "file://" + this.dataDirectory.resolve(relativePath))).setColumns(this.allDataColumns()).setCreateTime(0).build();
            partitions.add(new PartitionWithStatistics(partition, partitionName, PartitionStatistics.empty()));
        }
        this.metastore.addPartitions(METASTORE_CONTEXT, this.schemaName, tableName, partitions);
    }

    private List<Column> allDataColumns() {
        return Streams.concat((Stream[])new Stream[]{HUDI_META_COLUMNS.stream(), DATA_COLUMNS.stream()}).collect(Collectors.toList());
    }

    private static Column column(String name, HiveType type) {
        return new Column(name, type, Optional.empty(), Optional.empty());
    }

    private static Consumer<Storage.Builder> buildingStorage(HoodieTableType tableType, String location) {
        return storageBuilder -> storageBuilder.setStorageFormat(HudiTestingDataGenerator.getStorageFormat(tableType)).setLocation(location);
    }

    private static StorageFormat getStorageFormat(HoodieTableType tableType) {
        if (tableType == HoodieTableType.COPY_ON_WRITE) {
            return STORAGE_FORMAT_COPY_ON_WRITE;
        }
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            return STORAGE_FORMAT_MERGE_ON_READ;
        }
        throw new IllegalArgumentException("Unsupported table type " + tableType);
    }

    private static void unzip(InputStream inputStream, Path destination) throws IOException {
        Files.createDirectories(destination, new FileAttribute[0]);
        try (ZipInputStream zipStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipStream.getNextEntry()) != null) {
                Path entryPath = destination.resolve(zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    Files.copy(zipStream, entryPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipStream.closeEntry();
            }
        }
    }
}

