/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.util.CollectionUtils;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.glue.TestingMetastoreObjects;
import com.facebook.presto.hive.metastore.glue.converter.GlueToPrestoConverter;
import com.facebook.presto.spi.security.PrincipalType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestGlueToPrestoConverter {
    private static final String PUBLIC_OWNER = "PUBLIC";
    private com.amazonaws.services.glue.model.Database testDb;
    private com.amazonaws.services.glue.model.Table testTbl;
    private com.amazonaws.services.glue.model.Partition testPartition;

    @BeforeMethod
    public void setup() {
        this.testDb = TestingMetastoreObjects.getGlueTestDatabase();
        this.testTbl = TestingMetastoreObjects.getGlueTestTable(this.testDb.getName());
        this.testPartition = TestingMetastoreObjects.getGlueTestPartition(this.testDb.getName(), this.testTbl.getName(), (List<String>)ImmutableList.of((Object)"val1"));
    }

    @Test
    public void testConvertDatabase() {
        Database prestoDb = GlueToPrestoConverter.convertDatabase((com.amazonaws.services.glue.model.Database)this.testDb);
        Assert.assertEquals((String)prestoDb.getDatabaseName(), (String)this.testDb.getName());
        Assert.assertEquals((String)((String)prestoDb.getLocation().get()), (String)this.testDb.getLocationUri());
        Assert.assertEquals((String)((String)prestoDb.getComment().get()), (String)this.testDb.getDescription());
        Assert.assertEquals((Map)prestoDb.getParameters(), (Map)this.testDb.getParameters());
        Assert.assertEquals((String)prestoDb.getOwnerName(), (String)PUBLIC_OWNER);
        Assert.assertEquals((Object)prestoDb.getOwnerType(), (Object)PrincipalType.ROLE);
    }

    @Test
    public void testConvertTable() {
        Table prestoTbl = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTbl, (String)this.testDb.getName());
        Assert.assertEquals((String)prestoTbl.getTableName(), (String)this.testTbl.getName());
        Assert.assertEquals((String)prestoTbl.getDatabaseName(), (String)this.testDb.getName());
        Assert.assertEquals((String)prestoTbl.getTableType().toString(), (String)this.testTbl.getTableType());
        Assert.assertEquals((String)prestoTbl.getOwner(), (String)this.testTbl.getOwner());
        Assert.assertEquals((Map)prestoTbl.getParameters(), (Map)this.testTbl.getParameters());
        TestGlueToPrestoConverter.assertColumnList(prestoTbl.getDataColumns(), this.testTbl.getStorageDescriptor().getColumns());
        TestGlueToPrestoConverter.assertColumnList(prestoTbl.getPartitionColumns(), this.testTbl.getPartitionKeys());
        TestGlueToPrestoConverter.assertStorage(prestoTbl.getStorage(), this.testTbl.getStorageDescriptor());
        Assert.assertEquals((String)((String)prestoTbl.getViewOriginalText().get()), (String)this.testTbl.getViewOriginalText());
        Assert.assertEquals((String)((String)prestoTbl.getViewExpandedText().get()), (String)this.testTbl.getViewExpandedText());
    }

    @Test
    public void testConvertTableNullPartitions() {
        this.testTbl.setPartitionKeys(null);
        Table prestoTbl = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTbl, (String)this.testDb.getName());
        Assert.assertTrue((boolean)prestoTbl.getPartitionColumns().isEmpty());
    }

    @Test
    public void testConvertTableUppercaseColumnType() {
        com.amazonaws.services.glue.model.Column uppercaseCol = TestingMetastoreObjects.getGlueTestColumn().withType("String");
        this.testTbl.getStorageDescriptor().setColumns((Collection)ImmutableList.of((Object)uppercaseCol));
        GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTbl, (String)this.testDb.getName());
    }

    @Test
    public void testConvertPartition() {
        GlueToPrestoConverter.GluePartitionConverter converter = new GlueToPrestoConverter.GluePartitionConverter(this.testPartition.getDatabaseName(), this.testPartition.getTableName());
        Partition prestoPartition = converter.apply(this.testPartition);
        Assert.assertEquals((String)prestoPartition.getDatabaseName(), (String)this.testPartition.getDatabaseName());
        Assert.assertEquals((String)prestoPartition.getTableName(), (String)this.testPartition.getTableName());
        TestGlueToPrestoConverter.assertColumnList(prestoPartition.getColumns(), this.testPartition.getStorageDescriptor().getColumns());
        Assert.assertEquals((Collection)prestoPartition.getValues(), (Collection)this.testPartition.getValues());
        TestGlueToPrestoConverter.assertStorage(prestoPartition.getStorage(), this.testPartition.getStorageDescriptor());
        Assert.assertEquals((Map)prestoPartition.getParameters(), (Map)this.testPartition.getParameters());
    }

    @Test
    public void testPartitionConversionMemoization() {
        String fakeS3Location = "s3://some-fake-location";
        this.testPartition.getStorageDescriptor().setLocation(fakeS3Location);
        com.amazonaws.services.glue.model.Partition partitionTwo = TestingMetastoreObjects.getGlueTestPartition(this.testPartition.getDatabaseName(), this.testPartition.getTableName(), new ArrayList<String>(this.testPartition.getValues()));
        partitionTwo.getStorageDescriptor().setColumns(new ArrayList(this.testPartition.getStorageDescriptor().getColumns()));
        partitionTwo.getStorageDescriptor().setBucketColumns(new ArrayList(this.testPartition.getStorageDescriptor().getBucketColumns()));
        partitionTwo.getStorageDescriptor().setLocation("" + fakeS3Location);
        partitionTwo.getStorageDescriptor().setInputFormat("" + this.testPartition.getStorageDescriptor().getInputFormat());
        partitionTwo.getStorageDescriptor().setOutputFormat("" + this.testPartition.getStorageDescriptor().getOutputFormat());
        partitionTwo.getStorageDescriptor().setParameters(new HashMap(this.testPartition.getStorageDescriptor().getParameters()));
        GlueToPrestoConverter.GluePartitionConverter converter = new GlueToPrestoConverter.GluePartitionConverter(this.testDb.getName(), this.testTbl.getName());
        Partition prestoPartition = converter.apply(this.testPartition);
        Partition prestoPartition2 = converter.apply(partitionTwo);
        Assert.assertNotSame((Object)prestoPartition, (Object)prestoPartition2);
        Assert.assertSame((Object)prestoPartition2.getDatabaseName(), (Object)prestoPartition.getDatabaseName());
        Assert.assertSame((Object)prestoPartition2.getTableName(), (Object)prestoPartition.getTableName());
        Assert.assertSame((Object)prestoPartition2.getColumns(), (Object)prestoPartition.getColumns());
        Assert.assertSame((Object)prestoPartition2.getParameters(), (Object)prestoPartition.getParameters());
        Assert.assertNotSame((Object)prestoPartition2.getValues(), (Object)prestoPartition.getValues());
        Storage storage = prestoPartition.getStorage();
        Storage storage2 = prestoPartition2.getStorage();
        Assert.assertSame((Object)storage2.getStorageFormat(), (Object)storage.getStorageFormat());
        Assert.assertSame((Object)storage2.getBucketProperty(), (Object)storage.getBucketProperty());
        Assert.assertSame((Object)storage2.getSerdeParameters(), (Object)storage.getSerdeParameters());
        Assert.assertNotSame((Object)storage2.getLocation(), (Object)storage.getLocation());
    }

    @Test
    public void testDatabaseNullParameters() {
        this.testDb.setParameters(null);
        Assert.assertNotNull((Object)GlueToPrestoConverter.convertDatabase((com.amazonaws.services.glue.model.Database)this.testDb).getParameters());
    }

    @Test
    public void testTableNullParameters() {
        this.testTbl.setParameters(null);
        this.testTbl.getStorageDescriptor().getSerdeInfo().setParameters(null);
        Table prestoTable = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTbl, (String)this.testDb.getName());
        Assert.assertNotNull((Object)prestoTable.getParameters());
        Assert.assertNotNull((Object)prestoTable.getStorage().getSerdeParameters());
    }

    @Test
    public void testPartitionNullParameters() {
        this.testPartition.setParameters(null);
        Assert.assertNotNull((Object)new GlueToPrestoConverter.GluePartitionConverter(this.testDb.getName(), this.testTbl.getName()).apply(this.testPartition).getParameters());
    }

    @Test
    public void testConvertTableWithoutTableType() {
        com.amazonaws.services.glue.model.Table table = TestingMetastoreObjects.getGlueTestTable(this.testDb.getName());
        table.setTableType(null);
        Table prestoTable = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)table, (String)this.testDb.getName());
        Assert.assertEquals((Object)prestoTable.getTableType(), (Object)PrestoTableType.EXTERNAL_TABLE);
    }

    @Test
    public void testIcebergTableNonNullStorageDescriptor() {
        this.testTbl.setParameters((Map)ImmutableMap.of((Object)"table_type", (Object)"iceberg"));
        Assert.assertNotNull((Object)this.testTbl.getStorageDescriptor());
        Table prestoTable = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTbl, (String)this.testDb.getName());
        Assert.assertEquals((int)prestoTable.getDataColumns().size(), (int)1);
    }

    @Test
    public void testDeltaTableNonNullStorageDescriptor() {
        this.testTbl.setParameters((Map)ImmutableMap.of((Object)"spark.sql.sources.provider", (Object)"delta"));
        Assert.assertNotNull((Object)this.testTbl.getStorageDescriptor());
        Table prestoTable = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTbl, (String)this.testDb.getName());
        Assert.assertEquals((int)prestoTable.getDataColumns().size(), (int)1);
    }

    private static void assertColumnList(List<Column> actual, List<com.amazonaws.services.glue.model.Column> expected) {
        if (expected == null) {
            Assert.assertNull(actual);
        }
        Assert.assertEquals((int)actual.size(), (int)expected.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestGlueToPrestoConverter.assertColumn(actual.get(i), expected.get(i));
        }
    }

    private static void assertColumn(Column actual, com.amazonaws.services.glue.model.Column expected) {
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((String)actual.getType().getHiveTypeName().toString(), (String)expected.getType());
        Assert.assertEquals((String)((String)actual.getComment().get()), (String)expected.getComment());
    }

    private static void assertStorage(Storage actual, StorageDescriptor expected) {
        Assert.assertEquals((String)actual.getLocation(), (String)expected.getLocation());
        Assert.assertEquals((String)actual.getStorageFormat().getSerDe(), (String)expected.getSerdeInfo().getSerializationLibrary());
        Assert.assertEquals((String)actual.getStorageFormat().getInputFormat(), (String)expected.getInputFormat());
        Assert.assertEquals((String)actual.getStorageFormat().getOutputFormat(), (String)expected.getOutputFormat());
        if (!CollectionUtils.isNullOrEmpty((Collection)expected.getBucketColumns())) {
            HiveBucketProperty bucketProperty = (HiveBucketProperty)actual.getBucketProperty().get();
            Assert.assertEquals((Collection)bucketProperty.getBucketedBy(), (Collection)expected.getBucketColumns());
            Assert.assertEquals((int)bucketProperty.getBucketCount(), (int)expected.getNumberOfBuckets());
        }
    }
}

