/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.Session;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.parquet.AbstractTestParquetReader;
import com.facebook.presto.hive.parquet.ParquetPageSource;
import com.facebook.presto.hive.parquet.ParquetTester;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.parquet.FileParquetDataSource;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.reader.ParquetReader;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.concurrent.Immutable;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOConverter;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.MessageType;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkParquetPageSource {
    private static final int ROWS = 10000000;
    private static final List<?> NULL_VALUES = Collections.nCopies(10000000, null);
    private static final boolean batchReadEnabled = true;
    private static final boolean enableVerification = false;

    @Benchmark
    public void readAllBlocksAndApplyFilters(BenchmarkData data) throws Exception {
        try (ParquetPageSource parquetPageSource = data.createParquetPageSource();){
            Page page;
            while ((page = parquetPageSource.getNextPage()) != null) {
                data.process(page);
            }
        }
    }

    @Test
    public void verifyReadAllBlocksAndApplyFilters() throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkParquetPageSource benchmarkSelectiveStreamReaders = new BenchmarkParquetPageSource();
        benchmarkSelectiveStreamReaders.readAllBlocksAndApplyFilters(data);
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkParquetPageSource.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @Immutable
    private static class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K key, V value) {
            this.key = Objects.requireNonNull(key, "key is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int NO_FILTER = -1;
        private final int timestampBound = 1000000000;
        private final Random random = new Random(0L);
        private final Metadata metadata = MetadataManager.createTestMetadataManager();
        private final Session testSession = TestingSession.testSessionBuilder().build();
        private final FunctionAndTypeManager functionManager = this.metadata.getFunctionAndTypeManager();
        private List<String> columnNames = new ArrayList<String>();
        private PageProcessor pageProcessor;
        private File temporaryDirectory;
        private File parquetFile;
        private int channelCount;
        private List<Optional<RowExpression>> filters = new ArrayList<Optional<RowExpression>>();
        private ParquetMetadata parquetMetadata;
        @Param(value={"boolean", "int32", "int64", "int96", "varchar"})
        private String typeSignature = "boolean";
        @Param(value={"PARTIAL", "NONE", "ALL"})
        private Nulls withNulls = Nulls.PARTIAL;
        @Param(value={"-1", "0", "0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1", "0.0|-1", "0.1|-1", "0.2|-1", "0.3|-1", "0.4|-1", "0.5|-1", "0.6|-1", "0.7|-1", "0.8|-1", "0.9|-1", "1|-1", "0|0.5", "0.1|0.5", "0.2|0.5", "0.3|0.5", "0.4|0.5", "0.5|0.5", "0.6|0.5", "0.7|0.5", "0.8|0.5", "0.9|0.5", "1|0.5", "-1|-1", "1|1"})
        private String filterRateSignature = "0.1|-1";
        @Param(value={"UNCOMPRESSED", "SNAPPY", "GZIP", "ZSTD", "LZO", "BROTLI", "LZ4"})
        private CompressionCodecName compressionCodecName = CompressionCodecName.UNCOMPRESSED;

        @Setup
        public void setup() throws Exception {
            this.temporaryDirectory = Files.createTempDir();
            this.parquetFile = new File(this.temporaryDirectory, UUID.randomUUID().toString());
            Type type = this.getTypeFromTypeSignature();
            List filterRates = (List)Arrays.stream(this.filterRateSignature.split("\\|")).map(r -> Float.valueOf(Float.parseFloat(r))).collect(ImmutableList.toImmutableList());
            this.channelCount = filterRates.size();
            List[] values = new List[this.channelCount];
            for (int i = 0; i < this.channelCount; ++i) {
                float filterRate = ((Float)filterRates.get(i)).floatValue();
                Pair<Boolean, Float> filterInfoForNonNull = this.getFilterInfoForNonNull(filterRate);
                values[i] = this.createValues(filterRate);
                this.filters.add(this.getFilter(i, type, filterRate, filterInfoForNonNull.getKey(), filterInfoForNonNull.getValue().floatValue()));
                this.columnNames.add("column" + i);
            }
            ParquetTester.writeParquetFileFromPresto(this.parquetFile, Collections.nCopies(this.channelCount, type), this.columnNames, values, 10000000, this.compressionCodecName);
            List<RowExpression> projections = this.getProjections(type);
            PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler(this.metadata, 0);
            this.pageProcessor = (PageProcessor)new ExpressionCompiler(this.metadata, pageFunctionCompiler).compilePageProcessor(this.testSession.getSqlFunctionProperties(), this.filterConjunction(), projections).get();
            this.parquetMetadata = MetadataReader.readFooter((ParquetDataSource)new FileParquetDataSource(this.parquetFile), (long)this.parquetFile.length(), Optional.empty(), (boolean)false).getParquetMetadata();
        }

        @TearDown
        public void tearDown() throws IOException {
            MoreFiles.deleteRecursively((Path)this.temporaryDirectory.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }

        ParquetPageSource createParquetPageSource() throws IOException {
            FileParquetDataSource dataSource = new FileParquetDataSource(this.parquetFile);
            MessageType schema = this.parquetMetadata.getFileMetaData().getSchema();
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)schema, (MessageType)schema);
            Type type = this.getTypeFromTypeSignature();
            ArrayList<Optional> fields = new ArrayList<Optional>();
            for (int i = 0; i < this.channelCount; ++i) {
                fields.add(ColumnIOConverter.constructField((Type)this.getTypeFromTypeSignature(), (ColumnIO)messageColumnIO.getChild(i)));
            }
            ParquetReader parquetReader = new ParquetReader(messageColumnIO, this.parquetMetadata.getBlocks(), Optional.empty(), (ParquetDataSource)dataSource, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), new DataSize(16.0, DataSize.Unit.MEGABYTE), true, false, null, null, false, Optional.empty());
            return new ParquetPageSource(parquetReader, Collections.nCopies(this.channelCount, type), fields, this.columnNames, new RuntimeStats());
        }

        private Optional<RowExpression> filterConjunction() {
            Optional<RowExpression> conjunction = Optional.empty();
            for (Optional<RowExpression> rowExpression : this.filters) {
                if (!rowExpression.isPresent()) continue;
                if (!conjunction.isPresent()) {
                    conjunction = rowExpression;
                    continue;
                }
                conjunction = Optional.of(Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.AND, (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{conjunction.get(), rowExpression.get()}));
            }
            return conjunction;
        }

        public List<Optional<Page>> process(Page page) {
            return ImmutableList.copyOf((Iterator)this.pageProcessor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page));
        }

        private Type getTypeFromTypeSignature() {
            switch (this.typeSignature) {
                case "boolean": {
                    return BooleanType.BOOLEAN;
                }
                case "int32": {
                    return IntegerType.INTEGER;
                }
                case "int64": {
                    return BigintType.BIGINT;
                }
                case "int96": {
                    return TimestampType.TIMESTAMP;
                }
                case "varchar": {
                    return VarcharType.createVarcharType((int)400);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + this.typeSignature);
        }

        private List<RowExpression> getProjections(Type type) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < this.channelCount; ++i) {
                builder.add((Object)new InputReferenceExpression(Optional.empty(), i, type));
            }
            return builder.build();
        }

        private Optional<RowExpression> getFilter(int columnIndex, Type type, float filterRate, boolean filterAllowNull, float selectionRateForNonNull) {
            if (filterRate == -1.0f) {
                return Optional.empty();
            }
            CallExpression filter = null;
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                filter = Expressions.call((String)OperatorType.EQUAL.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{type, type})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)columnIndex, (Type)type), Expressions.constant((Object)true, (Type)type)});
            }
            if (IntegerType.INTEGER.equals((Object)type)) {
                filter = Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.AND, (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((String)OperatorType.GREATER_THAN_OR_EQUAL.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.GREATER_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{type, type})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)columnIndex, (Type)type), Expressions.constant((Object)((long)(-2.1474836E9f * selectionRateForNonNull)), (Type)type)}), Expressions.call((String)OperatorType.LESS_THAN_OR_EQUAL.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{type, type})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)columnIndex, (Type)type), Expressions.constant((Object)((long)(2.1474836E9f * selectionRateForNonNull)), (Type)type)})});
            }
            if (BigintType.BIGINT.equals((Object)type)) {
                filter = Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.AND, (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((String)OperatorType.GREATER_THAN_OR_EQUAL.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.GREATER_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{type, type})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)columnIndex, (Type)type), Expressions.constant((Object)((long)(-9.223372E18f * selectionRateForNonNull)), (Type)type)}), Expressions.call((String)OperatorType.LESS_THAN_OR_EQUAL.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{type, type})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)columnIndex, (Type)type), Expressions.constant((Object)((long)(9.223372E18f * selectionRateForNonNull)), (Type)type)})});
            }
            if (TimestampType.TIMESTAMP.equals((Object)type)) {
                filter = Expressions.call((String)OperatorType.LESS_THAN_OR_EQUAL.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{type, type})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)columnIndex, (Type)type), Expressions.constant((Object)((long)(1.0E9f * selectionRateForNonNull)), (Type)BigintType.BIGINT)});
            }
            if (type.getTypeSignature().getBase().equals("varchar")) {
                filter = Expressions.call((String)OperatorType.LESS_THAN_OR_EQUAL.name(), (FunctionHandle)this.functionManager.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{type, type})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)columnIndex, (Type)type), Expressions.constant((Object)Slices.utf8Slice((String)String.format("%09d", (int)(1.0E9f * selectionRateForNonNull) - 1)), (Type)type)});
            }
            if (filter == null) {
                throw new IllegalStateException("Cannot generate filter for columnIndex " + columnIndex + " of type: " + type);
            }
            if (filterAllowNull) {
                SpecialFormExpression columnIsNull = Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)columnIndex, (Type)type)});
                filter = Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.OR, (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{columnIsNull, filter});
            }
            return Optional.of(filter);
        }

        private List<?> createValues(float filterRate) {
            Type type = this.getTypeFromTypeSignature();
            switch (this.withNulls) {
                case ALL: {
                    return NULL_VALUES;
                }
                case PARTIAL: {
                    return IntStream.range(0, 10000000).mapToObj(j -> (double)this.random.nextFloat() > 0.5 * (double)(filterRate == -1.0f ? 1.0f : 1.0f - filterRate) ? this.createValue(type, filterRate) : null).collect(Collectors.toList());
                }
            }
            return IntStream.range(0, 10000000).mapToObj(j -> this.createValue(type, filterRate)).collect(Collectors.toList());
        }

        private final Object createValue(Type type, float filterRate) {
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                switch (this.withNulls) {
                    case PARTIAL: {
                        return this.random.nextFloat() <= (1.0f - filterRate) / (1.0f + filterRate);
                    }
                    case NONE: {
                        return this.random.nextFloat() <= 1.0f - filterRate;
                    }
                }
                throw new UnsupportedOperationException("Unsupported withNulls for boolean: " + (Object)((Object)this.withNulls));
            }
            if (IntegerType.INTEGER.equals((Object)type)) {
                return this.random.nextInt();
            }
            if (BigintType.BIGINT.equals((Object)type)) {
                return this.random.nextLong();
            }
            if (TimestampType.TIMESTAMP.equals((Object)type)) {
                return AbstractTestParquetReader.intToSqlTimestamp(this.random.nextInt(1000000000));
            }
            if (type.getTypeSignature().getBase().equals("varchar")) {
                return String.format("%09d", this.random.nextInt(999999999));
            }
            throw new IllegalStateException("Unexpected value: " + type);
        }

        private Pair<Boolean, Float> getFilterInfoForNonNull(float filterRate) {
            switch (this.withNulls) {
                case NONE: {
                    return new Pair<Boolean, Float>(false, Float.valueOf(1.0f - filterRate));
                }
                case PARTIAL: {
                    return new Pair<Boolean, Float>(true, Float.valueOf((1.0f - filterRate) / (1.0f + filterRate)));
                }
                case ALL: {
                    return new Pair<Boolean, Float>(filterRate == 0.0f, Float.valueOf(1.0f));
                }
            }
            throw new UnsupportedOperationException("Unsupported withNulls: " + (Object)((Object)this.withNulls));
        }

        public static enum Nulls {
            PARTIAL,
            NONE,
            ALL;

        }
    }
}

