/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.hive.AbstractTestHiveFileFormats;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.benchmark.FileFormat;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.hive.parquet.write.MapKeyValuesSchemaConverter;
import com.facebook.presto.hive.parquet.write.SingleLevelArrayMapKeyValuesSchemaConverter;
import com.facebook.presto.hive.parquet.write.SingleLevelArraySchemaConverter;
import com.facebook.presto.hive.parquet.write.TestMapredParquetOutputFormat;
import com.facebook.presto.parquet.cache.ParquetMetadataSource;
import com.facebook.presto.parquet.writer.ParquetSchemaConverter;
import com.facebook.presto.parquet.writer.ParquetWriter;
import com.facebook.presto.parquet.writer.ParquetWriterOptions;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.joda.time.DateTimeZone;
import org.testng.Assert;

public class ParquetTester {
    public static final DateTimeZone HIVE_STORAGE_TIME_ZONE = DateTimeZone.forID((String)"America/Bahia_Banderas");
    private static final int MAX_PRECISION_INT64 = Math.toIntExact(ParquetTester.maxPrecision(8));
    private static final boolean OPTIMIZED = true;
    private static final HiveClientConfig HIVE_CLIENT_CONFIG = ParquetTester.createHiveClientConfig(false, false);
    private static final HdfsEnvironment HDFS_ENVIRONMENT = HiveTestUtils.createTestHdfsEnvironment(HIVE_CLIENT_CONFIG, HiveTestUtils.METASTORE_CLIENT_CONFIG);
    private static final TestingConnectorSession SESSION = new TestingConnectorSession(new HiveSessionProperties(HIVE_CLIENT_CONFIG, new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
    private static final TestingConnectorSession SESSION_USE_NAME = new TestingConnectorSession(new HiveSessionProperties(ParquetTester.createHiveClientConfig(true, false), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
    private static final TestingConnectorSession SESSION_USE_NAME_BATCH_READS = new TestingConnectorSession(new HiveSessionProperties(ParquetTester.createHiveClientConfig(true, true), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
    private static final List<String> TEST_COLUMN = Collections.singletonList("test");
    private Set<CompressionCodecName> compressions = ImmutableSet.of();
    private Set<CompressionCodecName> writerCompressions = ImmutableSet.of();
    private Set<ParquetProperties.WriterVersion> versions = ImmutableSet.of();
    private Set<TestingConnectorSession> sessions = ImmutableSet.of();

    public static ParquetTester quickParquetTester() {
        ParquetTester parquetTester = new ParquetTester();
        parquetTester.compressions = ImmutableSet.of((Object)CompressionCodecName.GZIP);
        parquetTester.writerCompressions = ImmutableSet.of((Object)CompressionCodecName.GZIP);
        parquetTester.versions = ImmutableSet.of((Object)ParquetProperties.WriterVersion.PARQUET_1_0);
        parquetTester.sessions = ImmutableSet.of((Object)SESSION);
        return parquetTester;
    }

    public static ParquetTester fullParquetTester() {
        ParquetTester parquetTester = new ParquetTester();
        parquetTester.compressions = ImmutableSet.of((Object)CompressionCodecName.GZIP, (Object)CompressionCodecName.UNCOMPRESSED, (Object)CompressionCodecName.SNAPPY, (Object)CompressionCodecName.LZO);
        parquetTester.writerCompressions = ImmutableSet.of((Object)CompressionCodecName.GZIP, (Object)CompressionCodecName.UNCOMPRESSED, (Object)CompressionCodecName.SNAPPY);
        parquetTester.versions = ImmutableSet.copyOf((Object[])ParquetProperties.WriterVersion.values());
        parquetTester.sessions = ImmutableSet.of((Object)SESSION, (Object)SESSION_USE_NAME, (Object)SESSION_USE_NAME_BATCH_READS);
        return parquetTester;
    }

    public void testRoundTrip(PrimitiveObjectInspector columnObjectInspector, Iterable<?> writeValues, Type parameterType) throws Exception {
        this.testRoundTrip((ObjectInspector)columnObjectInspector, writeValues, writeValues, parameterType);
    }

    public <W, R> void testRoundTrip(PrimitiveObjectInspector columnObjectInspector, Iterable<W> writeValues, Function<W, R> readTransform, Type parameterType) throws Exception {
        this.testRoundTrip((ObjectInspector)columnObjectInspector, writeValues, Iterables.transform(writeValues, readTransform), parameterType);
    }

    public void testSingleLevelArraySchemaRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type) throws Exception {
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)objectInspector.getTypeName());
        MessageType schema = SingleLevelArraySchemaConverter.convert(TEST_COLUMN, typeInfos);
        this.testSingleLevelArrayRoundTrip(objectInspector, writeValues, readValues, type, Optional.of(schema));
        if (objectInspector.getTypeName().contains("map<")) {
            schema = SingleLevelArrayMapKeyValuesSchemaConverter.convert(TEST_COLUMN, typeInfos);
            this.testSingleLevelArrayRoundTrip(objectInspector, writeValues, readValues, type, Optional.of(schema));
        }
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type) throws Exception {
        this.testRoundTripType(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), Optional.empty(), false);
        this.assertRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, TEST_COLUMN, Collections.singletonList(type), Optional.empty());
        if (objectInspector.getTypeName().contains("map<")) {
            ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)objectInspector.getTypeName());
            MessageType schema = MapKeyValuesSchemaConverter.convert(TEST_COLUMN, typeInfos);
            this.testRoundTripType(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), Optional.of(schema), false);
            this.assertRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, TEST_COLUMN, Collections.singletonList(type), Optional.of(schema));
        }
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), parquetSchema, false);
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type, MessageType parquetSchema) throws Exception {
        this.assertNonHiveWriterRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), parquetSchema);
        this.assertNonHiveWriterRoundTrip(Collections.singletonList(objectInspector), ParquetTester.reverse(new Iterable[]{writeValues}), ParquetTester.reverse(new Iterable[]{readValues}), TEST_COLUMN, Collections.singletonList(type), parquetSchema);
        this.assertNonHiveWriterRoundTrip(Collections.singletonList(objectInspector), ParquetTester.insertNullEvery(5, new Iterable[]{writeValues}), ParquetTester.insertNullEvery(5, new Iterable[]{readValues}), TEST_COLUMN, Collections.singletonList(type), parquetSchema);
        this.assertNonHiveWriterRoundTrip(Collections.singletonList(objectInspector), ParquetTester.insertNullEvery(5, ParquetTester.reverse(new Iterable[]{writeValues})), ParquetTester.insertNullEvery(5, ParquetTester.reverse(new Iterable[]{readValues})), TEST_COLUMN, Collections.singletonList(type), parquetSchema);
    }

    public void testSingleLevelArrayRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), parquetSchema, true);
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, String columnName, Type type, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, Collections.singletonList(columnName), Collections.singletonList(type), parquetSchema, false);
    }

    public void testSingleLevelArrayRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, String columnName, Type type, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, Collections.singletonList(columnName), Collections.singletonList(type), parquetSchema, true);
    }

    public void testRoundTrip(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, boolean singleLevelArray) throws Exception {
        this.testRoundTripType(objectInspectors, writeValues, readValues, columnNames, columnTypes, parquetSchema, singleLevelArray);
        this.assertRoundTrip(objectInspectors, this.transformToNulls(writeValues), this.transformToNulls(readValues), columnNames, columnTypes, parquetSchema, singleLevelArray);
    }

    private void testRoundTripType(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, boolean singleLevelArray) throws Exception {
        this.assertRoundTrip(objectInspectors, writeValues, readValues, columnNames, columnTypes, parquetSchema, singleLevelArray);
        this.assertRoundTrip(objectInspectors, ParquetTester.reverse(writeValues), ParquetTester.reverse(readValues), columnNames, columnTypes, parquetSchema, singleLevelArray);
        this.assertRoundTrip(objectInspectors, ParquetTester.insertNullEvery(5, writeValues), ParquetTester.insertNullEvery(5, readValues), columnNames, columnTypes, parquetSchema, singleLevelArray);
        this.assertRoundTrip(objectInspectors, ParquetTester.insertNullEvery(5, ParquetTester.reverse(writeValues)), ParquetTester.insertNullEvery(5, ParquetTester.reverse(readValues)), columnNames, columnTypes, parquetSchema, singleLevelArray);
    }

    void assertRoundTrip(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema) throws Exception {
        this.assertRoundTrip(objectInspectors, writeValues, readValues, columnNames, columnTypes, parquetSchema, false);
    }

    void assertRoundTrip(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, boolean singleLevelArray) throws Exception {
        for (ParquetProperties.WriterVersion version : this.versions) {
            for (CompressionCodecName compressionCodecName : this.compressions) {
                for (ConnectorSession connectorSession : this.sessions) {
                    TempFile tempFile = new TempFile("test", "parquet");
                    Throwable throwable = null;
                    try {
                        JobConf jobConf = new JobConf();
                        jobConf.setEnum("parquet.compression", (Enum)compressionCodecName);
                        jobConf.setBoolean("parquet.enable.dictionary", true);
                        jobConf.setEnum("parquet.writer.version", (Enum)version);
                        ParquetTester.writeParquetColumn(jobConf, tempFile.getFile(), compressionCodecName, ParquetTester.createTableProperties(columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, objectInspectors), this.getIterators(writeValues), parquetSchema, singleLevelArray);
                        ParquetTester.assertFileContents(connectorSession, tempFile.getFile(), this.getIterators(readValues), columnNames, columnTypes);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tempFile == null) continue;
                        if (throwable != null) {
                            try {
                                tempFile.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tempFile.close();
                    }
                }
            }
        }
        for (CompressionCodecName compressionCodecName : this.writerCompressions) {
            for (ConnectorSession connectorSession : this.sessions) {
                TempFile tempFile = new TempFile("test", "parquet");
                Throwable throwable = null;
                try {
                    OptionalInt min = Arrays.stream(writeValues).mapToInt(Iterables::size).min();
                    Preconditions.checkState((boolean)min.isPresent());
                    ParquetTester.writeParquetFileFromPresto(tempFile.getFile(), columnTypes, columnNames, readValues, min.getAsInt(), compressionCodecName);
                    ParquetTester.assertFileContents(connectorSession, tempFile.getFile(), this.getIterators(readValues), columnNames, columnTypes);
                }
                catch (Throwable throwable4) {
                    Throwable throwable5 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (tempFile == null) continue;
                    if (throwable != null) {
                        try {
                            tempFile.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    tempFile.close();
                }
            }
        }
    }

    void assertNonHiveWriterRoundTrip(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, MessageType parquetSchema) throws Exception {
        for (ParquetProperties.WriterVersion version : this.versions) {
            for (CompressionCodecName compression : this.compressions) {
                CompressionCodecName compressionCodecName = CompressionCodecName.valueOf((String)compression.name());
                for (ConnectorSession connectorSession : this.sessions) {
                    TempFile tempFile = new TempFile("test", "parquet");
                    Throwable throwable = null;
                    try {
                        JobConf jobConf = new JobConf();
                        jobConf.setEnum("parquet.compression", (Enum)compressionCodecName);
                        jobConf.setBoolean("parquet.enable.dictionary", true);
                        jobConf.setEnum("parquet.writer.version", (Enum)version);
                        ParquetTester.nonHiveParquetWriter(jobConf, tempFile.getFile(), compressionCodecName, (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, objectInspectors), this.getIterators(writeValues), parquetSchema);
                        ParquetTester.assertFileContents(connectorSession, tempFile.getFile(), this.getIterators(readValues), columnNames, columnTypes);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tempFile == null) continue;
                        if (throwable != null) {
                            try {
                                tempFile.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tempFile.close();
                    }
                }
            }
        }
    }

    void testMaxReadBytes(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type, DataSize maxReadBlockSize) throws Exception {
        this.assertMaxReadBytes(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), Optional.empty(), maxReadBlockSize);
    }

    void assertMaxReadBytes(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, DataSize maxReadBlockSize) throws Exception {
        ParquetProperties.WriterVersion version = ParquetProperties.WriterVersion.PARQUET_1_0;
        CompressionCodecName compressionCodecName = CompressionCodecName.UNCOMPRESSED;
        HiveClientConfig config = new HiveClientConfig().setHiveStorageFormat(HiveStorageFormat.PARQUET).setUseParquetColumnNames(false).setParquetMaxReadBlockSize(maxReadBlockSize);
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(config, new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        try (TempFile tempFile = new TempFile("test", "parquet");){
            JobConf jobConf = new JobConf();
            jobConf.setEnum("parquet.compression", (Enum)compressionCodecName);
            jobConf.setBoolean("parquet.enable.dictionary", true);
            jobConf.setEnum("parquet.writer.version", (Enum)version);
            ParquetTester.writeParquetColumn(jobConf, tempFile.getFile(), compressionCodecName, ParquetTester.createTableProperties(columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, objectInspectors), this.getIterators(writeValues), parquetSchema, false);
            Iterator<?>[] expectedValues = this.getIterators(readValues);
            try (ConnectorPageSource pageSource = ParquetTester.getFileFormat().createFileFormatReader((ConnectorSession)session, HDFS_ENVIRONMENT, tempFile.getFile(), columnNames, columnTypes);){
                ParquetTester.assertPageSource(columnTypes, expectedValues, pageSource, Optional.of(HiveSessionProperties.getParquetMaxReadBlockSize((ConnectorSession)session).toBytes()));
                Assert.assertFalse((boolean)Arrays.stream(expectedValues).allMatch(Iterator::hasNext));
            }
        }
    }

    private static void assertFileContents(ConnectorSession session, File dataFile, Iterator<?>[] expectedValues, List<String> columnNames, List<Type> columnTypes) throws IOException {
        try (ConnectorPageSource pageSource = ParquetTester.getFileFormat().createFileFormatReader(session, HDFS_ENVIRONMENT, dataFile, columnNames, columnTypes);){
            if (pageSource instanceof RecordPageSource) {
                ParquetTester.assertRecordCursor(columnTypes, expectedValues, ((RecordPageSource)pageSource).getCursor());
            } else {
                ParquetTester.assertPageSource(columnTypes, expectedValues, pageSource);
            }
            Assert.assertFalse((boolean)Arrays.stream(expectedValues).allMatch(Iterator::hasNext));
        }
    }

    private static void assertPageSource(List<Type> types, Iterator<?>[] valuesByField, ConnectorPageSource pageSource) {
        ParquetTester.assertPageSource(types, valuesByField, pageSource, Optional.empty());
    }

    private static void assertPageSource(List<Type> types, Iterator<?>[] valuesByField, ConnectorPageSource pageSource, Optional<Long> maxReadBlockSize) {
        Page page;
        while ((page = pageSource.getNextPage()) != null) {
            if (maxReadBlockSize.isPresent()) {
                Assert.assertTrue((page.getPositionCount() == 1 || page.getSizeInBytes() <= maxReadBlockSize.get() ? 1 : 0) != 0);
            }
            for (int field = 0; field < page.getChannelCount(); ++field) {
                Block block = page.getBlock(field);
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    Assert.assertTrue((boolean)valuesByField[field].hasNext());
                    Object expected = valuesByField[field].next();
                    Object actual = ParquetTester.decodeObject(types.get(field), block, i);
                    Assert.assertEquals((Object)actual, expected);
                }
            }
        }
    }

    private static void assertRecordCursor(List<Type> types, Iterator<?>[] valuesByField, RecordCursor cursor) {
        while (cursor.advanceNextPosition()) {
            for (int field = 0; field < types.size(); ++field) {
                Assert.assertTrue((boolean)valuesByField[field].hasNext());
                Object expected = valuesByField[field].next();
                Object actual = ParquetTester.getActualCursorValue(cursor, types.get(field), field);
                Assert.assertEquals((Object)actual, expected);
            }
        }
    }

    private static Object getActualCursorValue(RecordCursor cursor, Type type, int field) {
        Object fieldFromCursor = AbstractTestHiveFileFormats.getFieldFromCursor(cursor, type, field);
        if (fieldFromCursor == null) {
            return null;
        }
        if (HiveUtil.isStructuralType((Type)type)) {
            Block block = (Block)fieldFromCursor;
            if (MetastoreUtil.isArrayType((Type)type)) {
                Type elementType = ((ArrayType)type).getElementType();
                return ParquetTester.toArrayValue(block, elementType);
            }
            if (MetastoreUtil.isMapType((Type)type)) {
                MapType mapType = (MapType)type;
                return ParquetTester.toMapValue(block, mapType.getKeyType(), mapType.getValueType());
            }
            if (MetastoreUtil.isRowType((Type)type)) {
                return ParquetTester.toRowValue(block, type.getTypeParameters());
            }
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new SqlDecimal((BigInteger)fieldFromCursor, decimalType.getPrecision(), decimalType.getScale());
        }
        if (Varchars.isVarcharType((Type)type)) {
            return new String(((Slice)fieldFromCursor).getBytes());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return new SqlVarbinary(((Slice)fieldFromCursor).getBytes());
        }
        if (DateType.DATE.equals((Object)type)) {
            return new SqlDate(((Long)fieldFromCursor).intValue());
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return new SqlTimestamp(((Long)fieldFromCursor).longValue(), TimeZoneKey.UTC_KEY, TimeUnit.MILLISECONDS);
        }
        return fieldFromCursor;
    }

    private static Map toMapValue(Block mapBlock, Type keyType, Type valueType) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(mapBlock.getPositionCount() * 2);
        for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
            map.put(keyType.getObjectValue(SESSION.getSqlFunctionProperties(), mapBlock, i), valueType.getObjectValue(SESSION.getSqlFunctionProperties(), mapBlock, i + 1));
        }
        return Collections.unmodifiableMap(map);
    }

    private static List toArrayValue(Block arrayBlock, Type elementType) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int position = 0; position < arrayBlock.getPositionCount(); ++position) {
            values.add(elementType.getObjectValue(SESSION.getSqlFunctionProperties(), arrayBlock, position));
        }
        return Collections.unmodifiableList(values);
    }

    private static List toRowValue(Block rowBlock, List<Type> fieldTypes) {
        ArrayList<Object> values = new ArrayList<Object>(rowBlock.getPositionCount());
        for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
            values.add(fieldTypes.get(i).getObjectValue(SESSION.getSqlFunctionProperties(), rowBlock, i));
        }
        return Collections.unmodifiableList(values);
    }

    private static HiveClientConfig createHiveClientConfig(boolean useParquetColumnNames, boolean batchReadsEnabled) {
        HiveClientConfig config = new HiveClientConfig();
        config.setHiveStorageFormat(HiveStorageFormat.PARQUET).setUseParquetColumnNames(useParquetColumnNames).setParquetBatchReadOptimizationEnabled(batchReadsEnabled);
        return config;
    }

    private static FileFormat getFileFormat() {
        return FileFormat.PRESTO_PARQUET;
    }

    private static void nonHiveParquetWriter(JobConf jobConf, File outputFile, CompressionCodecName compressionCodecName, SettableStructObjectInspector objectInspector, Iterator<?>[] valuesByField, MessageType parquetSchema) throws Exception {
        GroupWriteSupport.setSchema((MessageType)parquetSchema, (Configuration)jobConf);
        org.apache.parquet.hadoop.ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)new Path(outputFile.toURI())).withType(parquetSchema).withCompressionCodec(compressionCodecName)).withConf((Configuration)jobConf)).withDictionaryEncoding(true)).build();
        ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
        SimpleGroupFactory groupFactory = new SimpleGroupFactory(parquetSchema);
        while (Arrays.stream(valuesByField).allMatch(Iterator::hasNext)) {
            Group group = groupFactory.newGroup();
            block8: for (int field = 0; field < fields.size(); ++field) {
                String typeName;
                Object value = valuesByField[field].next();
                if (value == null) continue;
                String fieldName = ((StructField)fields.get(field)).getFieldName();
                switch (typeName = ((StructField)fields.get(field)).getFieldObjectInspector().getTypeName()) {
                    case "timestamp": 
                    case "bigint": {
                        group.add(fieldName, ((Long)value).longValue());
                        continue block8;
                    }
                    default: {
                        throw new RuntimeException(String.format("unhandled type for column %s type %s", fieldName, typeName));
                    }
                }
            }
            writer.write((Object)group);
        }
        writer.close();
    }

    private static DataSize writeParquetColumn(JobConf jobConf, File outputFile, CompressionCodecName compressionCodecName, Properties tableProperties, SettableStructObjectInspector objectInspector, Iterator<?>[] valuesByField, Optional<MessageType> parquetSchema, boolean singleLevelArray) throws Exception {
        FileSinkOperator.RecordWriter recordWriter = new TestMapredParquetOutputFormat(parquetSchema, singleLevelArray).getHiveRecordWriter(jobConf, new Path(outputFile.toURI()), Text.class, compressionCodecName != CompressionCodecName.UNCOMPRESSED, tableProperties, () -> {});
        Object row = objectInspector.create();
        ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
        while (Arrays.stream(valuesByField).allMatch(Iterator::hasNext)) {
            for (int field = 0; field < fields.size(); ++field) {
                Object value = valuesByField[field].next();
                objectInspector.setStructFieldData(row, (StructField)fields.get(field), value);
            }
            ParquetHiveSerDe serde = new ParquetHiveSerDe();
            serde.initialize((Configuration)jobConf, tableProperties, null);
            Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
            recordWriter.write(record);
        }
        recordWriter.close(false);
        return DataSize.succinctBytes((long)outputFile.length());
    }

    private static Properties createTableProperties(List<String> columnNames, List<ObjectInspector> objectInspectors) {
        Properties orderTableProperties = new Properties();
        orderTableProperties.setProperty("columns", Joiner.on((char)',').join(columnNames));
        orderTableProperties.setProperty("columns.types", Joiner.on((char)',').join(Iterables.transform(objectInspectors, ObjectInspector::getTypeName)));
        return orderTableProperties;
    }

    private Iterator<?>[] getIterators(Iterable<?>[] values) {
        return (Iterator[])Arrays.stream(values).map(Iterable::iterator).toArray(Iterator[]::new);
    }

    private Iterable<?>[] transformToNulls(Iterable<?>[] values) {
        return (Iterable[])Arrays.stream(values).map(v -> Iterables.transform((Iterable)v, (Function)Functions.constant(null))).toArray(Iterable[]::new);
    }

    private static Iterable<?>[] reverse(Iterable<?>[] iterables) {
        return (Iterable[])Arrays.stream(iterables).map(ImmutableList::copyOf).map(Lists::reverse).toArray(Iterable[]::new);
    }

    static Iterable<?>[] insertNullEvery(int n, Iterable<?>[] iterables) {
        return (Iterable[])Arrays.stream(iterables).map(itr -> ParquetTester.insertNullEvery(n, itr)).toArray(Iterable[]::new);
    }

    static <T> Iterable<T> insertNullEvery(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private int position;
            private final Iterator delegate;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                ++this.position;
                if (this.position > n) {
                    this.position = 0;
                    return null;
                }
                if (!this.delegate.hasNext()) {
                    return this.endOfData();
                }
                return this.delegate.next();
            }
        };
    }

    private static Object decodeObject(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return type.getObjectValue(SESSION.getSqlFunctionProperties(), block, position);
    }

    public static void writeParquetFileFromPresto(File outputFile, List<Type> types, List<String> columnNames, Iterable<?>[] values, int size, CompressionCodecName compressionCodecName) throws Exception {
        Preconditions.checkArgument((types.size() == columnNames.size() && types.size() == values.length ? 1 : 0) != 0);
        ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter(types, columnNames);
        ParquetWriter writer = new ParquetWriter((OutputStream)new FileOutputStream(outputFile), schemaConverter.getMessageType(), schemaConverter.getPrimitiveTypes(), columnNames, types, ParquetWriterOptions.builder().setMaxPageSize(DataSize.succinctBytes((long)100L)).setMaxBlockSize(DataSize.succinctBytes((long)100000L)).build(), compressionCodecName.getHadoopCompressionCodecClassName());
        PageBuilder pageBuilder = new PageBuilder(types);
        for (int i = 0; i < types.size(); ++i) {
            Type type = types.get(i);
            Iterator<?> iterator = values[i].iterator();
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
            for (int j = 0; j < size; ++j) {
                Preconditions.checkState((boolean)iterator.hasNext());
                Object value = iterator.next();
                ParquetTester.writeValue(type, blockBuilder, value);
            }
        }
        pageBuilder.declarePositions(size);
        writer.write(pageBuilder.build());
        writer.close();
    }

    public static void testSingleRead(Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, ParquetMetadataSource parquetMetadataSource, File dataFile, long modificationTime) {
        HiveClientConfig config = new HiveClientConfig().setHiveStorageFormat(HiveStorageFormat.PARQUET).setUseParquetColumnNames(false).setParquetMaxReadBlockSize(new DataSize(1000.0, DataSize.Unit.BYTE));
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(config, new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        ParquetPageSourceFactory pageSourceFactory = new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HDFS_ENVIRONMENT, new FileFormatDataSourceStats(), parquetMetadataSource);
        ConnectorPageSource connectorPageSource = FileFormat.createPageSource((HiveBatchPageSourceFactory)pageSourceFactory, (ConnectorSession)session, dataFile, columnNames, columnTypes, HiveStorageFormat.PARQUET, modificationTime);
        Iterator[] expectedValues = (Iterator[])Arrays.stream(readValues).map(Iterable::iterator).toArray(Iterator[]::new);
        if (connectorPageSource instanceof RecordPageSource) {
            ParquetTester.assertRecordCursor(columnTypes, expectedValues, ((RecordPageSource)connectorPageSource).getCursor());
        } else {
            ParquetTester.assertPageSource(columnTypes, expectedValues, connectorPageSource);
        }
        Assert.assertFalse((boolean)Arrays.stream(expectedValues).allMatch(Iterator::hasNext));
    }

    private static void writeValue(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (TinyintType.TINYINT.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || BigintType.BIGINT.equals((Object)type)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (Decimals.isShortDecimal((Type)type)) {
            type.writeLong(blockBuilder, ((SqlDecimal)value).getUnscaledValue().longValue());
        } else if (Decimals.isLongDecimal((Type)type)) {
            if (Decimals.overflows((BigInteger)((SqlDecimal)value).getUnscaledValue(), (int)MAX_PRECISION_INT64)) {
                type.writeSlice(blockBuilder, Decimals.encodeUnscaledValue((BigInteger)((SqlDecimal)value).toBigDecimal().unscaledValue()));
            } else {
                type.writeSlice(blockBuilder, Decimals.encodeUnscaledValue((long)((SqlDecimal)value).getUnscaledValue().longValue()));
            }
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            type.writeDouble(blockBuilder, ((Number)value).doubleValue());
        } else if (RealType.REAL.equals((Object)type)) {
            float floatValue = ((Number)value).floatValue();
            type.writeLong(blockBuilder, (long)Float.floatToIntBits(floatValue));
        } else if (type instanceof VarcharType) {
            Slice slice = Varchars.truncateToLength((Slice)Slices.utf8Slice((String)((String)value)), (Type)type);
            type.writeSlice(blockBuilder, slice);
        } else if (type instanceof CharType) {
            Slice slice = Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)((String)value)), (Type)type);
            type.writeSlice(blockBuilder, slice);
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])((SqlVarbinary)value).getBytes()));
        } else if (DateType.DATE.equals((Object)type)) {
            long days = ((SqlDate)value).getDays();
            type.writeLong(blockBuilder, days);
        } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
            long millis = ((SqlTimestamp)value).getMillisUtc();
            type.writeLong(blockBuilder, millis);
        } else if (type instanceof ArrayType) {
            List array = (List)value;
            Type elementType = (Type)type.getTypeParameters().get(0);
            BlockBuilder arrayBlockBuilder = blockBuilder.beginBlockEntry();
            for (Object elementValue : array) {
                ParquetTester.writeValue(elementType, arrayBlockBuilder, elementValue);
            }
            blockBuilder.closeEntry();
        } else if (type instanceof MapType) {
            Map map = (Map)value;
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            BlockBuilder mapBlockBuilder = blockBuilder.beginBlockEntry();
            for (Map.Entry entry : map.entrySet()) {
                ParquetTester.writeValue(keyType, mapBlockBuilder, entry.getKey());
                ParquetTester.writeValue(valueType, mapBlockBuilder, entry.getValue());
            }
            blockBuilder.closeEntry();
        } else if (type instanceof RowType) {
            List array = (List)value;
            List fieldTypes = type.getTypeParameters();
            BlockBuilder rowBlockBuilder = blockBuilder.beginBlockEntry();
            for (int fieldId = 0; fieldId < fieldTypes.size(); ++fieldId) {
                Type fieldType = (Type)fieldTypes.get(fieldId);
                ParquetTester.writeValue(fieldType, rowBlockBuilder, array.get(fieldId));
            }
            blockBuilder.closeEntry();
        } else {
            throw new IllegalArgumentException("Unsupported type " + type);
        }
    }

    private static long maxPrecision(int numBytes) {
        return Math.round(Math.floor(Math.log10(Math.pow(2.0, 8 * numBytes - 1) - 1.0)));
    }

    static class TempFile
    implements Closeable {
        private final File file;

        public TempFile(String prefix, String suffix) {
            try {
                this.file = File.createTempFile(prefix, suffix);
                this.file.delete();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public void close() {
            this.file.delete();
        }
    }
}

