/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.parquet.ParquetTester;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.FileParquetDataSource;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.reader.ParquetReader;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOConverter;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.MessageType;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestParquetReaderMemoryTracking {
    private static final int ROWS = 1020000;
    private static final boolean ENABLE_OPTIMIZED_READER = true;
    private static final boolean ENABLE_VERIFICATION = true;
    private File temporaryDirectory;
    private File parquetFile;
    private Field field;

    @Test
    public void testParquetReaderMemoryUsage() throws Exception {
        this.prepareDataFile(CompressionCodecName.UNCOMPRESSED);
        try (ParquetReader parquetReader = this.createParquetReader();){
            ArrayList<Block> blocks = new ArrayList<Block>();
            while (parquetReader.nextBatch() > 0) {
                Block block = parquetReader.readBlock(this.field);
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(parquetReader.getSystemMemoryUsage()), (Comparable)Long.valueOf(320000L), (Comparable)Long.valueOf(370000L));
                blocks.add(block);
            }
        }
    }

    private void prepareDataFile(CompressionCodecName compressionCodecName) throws Exception {
        this.temporaryDirectory = Files.createTempDir();
        this.parquetFile = new File(this.temporaryDirectory, UUID.randomUUID().toString());
        IntegerType type = IntegerType.INTEGER;
        ParquetTester.writeParquetFileFromPresto(this.parquetFile, (List<Type>)ImmutableList.of((Object)type), (List<String>)ImmutableList.of((Object)"c1"), new Iterable[]{this.generateValues()}, 1020000, compressionCodecName);
    }

    private List<Integer> generateValues() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 1020000; ++i) {
            builder.add((Object)ThreadLocalRandom.current().nextInt());
        }
        return builder.build();
    }

    private ParquetReader createParquetReader() throws IOException {
        FileParquetDataSource dataSource = new FileParquetDataSource(this.parquetFile);
        ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, (long)this.parquetFile.length(), Optional.empty(), (boolean)false).getParquetMetadata();
        MessageType schema = parquetMetadata.getFileMetaData().getSchema();
        MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)schema, (MessageType)schema);
        this.field = (Field)ColumnIOConverter.constructField((Type)IntegerType.INTEGER, (ColumnIO)messageColumnIO.getChild(0)).get();
        return new ParquetReader(messageColumnIO, parquetMetadata.getBlocks(), Optional.empty(), (ParquetDataSource)dataSource, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), new DataSize(16.0, DataSize.Unit.MEGABYTE), true, true, null, null, false, Optional.empty());
    }

    @AfterClass(alwaysRun=true)
    private void tearDown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.temporaryDirectory.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }
}

