/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.write;

import com.facebook.presto.hive.parquet.write.TestDataWritableWriter;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;

class TestDataWritableWriteSupport
extends WriteSupport<ParquetHiveRecord> {
    private TestDataWritableWriter writer;
    private MessageType schema;
    private boolean singleLevelArray;

    public TestDataWritableWriteSupport(boolean singleLevelArray) {
        this.singleLevelArray = singleLevelArray;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        this.schema = MessageTypeParser.parseMessageType((String)configuration.get("parquet.hive.schema"));
        return new WriteSupport.WriteContext(this.schema, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.writer = new TestDataWritableWriter(recordConsumer, (GroupType)this.schema, this.singleLevelArray);
    }

    public void write(ParquetHiveRecord record) {
        this.writer.write(record);
    }
}

