/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3;

import com.amazonaws.services.s3.AbstractAmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.StorageClass;
import java.util.Date;

public class MockAmazonS3
extends AbstractAmazonS3 {
    private static final String STANDARD_OBJECT_KEY = "test/standard";
    private static final String GLACIER_OBJECT_KEY = "test/glacier";
    private int getObjectHttpCode = 200;
    private int getObjectMetadataHttpCode = 200;
    private GetObjectMetadataRequest getObjectMetadataRequest;
    private CannedAccessControlList acl;
    private boolean hasGlacierObjects;
    private boolean hasHadoopFolderMarkerObjects;

    public void setGetObjectHttpErrorCode(int getObjectHttpErrorCode) {
        this.getObjectHttpCode = getObjectHttpErrorCode;
    }

    public void setGetObjectMetadataHttpCode(int getObjectMetadataHttpCode) {
        this.getObjectMetadataHttpCode = getObjectMetadataHttpCode;
    }

    public CannedAccessControlList getAcl() {
        return this.acl;
    }

    public void setHasGlacierObjects(boolean hasGlacierObjects) {
        this.hasGlacierObjects = hasGlacierObjects;
    }

    public void setHasHadoopFolderMarkerObjects(boolean hasHadoopFolderMarkerObjects) {
        this.hasHadoopFolderMarkerObjects = hasHadoopFolderMarkerObjects;
    }

    public GetObjectMetadataRequest getGetObjectMetadataRequest() {
        return this.getObjectMetadataRequest;
    }

    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) {
        this.getObjectMetadataRequest = getObjectMetadataRequest;
        if (this.getObjectMetadataHttpCode != 200) {
            AmazonS3Exception exception = new AmazonS3Exception("Failing getObjectMetadata call with " + this.getObjectMetadataHttpCode);
            exception.setStatusCode(this.getObjectMetadataHttpCode);
            throw exception;
        }
        return null;
    }

    public S3Object getObject(GetObjectRequest getObjectRequest) {
        if (this.getObjectHttpCode != 200) {
            AmazonS3Exception exception = new AmazonS3Exception("Failing getObject call with " + this.getObjectHttpCode);
            exception.setStatusCode(this.getObjectHttpCode);
            throw exception;
        }
        return null;
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) {
        this.acl = putObjectRequest.getCannedAcl();
        return new PutObjectResult();
    }

    public PutObjectResult putObject(String bucketName, String key, String content) {
        return new PutObjectResult();
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) {
        ObjectListing listing = new ObjectListing();
        S3ObjectSummary standard = new S3ObjectSummary();
        standard.setStorageClass(StorageClass.Standard.toString());
        standard.setKey(STANDARD_OBJECT_KEY);
        standard.setLastModified(new Date());
        listing.getObjectSummaries().add(standard);
        if (this.hasHadoopFolderMarkerObjects) {
            S3ObjectSummary hadoopFolderMarker = new S3ObjectSummary();
            hadoopFolderMarker.setStorageClass(StorageClass.Standard.toString());
            hadoopFolderMarker.setKey("test/test_$folder$");
            hadoopFolderMarker.setLastModified(new Date());
            listing.getObjectSummaries().add(hadoopFolderMarker);
        }
        if (this.hasGlacierObjects) {
            S3ObjectSummary glacier = new S3ObjectSummary();
            glacier.setStorageClass(StorageClass.Glacier.toString());
            glacier.setKey(GLACIER_OBJECT_KEY);
            glacier.setLastModified(new Date());
            listing.getObjectSummaries().add(glacier);
            S3ObjectSummary deepArchive = new S3ObjectSummary();
            deepArchive.setStorageClass(StorageClass.DeepArchive.toString());
            deepArchive.setKey("test/deepArchive");
            deepArchive.setLastModified(new Date());
            listing.getObjectSummaries().add(deepArchive);
        }
        return listing;
    }

    public void shutdown() {
    }
}

