/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3;

import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.PartitionMutator;
import com.facebook.presto.hive.metastore.HivePartitionMutator;
import com.facebook.presto.hive.metastore.thrift.BridgingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.TestingHiveCluster;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastore;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import java.util.Map;
import java.util.Optional;

public final class S3HiveQueryRunner {
    private S3HiveQueryRunner() {
    }

    public static DistributedQueryRunner create(HostAndPort hiveEndpoint, HostAndPort s3Endpoint, String s3AccessKey, String s3SecretKey, Map<String, String> additionalHiveProperties) throws Exception {
        return HiveQueryRunner.createQueryRunner(ImmutableList.of(), (Iterable<String>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), "sql-standard", (Map<String, String>)ImmutableMap.builder().put((Object)"hive.s3.endpoint", (Object)("http://" + s3Endpoint)).put((Object)"hive.s3.aws-access-key", (Object)s3AccessKey).put((Object)"hive.s3.aws-secret-key", (Object)s3SecretKey).putAll(additionalHiveProperties).build(), Optional.of(1), Optional.empty(), Optional.empty(), Optional.of(new BridgingHiveMetastore((HiveMetastore)new ThriftHiveMetastore((HiveCluster)new TestingHiveCluster(new MetastoreClientConfig(), hiveEndpoint.getHost(), hiveEndpoint.getPort()), new MetastoreClientConfig(), HiveTestUtils.HDFS_ENVIRONMENT), (PartitionMutator)new HivePartitionMutator())));
    }
}

