/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3select;

import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.s3select.S3SelectRecordCursor;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.RecordReader;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestS3SelectRecordCursor {
    private static final String LAZY_SERDE_CLASS_NAME = LazySimpleSerDe.class.getName();
    static final HiveColumnHandle ARTICLE_COLUMN = new HiveColumnHandle("article", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 1, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    static final HiveColumnHandle AUTHOR_COLUMN = new HiveColumnHandle("author", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), 1, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    static final HiveColumnHandle DATE_ARTICLE_COLUMN = new HiveColumnHandle("date_pub", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"date"), 1, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    static final HiveColumnHandle QUANTITY_COLUMN = new HiveColumnHandle("quantity", HiveType.HIVE_INT, TypeSignature.parseTypeSignature((String)"integer"), 1, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    private static final HiveColumnHandle[] DEFAULT_TEST_COLUMNS = new HiveColumnHandle[]{ARTICLE_COLUMN, AUTHOR_COLUMN, DATE_ARTICLE_COLUMN, QUANTITY_COLUMN};
    private static final HiveColumnHandle MOCK_HIVE_COLUMN_HANDLE = new HiveColumnHandle("mockName", HiveType.HIVE_FLOAT, TypeSignature.parseTypeSignature((String)"double"), 88, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty(), Optional.empty());
    private static final TypeManager MOCK_TYPE_MANAGER = new TestingTypeManager();
    private static final Path MOCK_PATH = new Path("mockPath");
    private static final RecordReader<?, ?> MOCK_RECORD_READER = new RecordReader(){

        public boolean next(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object createKey() {
            throw new UnsupportedOperationException();
        }

        public Object createValue() {
            throw new UnsupportedOperationException();
        }

        public long getPos() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public float getProgress() {
            throw new UnsupportedOperationException();
        }
    };

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="splitSchema is null")
    public void shouldFailOnNullSplitSchema() {
        new S3SelectRecordCursor(new Configuration(), MOCK_PATH, MOCK_RECORD_READER, 100L, null, Collections.singletonList(MOCK_HIVE_COLUMN_HANDLE), DateTimeZone.UTC, MOCK_TYPE_MANAGER);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="columns is null")
    public void shouldFailOnNullColumns() {
        new S3SelectRecordCursor(new Configuration(), MOCK_PATH, MOCK_RECORD_READER, 100L, new Properties(), null, DateTimeZone.UTC, MOCK_TYPE_MANAGER);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Invalid Thrift DDL struct article \\{ \\}")
    public void shouldThrowIllegalArgumentExceptionWhenSerialDDLHasNoColumns() {
        String ddlSerializationValue = "struct article { }";
        this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Thrift DDL should start with struct")
    public void shouldThrowIllegalArgumentExceptionWhenSerialDDLNotStartingWithStruct() {
        String ddlSerializationValue = "foo article { varchar article varchar }";
        this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Invalid Thrift DDL struct article \\{varchar article\\}")
    public void shouldThrowIllegalArgumentExceptionWhenSerialDDLNotStartingWithStruct2() {
        String ddlSerializationValue = "struct article {varchar article}";
        this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Invalid Thrift DDL struct article varchar article varchar \\}")
    public void shouldThrowIllegalArgumentExceptionWhenMissingOpenStartStruct() {
        String ddlSerializationValue = "struct article varchar article varchar }";
        this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Invalid Thrift DDL struct article\\{varchar article varchar author date date_pub int quantity")
    public void shouldThrowIllegalArgumentExceptionWhenDDlFormatNotCorrect() {
        String ddlSerializationValue = "struct article{varchar article varchar author date date_pub int quantity";
        this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Invalid Thrift DDL struct article \\{ varchar article varchar author date date_pub int quantity ")
    public void shouldThrowIllegalArgumentExceptionWhenEndOfStructNotFound() {
        String ddlSerializationValue = "struct article { varchar article varchar author date date_pub int quantity ";
        this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS);
    }

    @Test
    public void shouldFilterColumnsWhichDoesNotMatchInTheHiveTable() {
        String ddlSerializationValue = "struct article { varchar address varchar company date date_pub int quantity}";
        String expectedDDLSerialization = "struct article { date date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test
    public void shouldReturnOnlyQuantityColumnInTheDDl() {
        String ddlSerializationValue = "struct article { varchar address varchar company date date_pub int quantity}";
        String expectedDDLSerialization = "struct article { int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, ARTICLE_COLUMN, QUANTITY_COLUMN), (Map)this.buildExpectedProperties(expectedDDLSerialization, ARTICLE_COLUMN, QUANTITY_COLUMN));
    }

    @Test
    public void shouldReturnProperties() {
        String ddlSerializationValue = "struct article { varchar article varchar author date date_pub int quantity}";
        String expectedDDLSerialization = "struct article { varchar article, varchar author, date date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test
    public void shouldReturnPropertiesWithoutDoubleCommaInColumnsNameLastColumnNameWithEndStruct() {
        String ddlSerializationValue = "struct article { varchar article, varchar author, date date_pub, int quantity}";
        String expectedDDLSerialization = "struct article { varchar article, varchar author, date date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test
    public void shouldReturnPropertiesWithoutDoubleCommaInColumnsNameLastColumnNameWithoutEndStruct() {
        String ddlSerializationValue = "struct article { varchar article, varchar author, date date_pub, int quantity }";
        String expectedDDLSerialization = "struct article { varchar article, varchar author, date date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test
    public void shouldOnlyGetColumnTypeFromHiveObjectAndNotFromDDLSerialLastColumnNameWithEndStruct() {
        String ddlSerializationValue = "struct article { int article, double author, xxxx date_pub, int quantity}";
        String expectedDDLSerialization = "struct article { int article, double author, xxxx date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test
    public void shouldOnlyGetColumnTypeFromHiveObjectAndNotFromDDLSerialLastColumnNameWithoutEndStruct() {
        String ddlSerializationValue = "struct article { int article, double author, xxxx date_pub, int quantity }";
        String expectedDDLSerialization = "struct article { int article, double author, xxxx date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void shouldThrowNullPointerExceptionWhenColumnsIsNull() {
        S3SelectRecordCursor.updateSplitSchema((Properties)new Properties(), null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void shouldThrowNullPointerExceptionWhenSchemaIsNull() {
        S3SelectRecordCursor.updateSplitSchema(null, (List)ImmutableList.of());
    }

    private Properties buildSplitSchema(String ddlSerializationValue, HiveColumnHandle ... columns) {
        Properties properties = new Properties();
        properties.put("serialization.lib", LAZY_SERDE_CLASS_NAME);
        properties.put("serialization.ddl", ddlSerializationValue);
        return S3SelectRecordCursor.updateSplitSchema((Properties)properties, Arrays.asList(columns));
    }

    private Properties buildExpectedProperties(String expectedDDLSerialization, HiveColumnHandle ... expectedColumns) {
        String expectedColumnsType = this.getTypes(expectedColumns);
        String expectedColumnsName = this.getName(expectedColumns);
        Properties propExpected = new Properties();
        propExpected.put("columns", expectedColumnsName);
        propExpected.put("serialization.lib", LAZY_SERDE_CLASS_NAME);
        propExpected.put("serialization.ddl", expectedDDLSerialization);
        propExpected.put("columns.types", expectedColumnsType);
        return propExpected;
    }

    private String getName(HiveColumnHandle[] expectedColumns) {
        return Stream.of(expectedColumns).map(HiveColumnHandle::getName).collect(Collectors.joining(","));
    }

    private String getTypes(HiveColumnHandle[] expectedColumns) {
        return Stream.of(expectedColumns).map(HiveColumnHandle::getHiveType).map(HiveType::getTypeInfo).map(TypeInfo::getTypeName).collect(Collectors.joining(","));
    }
}

