/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security.ranger;

import com.facebook.airlift.configuration.ConfigurationFactory;
import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.hive.security.ranger.RangerBasedAccessControlConfig;
import com.google.common.collect.ImmutableMap;
import com.google.inject.ConfigurationException;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestRangerBasedAccessControlConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((RangerBasedAccessControlConfig)ConfigAssertions.recordDefaults(RangerBasedAccessControlConfig.class)).setRefreshPeriod(new Duration(60.0, TimeUnit.SECONDS)).setRangerHttpEndPoint(null).setRangerHiveServiceName(null).setBasicAuthUser(null).setBasicAuthPassword(null).setRangerHiveAuditPath(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.ranger.refresh-policy-period", (Object)"200s").put((Object)"hive.ranger.rest-endpoint", (Object)"http://test:6080").put((Object)"hive.ranger.policy.hive-servicename", (Object)"hiveServiceName").put((Object)"hive.ranger.service.basic-auth-username", (Object)"admin").put((Object)"hive.ranger.service.basic-auth-password", (Object)"admin").put((Object)"hive.ranger.audit.path", (Object)"audit_path").build();
        RangerBasedAccessControlConfig expected = new RangerBasedAccessControlConfig().setRefreshPeriod(new Duration(200.0, TimeUnit.SECONDS)).setRangerHttpEndPoint("http://test:6080").setRangerHiveServiceName("hiveServiceName").setBasicAuthUser("admin").setBasicAuthPassword("admin").setRangerHiveAuditPath("audit_path");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testValidation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestRangerBasedAccessControlConfig.newInstance((Map<String, String>)ImmutableMap.of((Object)"hive.ranger.refresh-policy-period", (Object)"1us", (Object)"hive.ranger.policy.hive-servicename", (Object)"hive", (Object)"hive.ranger.rest-endpoint", (Object)"http://test:6080", (Object)"hive.ranger.service.basic-auth-username", (Object)"admin", (Object)"hive.ranger.service.basic-auth-password", (Object)"admin"))).isInstanceOf(ConfigurationException.class)).hasMessageContaining("Invalid configuration property hive.ranger.refresh-policy-period");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestRangerBasedAccessControlConfig.newInstance((Map<String, String>)ImmutableMap.of((Object)"hive.ranger.refresh-policy-period", (Object)"120s", (Object)"hive.ranger.policy.hive-servicename", (Object)"hive", (Object)"hive.ranger.service.basic-auth-username", (Object)"admin", (Object)"hive.ranger.service.basic-auth-password", (Object)"admin"))).isInstanceOf(ConfigurationException.class)).hasMessageContaining("Invalid configuration property hive.ranger.rest-endpoint: may not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestRangerBasedAccessControlConfig.newInstance((Map<String, String>)ImmutableMap.of((Object)"hive.ranger.refresh-policy-period", (Object)"120s", (Object)"hive.ranger.rest-endpoint", (Object)"http://test:6080", (Object)"hive.ranger.service.basic-auth-username", (Object)"admin", (Object)"hive.ranger.service.basic-auth-password", (Object)"admin"))).isInstanceOf(ConfigurationException.class)).hasMessageContaining("Invalid configuration property hive.ranger.policy.hive-servicename: may not be null");
    }

    private static RangerBasedAccessControlConfig newInstance(Map<String, String> properties) {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(properties);
        return (RangerBasedAccessControlConfig)configurationFactory.build(RangerBasedAccessControlConfig.class);
    }
}

