/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.util.CustomSplitConversionUtils;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeBootstrapBaseFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCustomSplitConversionUtils {
    private static final String BASE_PATH = "/test/table/";
    private static final Path FILE_PATH = new Path("/test/table/", "test.parquet");
    private static final long SPLIT_START_POS = 0L;
    private static final long SPLIT_LENGTH = 100L;
    private static final String[] SPLIT_HOSTS = new String[]{"host1", "host2"};

    @Test
    public void testHudiRealtimeSplitConverterRoundTrip() throws IOException {
        List<String> deltaLogPaths = Arrays.asList("test1", "test2", "test3");
        List deltaLogFiles = deltaLogPaths.stream().map(p -> new HoodieLogFile(new Path(p))).collect(Collectors.toList());
        String expectedMaxCommitTime = "max_commit_time";
        FileSplit baseSplit = new FileSplit(FILE_PATH, 0L, 100L, SPLIT_HOSTS);
        HoodieRealtimeFileSplit hudiSplit = new HoodieRealtimeFileSplit(baseSplit, BASE_PATH, deltaLogFiles, expectedMaxCommitTime, false, Option.empty());
        Map customSplitInfo = CustomSplitConversionUtils.extractCustomSplitInfo((FileSplit)hudiSplit);
        HoodieRealtimeFileSplit recreatedSplit = (HoodieRealtimeFileSplit)CustomSplitConversionUtils.recreateSplitWithCustomInfo((FileSplit)baseSplit, (Map)customSplitInfo);
        Assert.assertEquals((Object)FILE_PATH, (Object)recreatedSplit.getPath());
        Assert.assertEquals((long)0L, (long)recreatedSplit.getStart());
        Assert.assertEquals((long)100L, (long)recreatedSplit.getLength());
        Assert.assertEquals((Object[])SPLIT_HOSTS, (Object[])recreatedSplit.getLocations());
        Assert.assertEquals((String)BASE_PATH, (String)recreatedSplit.getBasePath());
        Assert.assertEquals(deltaLogPaths, (Collection)recreatedSplit.getDeltaLogPaths());
        Assert.assertEquals((String)expectedMaxCommitTime, (String)recreatedSplit.getMaxCommitTime());
    }

    @Test
    public void testHudiRealtimeSplitConverterNoLogRoundTrip() throws IOException {
        ImmutableList deltaLogPaths = ImmutableList.of();
        ImmutableList deltaLogFiles = ImmutableList.of();
        String expectedMaxCommitTime = "max_commit_time";
        FileSplit baseSplit = new FileSplit(FILE_PATH, 0L, 100L, SPLIT_HOSTS);
        HoodieRealtimeFileSplit hudiSplit = new HoodieRealtimeFileSplit(baseSplit, BASE_PATH, (List)deltaLogFiles, expectedMaxCommitTime, false, Option.empty());
        Map customSplitInfo = CustomSplitConversionUtils.extractCustomSplitInfo((FileSplit)hudiSplit);
        HoodieRealtimeFileSplit recreatedSplit = (HoodieRealtimeFileSplit)CustomSplitConversionUtils.recreateSplitWithCustomInfo((FileSplit)baseSplit, (Map)customSplitInfo);
        Assert.assertEquals((Object)FILE_PATH, (Object)recreatedSplit.getPath());
        Assert.assertEquals((long)0L, (long)recreatedSplit.getStart());
        Assert.assertEquals((long)100L, (long)recreatedSplit.getLength());
        Assert.assertEquals((Object[])SPLIT_HOSTS, (Object[])recreatedSplit.getLocations());
        Assert.assertEquals((String)BASE_PATH, (String)recreatedSplit.getBasePath());
        Assert.assertEquals((Collection)deltaLogPaths, (Collection)recreatedSplit.getDeltaLogPaths());
        Assert.assertEquals((String)expectedMaxCommitTime, (String)recreatedSplit.getMaxCommitTime());
    }

    @Test
    public void testHudiBootstrapBaseFileSplitConverter() throws IOException {
        Path bootstrapSourceFilePath = new Path("/test/source/test.parquet");
        long bootstrapSourceSplitStartPos = 0L;
        long bootstrapSourceSplitLength = 200L;
        FileSplit baseSplit = new FileSplit(FILE_PATH, 0L, 100L, SPLIT_HOSTS);
        FileSplit bootstrapSourceSplit = new FileSplit(bootstrapSourceFilePath, bootstrapSourceSplitStartPos, bootstrapSourceSplitLength, new String[0]);
        BootstrapBaseFileSplit hudiSplit = new BootstrapBaseFileSplit(baseSplit, bootstrapSourceSplit);
        Map customSplitInfo = CustomSplitConversionUtils.extractCustomSplitInfo((FileSplit)hudiSplit);
        BootstrapBaseFileSplit recreatedSplit = (BootstrapBaseFileSplit)CustomSplitConversionUtils.recreateSplitWithCustomInfo((FileSplit)baseSplit, (Map)customSplitInfo);
        Assert.assertEquals((Object)FILE_PATH, (Object)recreatedSplit.getPath());
        Assert.assertEquals((long)0L, (long)recreatedSplit.getStart());
        Assert.assertEquals((long)100L, (long)recreatedSplit.getLength());
        Assert.assertEquals((Object[])SPLIT_HOSTS, (Object[])recreatedSplit.getLocations());
        Assert.assertEquals((Object)bootstrapSourceFilePath, (Object)recreatedSplit.getBootstrapFileSplit().getPath());
        Assert.assertEquals((long)bootstrapSourceSplitStartPos, (long)recreatedSplit.getBootstrapFileSplit().getStart());
        Assert.assertEquals((long)bootstrapSourceSplitLength, (long)recreatedSplit.getBootstrapFileSplit().getLength());
    }

    @Test
    public void testHudiRealtimeBootstrapBaseFileSplitConverter() throws IOException {
        List<String> deltaLogPaths = Arrays.asList("test1", "test2", "test3");
        List deltaLogFiles = deltaLogPaths.stream().map(p -> new HoodieLogFile(new Path(p))).collect(Collectors.toList());
        String maxCommitTime = "max_commit_time";
        Path bootstrapSourceFilePath = new Path("/test/source/test.parquet");
        long bootstrapSourceSplitStartPos = 0L;
        long bootstrapSourceSplitLength = 200L;
        FileSplit baseSplit = new FileSplit(FILE_PATH, 0L, 100L, SPLIT_HOSTS);
        FileSplit bootstrapSourceSplit = new FileSplit(bootstrapSourceFilePath, bootstrapSourceSplitStartPos, bootstrapSourceSplitLength, new String[0]);
        HoodieRealtimeBootstrapBaseFileSplit hudiSplit = new HoodieRealtimeBootstrapBaseFileSplit(baseSplit, BASE_PATH, deltaLogFiles, maxCommitTime, bootstrapSourceSplit, false, Option.empty());
        Map customSplitInfo = CustomSplitConversionUtils.extractCustomSplitInfo((FileSplit)hudiSplit);
        HoodieRealtimeBootstrapBaseFileSplit recreatedSplit = (HoodieRealtimeBootstrapBaseFileSplit)CustomSplitConversionUtils.recreateSplitWithCustomInfo((FileSplit)baseSplit, (Map)customSplitInfo);
        Assert.assertEquals((Object)FILE_PATH, (Object)recreatedSplit.getPath());
        Assert.assertEquals((long)0L, (long)recreatedSplit.getStart());
        Assert.assertEquals((long)100L, (long)recreatedSplit.getLength());
        Assert.assertEquals((Object[])SPLIT_HOSTS, (Object[])recreatedSplit.getLocations());
        Assert.assertEquals((String)BASE_PATH, (String)recreatedSplit.getBasePath());
        Assert.assertEquals(deltaLogPaths, (Collection)recreatedSplit.getDeltaLogPaths());
        Assert.assertEquals((String)maxCommitTime, (String)recreatedSplit.getMaxCommitTime());
        Assert.assertEquals((Object)bootstrapSourceFilePath, (Object)recreatedSplit.getBootstrapFileSplit().getPath());
        Assert.assertEquals((long)bootstrapSourceSplitStartPos, (long)recreatedSplit.getBootstrapFileSplit().getStart());
        Assert.assertEquals((long)bootstrapSourceSplitLength, (long)recreatedSplit.getBootstrapFileSplit().getLength());
    }
}

