/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.util.SizeBasedSplitWeightProvider;
import com.facebook.presto.spi.SplitWeight;
import io.airlift.units.DataSize;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSizeBasedSplitWeightProvider {
    private static final long STANDARD_SPLIT_WEIGHT = SplitWeight.standard().getRawValue();

    @Test
    public void testSimpleProportions() {
        SizeBasedSplitWeightProvider provider = new SizeBasedSplitWeightProvider(0.01, DataSize.succinctBytes((long)TestSizeBasedSplitWeightProvider.megabytesToBytes(64)));
        Assert.assertEquals((Object)provider.weightForSplitSizeInBytes(TestSizeBasedSplitWeightProvider.megabytesToBytes(64)), (Object)SplitWeight.fromRawValue((long)STANDARD_SPLIT_WEIGHT));
        Assert.assertEquals((Object)provider.weightForSplitSizeInBytes(TestSizeBasedSplitWeightProvider.megabytesToBytes(32)), (Object)SplitWeight.fromRawValue((long)(STANDARD_SPLIT_WEIGHT / 2L)));
        Assert.assertEquals((Object)provider.weightForSplitSizeInBytes(TestSizeBasedSplitWeightProvider.megabytesToBytes(16)), (Object)SplitWeight.fromRawValue((long)(STANDARD_SPLIT_WEIGHT / 4L)));
    }

    @Test
    public void testMinimumAndMaximumSplitWeightHandling() {
        DataSize targetSplitSize = DataSize.succinctBytes((long)TestSizeBasedSplitWeightProvider.megabytesToBytes(64));
        SizeBasedSplitWeightProvider provider = new SizeBasedSplitWeightProvider(0.05, targetSplitSize);
        Assert.assertEquals((Object)provider.weightForSplitSizeInBytes(1L), (Object)SplitWeight.fromRawValue((long)5L));
        DataSize largerThanTarget = DataSize.succinctBytes((long)TestSizeBasedSplitWeightProvider.megabytesToBytes(128));
        Assert.assertEquals((Object)provider.weightForSplitSizeInBytes(largerThanTarget.toBytes()), (Object)SplitWeight.fromRawValue((long)STANDARD_SPLIT_WEIGHT));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="^minimumWeight must be > 0 and <= 1, found: 1\\.01$")
    public void testInvalidMinimumWeight() {
        new SizeBasedSplitWeightProvider(1.01, DataSize.succinctBytes((long)TestSizeBasedSplitWeightProvider.megabytesToBytes(64)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="^targetSplitSize must be > 0, found:.*$")
    public void testInvalidTargetSplitSize() {
        new SizeBasedSplitWeightProvider(0.01, DataSize.succinctBytes((long)0L));
    }

    private static long megabytesToBytes(int megabytes) {
        return (long)megabytes * 1024L * 1024L;
    }
}

