/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveInsertTableHandle;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.procedure.Procedure;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.hadoop.hive.common.FileUtils;

public class CreateEmptyPartitionProcedure
implements Provider<Procedure> {
    private static final MethodHandle CREATE_EMPTY_PARTITION = MethodHandleUtil.methodHandle(CreateEmptyPartitionProcedure.class, (String)"createEmptyPartition", (Class[])new Class[]{ConnectorSession.class, String.class, String.class, List.class, List.class});
    private final Supplier<TransactionalMetadata> hiveMetadataFactory;
    private final ExtendedHiveMetastore metastore;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateJsonCodec;
    private final SmileCodec<PartitionUpdate> partitionUpdateSmileCodec;

    @Inject
    public CreateEmptyPartitionProcedure(Supplier<TransactionalMetadata> hiveMetadataFactory, ExtendedHiveMetastore metastore, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, SmileCodec<PartitionUpdate> partitionUpdateSmileCodec) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateJsonCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.partitionUpdateSmileCodec = Objects.requireNonNull(partitionUpdateSmileCodec, "partitionUpdateSmileCodec is null");
    }

    public Procedure get() {
        return new Procedure("system", "create_empty_partition", (List)ImmutableList.of((Object)new Procedure.Argument("schema_name", "varchar"), (Object)new Procedure.Argument("table_name", "varchar"), (Object)new Procedure.Argument("partition_columns", "array(varchar)"), (Object)new Procedure.Argument("partition_values", "array(varchar)")), CREATE_EMPTY_PARTITION.bindTo(this));
    }

    public void createEmptyPartition(ConnectorSession session, String schema, String table, List<Object> partitionColumnNames, List<Object> partitionValues) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doCreateEmptyPartition(session, schema, table, partitionColumnNames, partitionValues);
        }
    }

    private void doCreateEmptyPartition(ConnectorSession session, String schema, String table, List<Object> partitionColumnNames, List<Object> partitionValues) {
        TransactionalMetadata hiveMetadata = this.hiveMetadataFactory.get();
        HiveInsertTableHandle hiveInsertTableHandle = (HiveInsertTableHandle)hiveMetadata.beginInsert(session, (ConnectorTableHandle)new HiveTableHandle(schema, table));
        List actualPartitionColumnNames = (List)hiveInsertTableHandle.getInputColumns().stream().filter(HiveColumnHandle::isPartitionKey).map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        if (!Objects.equals(partitionColumnNames, actualPartitionColumnNames)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "input partition column names doesn't match actual partition column names");
        }
        List partitionStringValues = (List)partitionValues.stream().map(String.class::cast).collect(ImmutableList.toImmutableList());
        if (this.metastore.getPartition(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER), schema, table, partitionStringValues).isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Partition already exists");
        }
        String partitionName = FileUtils.makePartName((List)actualPartitionColumnNames, (List)partitionStringValues);
        LocationService.WriteInfo writeInfo = this.locationService.getPartitionWriteInfo(hiveInsertTableHandle.getLocationHandle(), Optional.empty(), partitionName);
        PartitionUpdate partitionUpdate = new PartitionUpdate(partitionName, PartitionUpdate.UpdateMode.NEW, writeInfo.getWritePath(), writeInfo.getTargetPath(), (List<PartitionUpdate.FileWriteInfo>)ImmutableList.of(), 0L, 0L, 0L, writeInfo.getWritePath().getName().matches("\\d+"));
        byte[] serializedPartitionUpdate = HiveSessionProperties.isOptimizedPartitionUpdateSerializationEnabled(session) ? HiveUtil.serializeZstdCompressed(this.partitionUpdateSmileCodec, partitionUpdate) : this.partitionUpdateJsonCodec.toJsonBytes((Object)partitionUpdate);
        hiveMetadata.finishInsert(session, hiveInsertTableHandle, (Collection)ImmutableList.of((Object)Slices.wrappedBuffer((byte[])serializedPartitionUpdate)), (Collection)ImmutableList.of());
        hiveMetadata.commit();
    }
}

