/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.CopyOnFirstWriteConfiguration;
import com.facebook.presto.hive.GenericHiveRecordCursor;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.cache.HiveCachingHdfsConfiguration;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.joda.time.DateTimeZone;

public class GenericHiveRecordCursorProvider
implements HiveRecordCursorProvider {
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public GenericHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    @Override
    public Optional<RecordCursor> createRecordCursor(Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, boolean s3SelectPushdownEnabled) {
        Path path = new Path(fileSplit.getPath());
        try {
            if (!fileSplit.getCustomSplitInfo().isEmpty()) {
                if (configuration instanceof HiveCachingHdfsConfiguration.CachingJobConf) {
                    configuration = ((HiveCachingHdfsConfiguration.CachingJobConf)configuration).getConfig();
                }
                if (configuration instanceof CopyOnFirstWriteConfiguration) {
                    configuration = ((CopyOnFirstWriteConfiguration)configuration).getConfig();
                }
            }
            this.hdfsEnvironment.getFileSystem(session.getUser(), path, configuration);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + path, (Throwable)e);
        }
        Configuration actualConfiguration = configuration;
        RecordReader recordReader = (RecordReader)this.hdfsEnvironment.doAs(session.getUser(), () -> HiveUtil.createRecordReader(actualConfiguration, path, fileSplit.getStart(), fileSplit.getLength(), schema, columns, fileSplit.getCustomSplitInfo()));
        return (Optional)this.hdfsEnvironment.doAs(session.getUser(), () -> Optional.of(new GenericHiveRecordCursor(actualConfiguration, path, GenericHiveRecordCursorProvider.genericRecordReader(recordReader), fileSplit.getLength(), schema, columns, hiveStorageTimeZone, typeManager)));
    }

    private static RecordReader<?, ? extends Writable> genericRecordReader(RecordReader<?, ?> recordReader) {
        return recordReader;
    }
}

