/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.github.luben.zstd.Zstd;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.LongStream;
import org.roaringbitmap.RoaringBitmap;

public class HiveManifestUtils {
    private static final int FILE_SIZE_CHANNEL = 0;
    private static final int ROW_COUNT_CHANNEL = 1;
    private static final int COMPRESSION_LEVEL = 7;
    private static final String COMMA = ",";
    public static final String FILE_NAMES = "FILE_NAMES";
    public static final String FILE_SIZES = "FILE_SIZES";
    public static final String MANIFEST_VERSION = "MANIFEST_VERSION";
    public static final String VERSION_1 = "V1";

    private HiveManifestUtils() {
    }

    public static Page createFileStatisticsPage(long fileSize, long rowCount) {
        PageBuilder statsPageBuilder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        statsPageBuilder.declarePosition();
        BigintType.BIGINT.writeLong(statsPageBuilder.getBlockBuilder(0), fileSize);
        BigintType.BIGINT.writeLong(statsPageBuilder.getBlockBuilder(1), rowCount);
        return statsPageBuilder.build();
    }

    public static long getFileSize(Page statisticsPage, int position) {
        if (position < 0 || position >= statisticsPage.getPositionCount()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.MALFORMED_HIVE_FILE_STATISTICS, String.format("Invalid position: %d specified for FileStatistics page", position));
        }
        return BigintType.BIGINT.getLong(statisticsPage.getBlock(0), position);
    }

    public static Optional<Page> createPartitionManifest(PartitionUpdate partitionUpdate) {
        PageBuilder manifestBuilder = new PageBuilder((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT));
        BlockBuilder fileNameBuilder = manifestBuilder.getBlockBuilder(0);
        BlockBuilder fileSizeBuilder = manifestBuilder.getBlockBuilder(1);
        for (PartitionUpdate.FileWriteInfo fileWriteInfo : partitionUpdate.getFileWriteInfos()) {
            if (!fileWriteInfo.getFileSize().isPresent()) {
                return Optional.empty();
            }
            manifestBuilder.declarePosition();
            VarcharType.VARCHAR.writeSlice(fileNameBuilder, Slices.utf8Slice((String)fileWriteInfo.getWriteFileName()));
            BigintType.BIGINT.writeLong(fileSizeBuilder, fileWriteInfo.getFileSize().get().longValue());
        }
        return Optional.of(manifestBuilder.build());
    }

    public static Map<String, String> updatePartitionMetadataWithFileNamesAndSizes(PartitionUpdate partitionUpdate, Map<String, String> metadata) {
        ImmutableMap.Builder partitionMetadata = ImmutableMap.builder();
        ArrayList<PartitionUpdate.FileWriteInfo> fileWriteInfos = new ArrayList<PartitionUpdate.FileWriteInfo>(partitionUpdate.getFileWriteInfos());
        if (!partitionUpdate.containsNumberedFileNames()) {
            return metadata;
        }
        fileWriteInfos.sort(Comparator.comparing(info -> Integer.valueOf(info.getWriteFileName())));
        List fileNames = (List)fileWriteInfos.stream().map(PartitionUpdate.FileWriteInfo::getWriteFileName).collect(ImmutableList.toImmutableList());
        List fileSizes = (List)fileWriteInfos.stream().map(PartitionUpdate.FileWriteInfo::getFileSize).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        if (fileSizes.size() < fileNames.size()) {
            if (fileSizes.isEmpty()) {
                return metadata;
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.MALFORMED_HIVE_FILE_STATISTICS, String.format("During manifest creation for partition= %s, filename count= %s is not equal to filesizes count= %s", partitionUpdate.getName(), fileNames.size(), fileSizes.size()));
        }
        partitionMetadata.put((Object)FILE_NAMES, (Object)HiveManifestUtils.compressFileNames(fileNames));
        partitionMetadata.put((Object)FILE_SIZES, (Object)HiveManifestUtils.compressFileSizes(fileSizes));
        partitionMetadata.put((Object)MANIFEST_VERSION, (Object)VERSION_1);
        partitionMetadata.putAll(metadata);
        return partitionMetadata.build();
    }

    public static OptionalLong getManifestSizeInBytes(ConnectorSession session, PartitionUpdate partitionUpdate, Map<String, String> parameters) {
        if (HiveSessionProperties.isFileRenamingEnabled(session) && partitionUpdate.containsNumberedFileNames()) {
            if (parameters.containsKey(MANIFEST_VERSION)) {
                return OptionalLong.of(parameters.get(FILE_NAMES).length() + parameters.get(FILE_SIZES).length());
            }
            List<PartitionUpdate.FileWriteInfo> fileWriteInfos = partitionUpdate.getFileWriteInfos();
            return OptionalLong.of(HiveManifestUtils.compressFileNames((List)fileWriteInfos.stream().map(PartitionUpdate.FileWriteInfo::getWriteFileName).collect(ImmutableList.toImmutableList())).length() + HiveManifestUtils.compressFileSizes((List)fileWriteInfos.stream().map(PartitionUpdate.FileWriteInfo::getFileSize).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList())).length());
        }
        return OptionalLong.empty();
    }

    static String compressFileNames(List<String> fileNames) {
        if (fileNames.size() == 1) {
            return fileNames.get(0);
        }
        boolean isContinuousSequence = true;
        int start = 0;
        for (String name : fileNames) {
            if (start != Integer.parseInt(name)) {
                isContinuousSequence = false;
                break;
            }
            ++start;
        }
        if (isContinuousSequence) {
            return fileNames.get(fileNames.size() - 1);
        }
        return HiveManifestUtils.compressFileNamesUsingRoaringBitmap(fileNames);
    }

    static List<String> decompressFileNames(String compressedFileNames) {
        if (compressedFileNames.matches("\\d+")) {
            long end = Long.parseLong(compressedFileNames);
            if (end == 0L) {
                return ImmutableList.of((Object)"0");
            }
            return (List)LongStream.range(0L, end + 1L).mapToObj(String::valueOf).collect(ImmutableList.toImmutableList());
        }
        try {
            RoaringBitmap roaringBitmap = new RoaringBitmap();
            ByteBuffer byteBuffer = ByteBuffer.wrap(compressedFileNames.getBytes(StandardCharsets.ISO_8859_1));
            roaringBitmap.deserialize(byteBuffer);
            return (List)Arrays.stream(roaringBitmap.toArray()).mapToObj(Integer::toString).collect(ImmutableList.toImmutableList());
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.MALFORMED_HIVE_FILE_STATISTICS, "Failed de-compressing the file names in manifest");
        }
    }

    private static String compressFileNamesUsingRoaringBitmap(List<String> fileNames) {
        RoaringBitmap roaringBitmap = new RoaringBitmap();
        fileNames.forEach(name -> roaringBitmap.add(Integer.parseInt(name)));
        ByteBuffer byteBuffer = ByteBuffer.allocate(roaringBitmap.serializedSizeInBytes());
        roaringBitmap.serialize(byteBuffer);
        ((Buffer)byteBuffer).flip();
        return new String(byteBuffer.array(), StandardCharsets.ISO_8859_1);
    }

    public static String compressFileSizes(List<Long> fileSizes) {
        String fileSizesString = Joiner.on((String)COMMA).join((Iterable)fileSizes.stream().map(String::valueOf).collect(ImmutableList.toImmutableList()));
        try {
            return new String(Zstd.compress((byte[])fileSizesString.getBytes(StandardCharsets.ISO_8859_1), (int)7), StandardCharsets.ISO_8859_1);
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.MALFORMED_HIVE_FILE_STATISTICS, "Failed compressing the file sizes for manifest");
        }
    }

    public static List<Long> decompressFileSizes(String compressedFileSizes) {
        try {
            byte[] compressedBytes = compressedFileSizes.getBytes(StandardCharsets.ISO_8859_1);
            long decompressedSize = Zstd.decompressedSize((byte[])compressedBytes);
            String decompressedFileSizes = new String(Zstd.decompress((byte[])compressedBytes, (int)((int)decompressedSize)), StandardCharsets.ISO_8859_1);
            return (List)Arrays.stream(decompressedFileSizes.split(COMMA)).map(Long::valueOf).collect(ImmutableList.toImmutableList());
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.MALFORMED_HIVE_FILE_STATISTICS, "Failed de-compressing the file sizes in manifest");
        }
    }
}

