/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.s3select.S3SelectDataType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.joda.time.Chronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class IonSqlQueryBuilder {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.date().withChronology((Chronology)ISOChronology.getInstanceUTC());
    private static final String DATA_SOURCE = "S3Object s";
    private final TypeManager typeManager;
    private final S3SelectDataType s3SelectDataType;

    public IonSqlQueryBuilder(TypeManager typeManager, S3SelectDataType s3SelectDataType) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.s3SelectDataType = Objects.requireNonNull(s3SelectDataType, "s3SelectDataType is null");
    }

    public String buildSql(List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> tupleDomain) {
        StringBuilder sql = new StringBuilder("SELECT ");
        if (columns.isEmpty()) {
            sql.append("' '");
        } else {
            String columnNames = columns.stream().map(this::getFullyQualifiedColumnName).collect(Collectors.joining(", "));
            sql.append(columnNames);
        }
        sql.append(" FROM ");
        sql.append(DATA_SOURCE);
        List<String> clauses = this.toConjuncts(columns, tupleDomain);
        if (!clauses.isEmpty()) {
            sql.append(" WHERE ").append(Joiner.on((String)" AND ").join(clauses));
        }
        return sql.toString();
    }

    private String getFullyQualifiedColumnName(HiveColumnHandle column) {
        switch (this.s3SelectDataType) {
            case CSV: {
                return String.format("s._%d", column.getHiveColumnIndex() + 1);
            }
            case JSON: {
                return String.format("s.%s", column.getName());
            }
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Attempted to build SQL for unknown S3SelectDataType");
    }

    private List<String> toConjuncts(List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> tupleDomain) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (HiveColumnHandle column : columns) {
            Domain domain;
            Type type = column.getHiveType().getType(this.typeManager);
            if (!tupleDomain.getDomains().isPresent() || !IonSqlQueryBuilder.isSupported(type) || (domain = (Domain)((Map)tupleDomain.getDomains().get()).get(column)) == null) continue;
            builder.add((Object)this.toPredicate(domain, type, column));
        }
        return builder.build();
    }

    private static boolean isSupported(Type type) {
        Type validType = Objects.requireNonNull(type, "type is null");
        return validType.equals(BigintType.BIGINT) || validType.equals(TinyintType.TINYINT) || validType.equals(SmallintType.SMALLINT) || validType.equals(IntegerType.INTEGER) || validType instanceof DecimalType || validType.equals(BooleanType.BOOLEAN) || validType.equals(DateType.DATE) || validType instanceof VarcharType;
    }

    private String toPredicate(Domain domain, Type type, HiveColumnHandle column) {
        Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
        if (domain.getValues().isNone()) {
            if (domain.isNullAllowed()) {
                return this.getFullyQualifiedColumnName(column) + " = '' ";
            }
            return "FALSE";
        }
        if (domain.getValues().isAll()) {
            if (domain.isNullAllowed()) {
                return "TRUE";
            }
            return this.getFullyQualifiedColumnName(column) + " <> '' ";
        }
        ArrayList<String> disjuncts = new ArrayList<String>();
        ArrayList<Object> singleValues = new ArrayList<Object>();
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(range.getSingleValue());
                continue;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!range.isLowUnbounded()) {
                arrayList.add(this.toPredicate(range.isLowInclusive() ? ">=" : ">", range.getLowBoundedValue(), type, column));
            }
            if (!range.isHighUnbounded()) {
                arrayList.add(this.toPredicate(range.isHighInclusive() ? "<=" : "<", range.getHighBoundedValue(), type, column));
            }
            Preconditions.checkState((!arrayList.isEmpty() ? 1 : 0) != 0);
            disjuncts.add("(" + Joiner.on((String)" AND ").join(arrayList) + ")");
        }
        if (singleValues.size() == 1) {
            disjuncts.add(this.toPredicate("=", Iterables.getOnlyElement(singleValues), type, column));
        } else if (singleValues.size() > 1) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object e : singleValues) {
                IonSqlQueryBuilder.checkType(type);
                values.add(IonSqlQueryBuilder.valueToQuery(type, e));
            }
            disjuncts.add(this.createColumn(type, column) + " IN (" + Joiner.on((String)",").join(values) + ")");
        }
        Preconditions.checkState((!disjuncts.isEmpty() ? 1 : 0) != 0);
        if (domain.isNullAllowed()) {
            disjuncts.add(this.getFullyQualifiedColumnName(column) + " = '' ");
        }
        return "(" + Joiner.on((String)" OR ").join(disjuncts) + ")";
    }

    private String toPredicate(String operator, Object value, Type type, HiveColumnHandle column) {
        IonSqlQueryBuilder.checkType(type);
        return String.format("%s %s %s", this.createColumn(type, column), operator, IonSqlQueryBuilder.valueToQuery(type, value));
    }

    private static void checkType(Type type) {
        Preconditions.checkArgument((boolean)IonSqlQueryBuilder.isSupported(type), (String)"Type not supported: %s", (Object)type);
    }

    private static String valueToQuery(Type type, Object value) {
        if (type.equals(BigintType.BIGINT)) {
            return String.valueOf(((Number)value).longValue());
        }
        if (type.equals(IntegerType.INTEGER)) {
            return String.valueOf(((Number)value).intValue());
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return String.valueOf(((Number)value).shortValue());
        }
        if (type.equals(TinyintType.TINYINT)) {
            return String.valueOf(((Number)value).byteValue());
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return String.valueOf(value);
        }
        if (type.equals(DateType.DATE)) {
            return "`" + FORMATTER.print(TimeUnit.DAYS.toMillis((Long)value)) + "`";
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return "'" + ((Slice)value).toStringUtf8() + "'";
        }
        if (type instanceof DecimalType) {
            if (Decimals.isLongDecimal((Type)type)) {
                return Decimals.toString((Slice)((Slice)value), (int)((DecimalType)type).getScale());
            }
            return Decimals.toString((long)((Long)value), (int)((DecimalType)type).getScale());
        }
        return "'" + ((Slice)value).toStringUtf8() + "'";
    }

    private String createColumn(Type type, HiveColumnHandle columnHandle) {
        String column = this.getFullyQualifiedColumnName(columnHandle);
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            return this.formatPredicate(column, "INT");
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return this.formatPredicate(column, "BOOL");
        }
        if (type.equals(DateType.DATE)) {
            return this.formatPredicate(column, "TIMESTAMP");
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return this.formatPredicate(column, String.format("DECIMAL(%s,%s)", decimalType.getPrecision(), decimalType.getScale()));
        }
        return column;
    }

    private String formatPredicate(String column, String type) {
        return String.format("case %s when '' then null else CAST(%s AS %s) end", column, column, type);
    }
}

