/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveMetadataUpdateHandleThriftSerde;
import com.facebook.presto.spi.ConnectorMetadataUpdateHandle;
import com.facebook.presto.spi.ConnectorTypeSerde;
import com.facebook.presto.spi.connector.ConnectorTypeSerdeProvider;
import java.util.Objects;
import javax.inject.Inject;

public class HiveConnectorTypeSerdeProvider
implements ConnectorTypeSerdeProvider {
    private final ThriftCodecManager thriftCodecManager;
    private final Protocol thriftProtocol;
    private final int bufferSize;

    @Inject
    public HiveConnectorTypeSerdeProvider(HiveClientConfig hiveClientConfig, ThriftCodecManager thriftCodecManager) {
        this.thriftCodecManager = Objects.requireNonNull(thriftCodecManager, "thriftCodecManager is null");
        Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null");
        this.thriftProtocol = hiveClientConfig.getThriftProtocol();
        this.bufferSize = Math.toIntExact(hiveClientConfig.getThriftBufferSize().toBytes());
    }

    public ConnectorTypeSerde<ConnectorMetadataUpdateHandle> getConnectorMetadataUpdateHandleSerde() {
        return new HiveMetadataUpdateHandleThriftSerde(this.thriftCodecManager, this.thriftProtocol, this.bufferSize);
    }
}

