/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorPlanRewriter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;

public class HivePartialAggregationPushdown
implements ConnectorPlanOptimizer {
    private final FunctionMetadataManager functionMetadataManager;
    private final StandardFunctionResolution standardFunctionResolution;
    private final Supplier<TransactionalMetadata> metadataFactory;
    private static final int DUMMY_AGGREGATED_COLUMN_INDEX = -20;

    @Inject
    public HivePartialAggregationPushdown(FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution, Supplier<TransactionalMetadata> metadataFactory) {
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "function manager is null");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standard function resolution is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadata factory is null");
    }

    private static Optional<HiveTableHandle> getHiveTableHandle(TableScanNode tableScanNode) {
        ConnectorTableHandle connectorHandle;
        TableHandle table = tableScanNode.getTable();
        if (table != null && (connectorHandle = table.getConnectorHandle()) instanceof HiveTableHandle) {
            return Optional.of((HiveTableHandle)connectorHandle);
        }
        return Optional.empty();
    }

    private static PlanNode replaceChildren(PlanNode node, List<PlanNode> children) {
        return children.containsAll(node.getSources()) ? node : node.replaceChildren(children);
    }

    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        if (!HiveSessionProperties.isPartialAggregationPushdownEnabled(session)) {
            return maxSubplan;
        }
        return ConnectorPlanRewriter.rewriteWith((ConnectorPlanRewriter)new Rewriter(variableAllocator, session, idAllocator), (PlanNode)maxSubplan);
    }

    private class Rewriter
    extends ConnectorPlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final ConnectorSession session;
        private final VariableAllocator variableAllocator;

        public Rewriter(VariableAllocator variableAllocator, ConnectorSession session, PlanNodeIdAllocator idAllocator) {
            this.session = session;
            this.idAllocator = idAllocator;
            this.variableAllocator = variableAllocator;
        }

        private boolean isAggregationPushdownSupported(AggregationNode partialAggregationNode) {
            HiveTableLayoutHandle hiveTableLayoutHandle;
            if (partialAggregationNode.hasNonEmptyGroupingSet()) {
                return false;
            }
            TableScanNode tableScanNode = (TableScanNode)partialAggregationNode.getSource();
            ConnectorTableMetadata connectorTableMetadata = ((TransactionalMetadata)HivePartialAggregationPushdown.this.metadataFactory.get()).getTableMetadata(this.session, tableScanNode.getTable().getConnectorHandle());
            Optional rawFormat = Optional.ofNullable(connectorTableMetadata.getProperties().get("format"));
            if (!rawFormat.isPresent()) {
                return false;
            }
            HiveStorageFormat hiveStorageFormat = HiveStorageFormat.valueOf((String)rawFormat.get().toString());
            if (hiveStorageFormat != HiveStorageFormat.ORC && hiveStorageFormat != HiveStorageFormat.PARQUET && hiveStorageFormat != HiveStorageFormat.DWRF) {
                return false;
            }
            if (tableScanNode.getTable().getLayout().isPresent() && !(hiveTableLayoutHandle = (HiveTableLayoutHandle)tableScanNode.getTable().getLayout().get()).getPredicateColumns().isEmpty()) {
                return false;
            }
            block4: for (AggregationNode.Aggregation aggregation : partialAggregationNode.getAggregations().values()) {
                FunctionHandle functionHandle = aggregation.getFunctionHandle();
                if (!(HivePartialAggregationPushdown.this.standardFunctionResolution.isCountFunction(functionHandle) || HivePartialAggregationPushdown.this.standardFunctionResolution.isMaxFunction(functionHandle) || HivePartialAggregationPushdown.this.standardFunctionResolution.isMinFunction(functionHandle))) {
                    return false;
                }
                if (aggregation.getArguments().isEmpty() && !HivePartialAggregationPushdown.this.standardFunctionResolution.isCountFunction(functionHandle)) {
                    return false;
                }
                List arguments = aggregation.getArguments();
                if (arguments.size() > 1) {
                    return false;
                }
                if (!HivePartialAggregationPushdown.this.standardFunctionResolution.isMinFunction(functionHandle) && !HivePartialAggregationPushdown.this.standardFunctionResolution.isMaxFunction(functionHandle)) continue;
                Type type = ((RowExpression)arguments.get(0)).getType();
                switch (hiveStorageFormat) {
                    case ORC: 
                    case DWRF: {
                        if (!this.isNotSupportedOrcTypeForMinMax(type)) continue block4;
                        return false;
                    }
                    case PARQUET: {
                        if (!this.isNotSupportedParquetTypeForMinMax(type)) continue block4;
                        return false;
                    }
                }
                return false;
            }
            return true;
        }

        private boolean isNotSupportedOrcTypeForMinMax(Type type) {
            return BooleanType.BOOLEAN.equals((Object)type) || type.getJavaType() == Boolean.TYPE || MetastoreUtil.isRowType((Type)type) || MetastoreUtil.isArrayType((Type)type) || MetastoreUtil.isMapType((Type)type) || TinyintType.TINYINT.equals((Object)type) || VarbinaryType.VARBINARY.equals((Object)type) || TimestampType.TIMESTAMP.equals((Object)type) || this.isNotSupportedOrcTypeForVariableLengthDataType(type);
        }

        private boolean isNotSupportedParquetTypeForMinMax(Type type) {
            return BooleanType.BOOLEAN.equals((Object)type) || type.getJavaType() == Boolean.TYPE || MetastoreUtil.isRowType((Type)type) || MetastoreUtil.isArrayType((Type)type) || MetastoreUtil.isMapType((Type)type) || this.isNotSupportedParquetTypeForVariableLengthDataType(type);
        }

        private boolean isNotSupportedOrcTypeForVariableLengthDataType(Type type) {
            return VarcharType.VARCHAR.equals((Object)type) && !HiveSessionProperties.isPartialAggregationPushdownForVariableLengthDatatypesEnabled(this.session);
        }

        private boolean isNotSupportedParquetTypeForVariableLengthDataType(Type type) {
            boolean isVariableLengthType = VarbinaryType.VARBINARY.equals((Object)type) || VarcharType.VARCHAR.equals((Object)type);
            return isVariableLengthType && !HiveSessionProperties.isPartialAggregationPushdownForVariableLengthDatatypesEnabled(this.session);
        }

        private Optional<PlanNode> tryPartialAggregationPushdown(PlanNode plan) {
            if (!(plan instanceof AggregationNode && ((AggregationNode)plan).getStep().equals((Object)AggregationNode.Step.PARTIAL) && ((AggregationNode)plan).getSource() instanceof TableScanNode)) {
                return Optional.empty();
            }
            AggregationNode partialAggregationNode = (AggregationNode)plan;
            TableScanNode oldTableScanNode = (TableScanNode)partialAggregationNode.getSource();
            TableHandle oldTableHandle = oldTableScanNode.getTable();
            HiveTableHandle hiveTableHandle = (HiveTableHandle)HivePartialAggregationPushdown.getHiveTableHandle(oldTableScanNode).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Hive table handle not found"));
            if (!this.isAggregationPushdownSupported(partialAggregationNode)) {
                return Optional.empty();
            }
            HiveTypeTranslator hiveTypeTranslator = new HiveTypeTranslator();
            HashMap assignments = new HashMap();
            for (Map.Entry aggregationEntry : partialAggregationNode.getAggregations().entrySet()) {
                int columnIndex;
                String columnName;
                CallExpression callExpression = ((AggregationNode.Aggregation)aggregationEntry.getValue()).getCall();
                HiveType hiveType = HiveType.toHiveType((TypeTranslator)hiveTypeTranslator, (Type)callExpression.getType());
                if (callExpression.getArguments().isEmpty()) {
                    columnName = "count_star";
                    columnIndex = -20;
                } else {
                    RowExpression column = (RowExpression)callExpression.getArguments().get(0);
                    columnName = column.toString();
                    HiveColumnHandle oldColumnHandle = (HiveColumnHandle)oldTableScanNode.getAssignments().get(column);
                    columnIndex = oldColumnHandle.getHiveColumnIndex();
                    hiveType = oldColumnHandle.getHiveType();
                }
                HiveColumnHandle newColumnHandle = new HiveColumnHandle(columnName, hiveType, callExpression.getType().getTypeSignature(), columnIndex, HiveColumnHandle.ColumnType.AGGREGATED, Optional.of("partial aggregation pushed down"), Optional.of(aggregationEntry.getValue()));
                assignments.put(aggregationEntry.getKey(), newColumnHandle);
            }
            HiveTableLayoutHandle oldTableLayoutHandle = (HiveTableLayoutHandle)oldTableHandle.getLayout().get();
            HiveTableLayoutHandle newTableLayoutHandle = oldTableLayoutHandle.builder().setPartialAggregationsPushedDown(true).build();
            TableHandle newTableHandle = new TableHandle(oldTableHandle.getConnectorId(), (ConnectorTableHandle)hiveTableHandle, oldTableHandle.getTransaction(), Optional.of(newTableLayoutHandle));
            return Optional.of(new TableScanNode(oldTableScanNode.getSourceLocation(), this.idAllocator.getNextId(), newTableHandle, (List)ImmutableList.copyOf((Collection)partialAggregationNode.getOutputVariables()), (Map)ImmutableMap.copyOf(assignments), oldTableScanNode.getTableConstraints(), oldTableScanNode.getCurrentConstraint(), oldTableScanNode.getEnforcedConstraint()));
        }

        public PlanNode visitAggregation(AggregationNode node, ConnectorPlanRewriter.RewriteContext<Void> context) {
            return this.tryPartialAggregationPushdown((PlanNode)node).orElse((PlanNode)node);
        }
    }
}

