/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.expressions.CanonicalRowExpressionRewriter;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.relation.RowExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class HiveTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final SchemaTableName schemaTableName;
    private final String tablePath;
    private final List<HiveColumnHandle> partitionColumns;
    private final List<Column> dataColumns;
    private final Map<String, String> tableParameters;
    private final TupleDomain<Subfield> domainPredicate;
    private final RowExpression remainingPredicate;
    private final Map<String, HiveColumnHandle> predicateColumns;
    private final TupleDomain<ColumnHandle> partitionColumnPredicate;
    private final Optional<HiveBucketHandle> bucketHandle;
    private final Optional<HiveBucketing.HiveBucketFilter> bucketFilter;
    private final boolean pushdownFilterEnabled;
    private final String layoutString;
    private final Optional<Set<HiveColumnHandle>> requestedColumns;
    private final boolean partialAggregationsPushedDown;
    private final boolean appendRowNumberEnabled;
    private final boolean footerStatsUnreliable;
    private final Optional<List<HivePartition>> partitions;
    private final Optional<HiveTableHandle> hiveTableHandle;

    @JsonCreator
    public HiveTableLayoutHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="tablePath") String tablePath, @JsonProperty(value="partitionColumns") List<HiveColumnHandle> partitionColumns, @JsonProperty(value="dataColumns") List<Column> dataColumns, @JsonProperty(value="tableParameters") Map<String, String> tableParameters, @JsonProperty(value="domainPredicate") TupleDomain<Subfield> domainPredicate, @JsonProperty(value="remainingPredicate") RowExpression remainingPredicate, @JsonProperty(value="predicateColumns") Map<String, HiveColumnHandle> predicateColumns, @JsonProperty(value="partitionColumnPredicate") TupleDomain<ColumnHandle> partitionColumnPredicate, @JsonProperty(value="bucketHandle") Optional<HiveBucketHandle> bucketHandle, @JsonProperty(value="bucketFilter") Optional<HiveBucketing.HiveBucketFilter> bucketFilter, @JsonProperty(value="pushdownFilterEnabled") boolean pushdownFilterEnabled, @JsonProperty(value="layoutString") String layoutString, @JsonProperty(value="requestedColumns") Optional<Set<HiveColumnHandle>> requestedColumns, @JsonProperty(value="partialAggregationsPushedDown") boolean partialAggregationsPushedDown, @JsonProperty(value="appendRowNumber") boolean appendRowNumberEnabled, @JsonProperty(value="footerStatsUnreliable") boolean footerStatsUnreliable) {
        this(schemaTableName, tablePath, partitionColumns, dataColumns, tableParameters, domainPredicate, remainingPredicate, predicateColumns, partitionColumnPredicate, bucketHandle, bucketFilter, pushdownFilterEnabled, layoutString, requestedColumns, partialAggregationsPushedDown, appendRowNumberEnabled, Optional.empty(), footerStatsUnreliable, Optional.empty());
    }

    protected HiveTableLayoutHandle(SchemaTableName schemaTableName, String tablePath, List<HiveColumnHandle> partitionColumns, List<Column> dataColumns, Map<String, String> tableParameters, TupleDomain<Subfield> domainPredicate, RowExpression remainingPredicate, Map<String, HiveColumnHandle> predicateColumns, TupleDomain<ColumnHandle> partitionColumnPredicate, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter, boolean pushdownFilterEnabled, String layoutString, Optional<Set<HiveColumnHandle>> requestedColumns, boolean partialAggregationsPushedDown, boolean appendRowNumberEnabled, Optional<List<HivePartition>> partitions, boolean footerStatsUnreliable, Optional<HiveTableHandle> hiveTableHandle) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "table is null");
        this.tablePath = Objects.requireNonNull(tablePath, "tablePath is null");
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.dataColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(dataColumns, "dataColumns is null"));
        this.tableParameters = ImmutableMap.copyOf(Objects.requireNonNull(tableParameters, "tableProperties is null"));
        this.domainPredicate = Objects.requireNonNull(domainPredicate, "domainPredicate is null");
        this.remainingPredicate = Objects.requireNonNull(remainingPredicate, "remainingPredicate is null");
        this.predicateColumns = Objects.requireNonNull(predicateColumns, "predicateColumns is null");
        this.partitionColumnPredicate = Objects.requireNonNull(partitionColumnPredicate, "partitionColumnPredicate is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        this.pushdownFilterEnabled = pushdownFilterEnabled;
        this.layoutString = Objects.requireNonNull(layoutString, "layoutString is null");
        this.requestedColumns = Objects.requireNonNull(requestedColumns, "requestedColumns is null");
        this.partialAggregationsPushedDown = partialAggregationsPushedDown;
        this.appendRowNumberEnabled = appendRowNumberEnabled;
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
        this.footerStatsUnreliable = footerStatsUnreliable;
        this.hiveTableHandle = Objects.requireNonNull(hiveTableHandle, "hiveTableHandle is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public String getTablePath() {
        return this.tablePath;
    }

    @JsonProperty
    public List<HiveColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonProperty
    public List<Column> getDataColumns() {
        return this.dataColumns;
    }

    @JsonProperty
    public Map<String, String> getTableParameters() {
        return this.tableParameters;
    }

    @JsonIgnore
    public Optional<List<HivePartition>> getPartitions() {
        return this.partitions;
    }

    @JsonIgnore
    public Optional<HiveTableHandle> getHiveTableHandle() {
        return this.hiveTableHandle;
    }

    @JsonProperty
    public TupleDomain<Subfield> getDomainPredicate() {
        return this.domainPredicate;
    }

    @JsonProperty
    public RowExpression getRemainingPredicate() {
        return this.remainingPredicate;
    }

    @JsonProperty
    public Map<String, HiveColumnHandle> getPredicateColumns() {
        return this.predicateColumns;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getPartitionColumnPredicate() {
        return this.partitionColumnPredicate;
    }

    @JsonProperty
    public Optional<HiveBucketHandle> getBucketHandle() {
        return this.bucketHandle;
    }

    @JsonProperty
    public Optional<HiveBucketing.HiveBucketFilter> getBucketFilter() {
        return this.bucketFilter;
    }

    @JsonProperty
    public boolean isPushdownFilterEnabled() {
        return this.pushdownFilterEnabled;
    }

    @JsonProperty
    public String getLayoutString() {
        return this.layoutString;
    }

    @JsonProperty
    public Optional<Set<HiveColumnHandle>> getRequestedColumns() {
        return this.requestedColumns;
    }

    public String toString() {
        return this.layoutString;
    }

    @JsonProperty
    public boolean isPartialAggregationsPushedDown() {
        return this.partialAggregationsPushedDown;
    }

    @JsonProperty
    public boolean isAppendRowNumberEnabled() {
        return this.appendRowNumberEnabled;
    }

    @JsonProperty
    public boolean isFooterStatsUnreliable() {
        return this.footerStatsUnreliable;
    }

    public Object getIdentifier(Optional<ConnectorSplit> split, PlanCanonicalizationStrategy canonicalizationStrategy) {
        TupleDomain domainPredicate = this.domainPredicate;
        if (split.isPresent() && split.get() instanceof HiveSplit && domainPredicate.getColumnDomains().isPresent()) {
            HiveSplit hiveSplit = (HiveSplit)split.get();
            Set subfields = (Set)hiveSplit.getRedundantColumnDomains().stream().map(column -> new Subfield(((HiveColumnHandle)column).getName())).collect(ImmutableSet.toImmutableSet());
            List columnDomains = (List)((List)domainPredicate.getColumnDomains().get()).stream().filter(columnDomain -> !subfields.contains(columnDomain.getColumn())).collect(ImmutableList.toImmutableList());
            domainPredicate = TupleDomain.fromColumnDomains(Optional.of(columnDomains));
        }
        return ImmutableMap.builder().put((Object)"schemaTableName", (Object)this.schemaTableName).put((Object)"domainPredicate", HiveTableLayoutHandle.canonicalizeDomainPredicate(domainPredicate, this.getPredicateColumns(), canonicalizationStrategy)).put((Object)"remainingPredicate", (Object)CanonicalRowExpressionRewriter.canonicalizeRowExpression((RowExpression)this.remainingPredicate, (boolean)false)).put((Object)"constraint", this.getConstraint(canonicalizationStrategy)).put((Object)"bucketFilter", this.bucketFilter).build();
    }

    private TupleDomain<ColumnHandle> getConstraint(PlanCanonicalizationStrategy canonicalizationStrategy) {
        if (canonicalizationStrategy == PlanCanonicalizationStrategy.DEFAULT) {
            return TupleDomain.all();
        }
        TupleDomain constraint = HiveMetadata.createPredicate((List<ColumnHandle>)ImmutableList.copyOf(this.partitionColumns), this.partitions.get());
        constraint = this.getDomainPredicate().transform(subfield -> subfield.getPath().isEmpty() ? subfield.getRootName() : null).transform(this.getPredicateColumns()::get).transform(ColumnHandle.class::cast).intersect(constraint);
        constraint = constraint.canonicalize(HiveTableLayoutHandle::isPartitionKey);
        return constraint;
    }

    @VisibleForTesting
    public static TupleDomain<Subfield> canonicalizeDomainPredicate(TupleDomain<Subfield> domainPredicate, Map<String, HiveColumnHandle> predicateColumns, PlanCanonicalizationStrategy strategy) {
        if (strategy == PlanCanonicalizationStrategy.DEFAULT) {
            return domainPredicate.canonicalize(ignored -> false);
        }
        return domainPredicate.transform(subfield -> {
            if (!subfield.getPath().isEmpty() || !predicateColumns.containsKey(subfield.getRootName())) {
                return subfield;
            }
            return HiveTableLayoutHandle.isPartitionKey((ColumnHandle)predicateColumns.get(subfield.getRootName())) ? null : subfield;
        }).canonicalize(ignored -> false);
    }

    private static boolean isPartitionKey(ColumnHandle columnHandle) {
        return columnHandle instanceof HiveColumnHandle && ((HiveColumnHandle)columnHandle).isPartitionKey();
    }

    public Table getTable(SemiTransactionalHiveMetastore metastore, MetastoreContext metastoreContext) {
        Optional table = this.hiveTableHandle.isPresent() ? metastore.getTable(metastoreContext, this.hiveTableHandle.get()) : metastore.getTable(metastoreContext, this.schemaTableName.getSchemaName(), this.schemaTableName.getTableName());
        return (Table)table.orElseThrow(() -> new TableNotFoundException(this.schemaTableName));
    }

    public Builder builder() {
        return new Builder().setSchemaTableName(this.getSchemaTableName()).setTablePath(this.getTablePath()).setPartitionColumns(this.getPartitionColumns()).setDataColumns(this.getDataColumns()).setTableParameters(this.getTableParameters()).setDomainPredicate(this.getDomainPredicate()).setRemainingPredicate(this.getRemainingPredicate()).setPredicateColumns(this.getPredicateColumns()).setPartitionColumnPredicate(this.getPartitionColumnPredicate()).setBucketHandle(this.getBucketHandle()).setBucketFilter(this.getBucketFilter()).setPushdownFilterEnabled(this.isPushdownFilterEnabled()).setLayoutString(this.getLayoutString()).setRequestedColumns(this.getRequestedColumns()).setPartialAggregationsPushedDown(this.isPartialAggregationsPushedDown()).setAppendRowNumberEnabled(this.isAppendRowNumberEnabled()).setPartitions(this.getPartitions()).setFooterStatsUnreliable(this.isFooterStatsUnreliable()).setHiveTableHandle(this.getHiveTableHandle());
    }

    public static class Builder {
        private SchemaTableName schemaTableName;
        private String tablePath;
        private List<HiveColumnHandle> partitionColumns;
        private List<Column> dataColumns;
        private Map<String, String> tableParameters;
        private TupleDomain<Subfield> domainPredicate;
        private RowExpression remainingPredicate;
        private Map<String, HiveColumnHandle> predicateColumns;
        private TupleDomain<ColumnHandle> partitionColumnPredicate;
        private Optional<HiveBucketHandle> bucketHandle;
        private Optional<HiveBucketing.HiveBucketFilter> bucketFilter;
        private boolean pushdownFilterEnabled;
        private String layoutString;
        private Optional<Set<HiveColumnHandle>> requestedColumns;
        private boolean partialAggregationsPushedDown;
        private boolean appendRowNumberEnabled;
        private boolean footerStatsUnreliable;
        private Optional<List<HivePartition>> partitions;
        private Optional<HiveTableHandle> hiveTableHandle = Optional.empty();

        public Builder setSchemaTableName(SchemaTableName schemaTableName) {
            this.schemaTableName = schemaTableName;
            return this;
        }

        public Builder setTablePath(String tablePath) {
            this.tablePath = tablePath;
            return this;
        }

        public Builder setPartitionColumns(List<HiveColumnHandle> partitionColumns) {
            this.partitionColumns = partitionColumns;
            return this;
        }

        public Builder setDataColumns(List<Column> dataColumns) {
            this.dataColumns = dataColumns;
            return this;
        }

        public Builder setTableParameters(Map<String, String> tableParameters) {
            this.tableParameters = tableParameters;
            return this;
        }

        public Builder setDomainPredicate(TupleDomain<Subfield> domainPredicate) {
            this.domainPredicate = domainPredicate;
            return this;
        }

        public Builder setRemainingPredicate(RowExpression remainingPredicate) {
            this.remainingPredicate = remainingPredicate;
            return this;
        }

        public Builder setPredicateColumns(Map<String, HiveColumnHandle> predicateColumns) {
            this.predicateColumns = predicateColumns;
            return this;
        }

        public Builder setPartitionColumnPredicate(TupleDomain<ColumnHandle> partitionColumnPredicate) {
            this.partitionColumnPredicate = partitionColumnPredicate;
            return this;
        }

        public Builder setBucketHandle(Optional<HiveBucketHandle> bucketHandle) {
            this.bucketHandle = bucketHandle;
            return this;
        }

        public Builder setBucketFilter(Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
            this.bucketFilter = bucketFilter;
            return this;
        }

        public Builder setPushdownFilterEnabled(boolean pushdownFilterEnabled) {
            this.pushdownFilterEnabled = pushdownFilterEnabled;
            return this;
        }

        public Builder setLayoutString(String layoutString) {
            this.layoutString = layoutString;
            return this;
        }

        public Builder setRequestedColumns(Optional<Set<HiveColumnHandle>> requestedColumns) {
            this.requestedColumns = requestedColumns;
            return this;
        }

        public Builder setPartialAggregationsPushedDown(boolean partialAggregationsPushedDown) {
            this.partialAggregationsPushedDown = partialAggregationsPushedDown;
            return this;
        }

        public Builder setAppendRowNumberEnabled(boolean appendRowNumberEnabled) {
            this.appendRowNumberEnabled = appendRowNumberEnabled;
            return this;
        }

        public Builder setPartitions(List<HivePartition> partitions) {
            Objects.requireNonNull(partitions, "partitions is null");
            return this.setPartitions(Optional.of(partitions));
        }

        public Builder setPartitions(Optional<List<HivePartition>> partitions) {
            Objects.requireNonNull(partitions, "partitions is null");
            this.partitions = partitions;
            return this;
        }

        public Builder setFooterStatsUnreliable(boolean footerStatsUnreliable) {
            this.footerStatsUnreliable = footerStatsUnreliable;
            return this;
        }

        public Builder setHiveTableHandle(Optional<HiveTableHandle> hiveTableHandle) {
            this.hiveTableHandle = Objects.requireNonNull(hiveTableHandle, "hiveTableHandle is null");
            return this;
        }

        public Builder setHiveTableHandle(HiveTableHandle hiveTableHandle) {
            Objects.requireNonNull(hiveTableHandle, "hiveTableHandle is null");
            this.hiveTableHandle = Optional.of(hiveTableHandle);
            return this;
        }

        public HiveTableLayoutHandle build() {
            return new HiveTableLayoutHandle(this.schemaTableName, this.tablePath, this.partitionColumns, this.dataColumns, this.tableParameters, this.domainPredicate, this.remainingPredicate, this.predicateColumns, this.partitionColumnPredicate, this.bucketHandle, this.bucketFilter, this.pushdownFilterEnabled, this.layoutString, this.requestedColumns, this.partialAggregationsPushedDown, this.appendRowNumberEnabled, this.partitions, this.footerStatsUnreliable, this.hiveTableHandle);
        }
    }
}

