/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.metastore.HivePageSinkMetadata;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveWritableTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<HiveColumnHandle> inputColumns;
    private final HivePageSinkMetadata pageSinkMetadata;
    private final LocationHandle locationHandle;
    private final Optional<HiveBucketProperty> bucketProperty;
    private final List<SortingColumn> preferredOrderingColumns;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final HiveStorageFormat actualStorageFormat;
    private final HiveCompressionCodec compressionCodec;
    private final Optional<EncryptionInformation> encryptionInformation;

    public HiveWritableTableHandle(String schemaName, String tableName, List<HiveColumnHandle> inputColumns, HivePageSinkMetadata pageSinkMetadata, LocationHandle locationHandle, Optional<HiveBucketProperty> bucketProperty, List<SortingColumn> preferredOrderingColumns, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, HiveStorageFormat actualStorageFormat, HiveCompressionCodec compressionCodec, Optional<EncryptionInformation> encryptionInformation) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.inputColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputColumns, "inputColumns is null"));
        this.pageSinkMetadata = Objects.requireNonNull(pageSinkMetadata, "pageSinkMetadata is null");
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.bucketProperty = Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.preferredOrderingColumns = Objects.requireNonNull(preferredOrderingColumns, "preferredOrderingColumns is null");
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.actualStorageFormat = Objects.requireNonNull(actualStorageFormat, "actualStorageFormat is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
        this.encryptionInformation = Objects.requireNonNull(encryptionInformation, "encryptionInformation is null");
        if (!compressionCodec.isSupportedStorageFormat(actualStorageFormat)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("%s compression is not supported with %s", compressionCodec.name(), actualStorageFormat.name()));
        }
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<HiveColumnHandle> getInputColumns() {
        return this.inputColumns;
    }

    @JsonIgnore
    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @JsonProperty
    public HivePageSinkMetadata getPageSinkMetadata() {
        return this.pageSinkMetadata;
    }

    @JsonProperty
    public LocationHandle getLocationHandle() {
        return this.locationHandle;
    }

    @JsonProperty
    public Optional<HiveBucketProperty> getBucketProperty() {
        return this.bucketProperty;
    }

    @JsonProperty
    public List<SortingColumn> getPreferredOrderingColumns() {
        return this.preferredOrderingColumns;
    }

    @Deprecated
    @JsonProperty
    public HiveStorageFormat getTableStorageFormat() {
        return this.tableStorageFormat;
    }

    @Deprecated
    @JsonProperty
    public HiveStorageFormat getPartitionStorageFormat() {
        return this.partitionStorageFormat;
    }

    @JsonProperty
    public HiveStorageFormat getActualStorageFormat() {
        return this.actualStorageFormat;
    }

    @JsonProperty
    public HiveCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    @JsonProperty
    public Optional<EncryptionInformation> getEncryptionInformation() {
        return this.encryptionInformation;
    }

    public String toString() {
        return this.schemaName + "." + this.tableName;
    }
}

