/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveDirectoryContext;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.HiveManifestUtils;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplitPartitionInfo;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.NestedDirectoryPolicy;
import com.facebook.presto.hive.PartitionLoader;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.InternalHiveSplitFactory;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputFormat;

public class ManifestPartitionLoader
extends PartitionLoader {
    private static final String[] BLOCK_LOCATION_NAMES = new String[]{"localhost:50010"};
    private static final String[] BLOCK_LOCATION_HOSTS = new String[]{"localhost"};
    private final Table table;
    private final Optional<Domain> pathDomain;
    private final ConnectorSession session;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsContext hdfsContext;
    private final NamenodeStats namenodeStats;
    private final DirectoryLister directoryLister;
    private final boolean recursiveDirWalkerEnabled;
    private final boolean schedulerUsesHostAddresses;

    public ManifestPartitionLoader(Table table, Optional<Domain> pathDomain, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, boolean recursiveDirWalkerEnabled, boolean schedulerUsesHostAddresses) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.pathDomain = Objects.requireNonNull(pathDomain, "pathDomain is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.hdfsContext = new HdfsContext(session, table.getDatabaseName(), table.getTableName(), table.getStorage().getLocation(), false);
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        this.schedulerUsesHostAddresses = schedulerUsesHostAddresses;
    }

    @Override
    public ListenableFuture<?> loadPartition(HivePartitionMetadata partition, HiveSplitSource hiveSplitSource, boolean stopped) throws IOException {
        Path path = new Path(MetastoreUtil.getPartitionLocation((Table)this.table, partition.getPartition()));
        Map parameters = partition.getPartition().get().getParameters();
        Verify.verify((boolean)"V1".equals(parameters.get("MANIFEST_VERSION")), (String)"Manifest version is not equal to %s", (Object)"V1");
        List<String> fileNames = HiveManifestUtils.decompressFileNames((String)parameters.get("FILE_NAMES"));
        List<Long> fileSizes = HiveManifestUtils.decompressFileSizes((String)parameters.get("FILE_SIZES"));
        Verify.verify((fileNames.size() == fileSizes.size() ? 1 : 0) != 0, (String)"List of fileNames and fileSizes differ in length", (Object[])new Object[0]);
        if (HiveSessionProperties.isManifestVerificationEnabled(this.session)) {
            this.validateManifest(this.session, partition, path, fileNames, fileSizes);
        }
        ImmutableList.Builder fileListBuilder = ImmutableList.builder();
        for (int i = 0; i < fileNames.size(); ++i) {
            Path filePath = new Path(path, fileNames.get(i));
            FileStatus fileStatus = new FileStatus(fileSizes.get(i).longValue(), false, 1, HiveSessionProperties.getMaxSplitSize(this.session).toBytes(), 0L, filePath);
            try {
                BlockLocation[] locations = new BlockLocation[]{new BlockLocation(BLOCK_LOCATION_NAMES, BLOCK_LOCATION_HOSTS, 0L, fileSizes.get(i).longValue())};
                fileListBuilder.add((Object)HiveFileInfo.createHiveFileInfo((LocatedFileStatus)new LocatedFileStatus(fileStatus, locations), Optional.empty()));
                continue;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        InternalHiveSplitFactory splitFactory = this.createInternalHiveSplitFactory(this.table, partition, this.session, this.pathDomain, this.hdfsEnvironment, this.hdfsContext, this.schedulerUsesHostAddresses);
        return hiveSplitSource.addToQueue((List)fileListBuilder.build().stream().map(status -> splitFactory.createInternalHiveSplit((HiveFileInfo)status, true)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList()));
    }

    private InternalHiveSplitFactory createInternalHiveSplitFactory(Table table, HivePartitionMetadata partition, ConnectorSession session, Optional<Domain> pathDomain, HdfsEnvironment hdfsEnvironment, HdfsContext hdfsContext, boolean schedulerUsesHostAddresses) throws IOException {
        String partitionName = partition.getHivePartition().getPartitionId();
        Storage storage = partition.getPartition().map(Partition::getStorage).orElse(table.getStorage());
        String inputFormatName = storage.getStorageFormat().getInputFormat();
        int partitionDataColumnCount = partition.getPartition().map(p -> p.getColumns().size()).orElse(table.getDataColumns().size());
        List<HivePartitionKey> partitionKeys = this.getPartitionKeys(table, partition.getPartition(), partitionName);
        Path path = new Path(MetastoreUtil.getPartitionLocation((Table)table, partition.getPartition()));
        Configuration configuration = hdfsEnvironment.getConfiguration(hdfsContext, path);
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, inputFormatName, false);
        ExtendedFileSystem fileSystem = hdfsEnvironment.getFileSystem(hdfsContext, path);
        return new InternalHiveSplitFactory((FileSystem)fileSystem, inputFormat, pathDomain, HiveSessionProperties.getNodeSelectionStrategy(session), HiveSessionProperties.getMaxInitialSplitSize(session), false, new HiveSplitPartitionInfo(storage, path.toUri(), partitionKeys, partitionName, partitionDataColumnCount, partition.getTableToPartitionMapping(), Optional.empty(), partition.getRedundantColumnDomains()), schedulerUsesHostAddresses, partition.getEncryptionInformation());
    }

    private void validateManifest(ConnectorSession session, HivePartitionMetadata partition, Path path, List<String> manifestFileNames, List<Long> manifestFileSizes) throws IOException {
        ExtendedFileSystem fileSystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, path);
        HiveDirectoryContext hiveDirectoryContext = new HiveDirectoryContext(this.recursiveDirWalkerEnabled ? NestedDirectoryPolicy.RECURSE : NestedDirectoryPolicy.IGNORED, false, this.hdfsContext.getIdentity(), HiveUtil.buildDirectoryContextProperties(session));
        Iterator<HiveFileInfo> fileInfoIterator = this.directoryLister.list(fileSystem, this.table, path, partition.getPartition(), this.namenodeStats, hiveDirectoryContext);
        int fileCount = 0;
        while (fileInfoIterator.hasNext()) {
            HiveFileInfo fileInfo = fileInfoIterator.next();
            String fileName = fileInfo.getPath().getName();
            if (!manifestFileNames.contains(fileName)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.MALFORMED_HIVE_FILE_STATISTICS, String.format("Filename = %s not stored in manifest. Partition = %s, TableName = %s", fileName, partition.getHivePartition().getPartitionId(), this.table.getTableName()));
            }
            int index = manifestFileNames.indexOf(fileName);
            if (!manifestFileSizes.get(index).equals(fileInfo.getLength())) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.MALFORMED_HIVE_FILE_STATISTICS, String.format("FilesizeFromManifest = %s is not equal to FilesizeFromStorage = %s. File = %s, Partition = %s, TableName = %s", manifestFileSizes.get(index), fileInfo.getLength(), fileName, partition.getHivePartition().getPartitionId(), this.table.getTableName()));
            }
            ++fileCount;
        }
        if (fileCount != manifestFileNames.size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.MALFORMED_HIVE_FILE_STATISTICS, String.format("Number of files in Manifest = %s is not equal to Number of files in storage = %s. Partition = %s, TableName = %s", manifestFileNames.size(), fileCount, partition.getHivePartition().getPartitionId(), this.table.getTableName()));
        }
    }
}

