/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.HiveManifestUtils;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfWriterEncryption;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class OrcFileWriter
implements HiveFileWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OrcFileWriter.class).instanceSize();
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    protected final OrcWriter orcWriter;
    private final Callable<Void> rollbackAction;
    private final int[] fileInputColumnIndexes;
    private final List<Block> nullBlocks;
    private final Optional<Supplier<OrcDataSource>> validationInputFactory;
    private long validationCpuNanos;
    private long rowCount;

    public OrcFileWriter(DataSink dataSink, Callable<Void> rollbackAction, OrcEncoding orcEncoding, List<String> columnNames, List<Type> fileColumnTypes, CompressionKind compression, OrcWriterOptions options, int[] fileInputColumnIndexes, Map<String, String> metadata, DateTimeZone hiveStorageTimeZone, Optional<Supplier<OrcDataSource>> validationInputFactory, OrcWriteValidation.OrcWriteValidationMode validationMode, WriterStats stats, DwrfEncryptionProvider dwrfEncryptionProvider, Optional<DwrfWriterEncryption> dwrfWriterEncryption) {
        this(dataSink, rollbackAction, orcEncoding, columnNames, fileColumnTypes, Optional.empty(), compression, options, fileInputColumnIndexes, metadata, hiveStorageTimeZone, validationInputFactory, validationMode, stats, dwrfEncryptionProvider, dwrfWriterEncryption);
    }

    public OrcFileWriter(DataSink dataSink, Callable<Void> rollbackAction, OrcEncoding orcEncoding, List<String> columnNames, List<Type> fileColumnTypes, Optional<List<OrcType>> fileColumnOrcTypes, CompressionKind compression, OrcWriterOptions options, int[] fileInputColumnIndexes, Map<String, String> metadata, ZoneId hiveStorageTimeZone, Optional<Supplier<OrcDataSource>> validationInputFactory, OrcWriteValidation.OrcWriteValidationMode validationMode, WriterStats stats, DwrfEncryptionProvider dwrfEncryptionProvider, Optional<DwrfWriterEncryption> dwrfWriterEncryption) {
        this(dataSink, rollbackAction, orcEncoding, columnNames, fileColumnTypes, fileColumnOrcTypes, compression, options, fileInputColumnIndexes, metadata, DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(ZoneId.of(hiveStorageTimeZone.getId()))), validationInputFactory, validationMode, stats, dwrfEncryptionProvider, dwrfWriterEncryption);
    }

    public OrcFileWriter(DataSink dataSink, Callable<Void> rollbackAction, OrcEncoding orcEncoding, List<String> columnNames, List<Type> fileColumnTypes, Optional<List<OrcType>> fileColumnOrcTypes, CompressionKind compression, OrcWriterOptions options, int[] fileInputColumnIndexes, Map<String, String> metadata, DateTimeZone hiveStorageTimeZone, Optional<Supplier<OrcDataSource>> validationInputFactory, OrcWriteValidation.OrcWriteValidationMode validationMode, WriterStats stats, DwrfEncryptionProvider dwrfEncryptionProvider, Optional<DwrfWriterEncryption> dwrfWriterEncryption) {
        Objects.requireNonNull(dataSink, "dataSink is null");
        try {
            this.orcWriter = new OrcWriter(dataSink, columnNames, fileColumnTypes, fileColumnOrcTypes, orcEncoding, compression, dwrfWriterEncryption, dwrfEncryptionProvider, options, metadata, hiveStorageTimeZone, validationInputFactory.isPresent(), validationMode, stats);
        }
        catch (NotSupportedException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
        }
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction is null");
        this.fileInputColumnIndexes = Objects.requireNonNull(fileInputColumnIndexes, "outputColumnInputIndexes is null");
        ImmutableList.Builder nullBlocks = ImmutableList.builder();
        for (Type fileColumnType : fileColumnTypes) {
            BlockBuilder blockBuilder = fileColumnType.createBlockBuilder(null, 1, 0);
            blockBuilder.appendNull();
            nullBlocks.add((Object)blockBuilder.build());
        }
        this.nullBlocks = nullBlocks.build();
        this.validationInputFactory = validationInputFactory;
    }

    @Override
    public long getWrittenBytes() {
        return this.orcWriter.getWrittenBytes() + (long)this.orcWriter.getBufferedBytes();
    }

    @Override
    public long getFileSizeInBytes() {
        return this.orcWriter.getWrittenBytes();
    }

    @Override
    public long getSystemMemoryUsage() {
        return (long)INSTANCE_SIZE + this.orcWriter.getRetainedBytes();
    }

    @Override
    public void appendRows(Page dataPage) {
        Block[] blocks = new Block[this.fileInputColumnIndexes.length];
        for (int i = 0; i < this.fileInputColumnIndexes.length; ++i) {
            int inputColumnIndex = this.fileInputColumnIndexes[i];
            blocks[i] = inputColumnIndex < 0 ? new RunLengthEncodedBlock(this.nullBlocks.get(i), dataPage.getPositionCount()) : dataPage.getBlock(inputColumnIndex);
        }
        Page page = new Page(dataPage.getPositionCount(), blocks);
        try {
            this.orcWriter.write(page);
            this.rowCount += (long)page.getPositionCount();
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Page> commit() {
        try {
            this.orcWriter.close();
        }
        catch (IOException | UncheckedIOException e) {
            try {
                this.rollbackAction.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive. " + e.getMessage(), (Throwable)e);
        }
        if (this.validationInputFactory.isPresent()) {
            try (OrcDataSource input = this.validationInputFactory.get().get();){
                long startThreadCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
                this.orcWriter.validate(input);
                this.validationCpuNanos += THREAD_MX_BEAN.getCurrentThreadCpuTime() - startThreadCpuTime;
            }
            catch (IOException | UncheckedIOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
            }
        }
        return Optional.of(HiveManifestUtils.createFileStatisticsPage(this.getFileSizeInBytes(), this.rowCount));
    }

    @Override
    public void rollback() {
        try {
            try {
                this.orcWriter.close();
            }
            finally {
                this.rollbackAction.call();
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    @Override
    public long getValidationCpuNanos() {
        return this.validationCpuNanos;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("writer", (Object)this.orcWriter).toString();
    }
}

