/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.parquet.AbstractParquetDataSource;
import com.facebook.presto.parquet.ParquetDataSourceId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.format.ColumnIndex;
import org.apache.parquet.format.OffsetIndex;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.internal.hadoop.metadata.IndexReference;
import org.apache.parquet.schema.PrimitiveType;

public class HdfsParquetDataSource
extends AbstractParquetDataSource {
    private final FSDataInputStream inputStream;
    private final FileFormatDataSourceStats stats;

    public HdfsParquetDataSource(ParquetDataSourceId id, FSDataInputStream inputStream, FileFormatDataSourceStats stats) {
        super(id);
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        try {
            long start = System.nanoTime();
            this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
            this.stats.readDataBytesPerSecond(bufferLength, System.nanoTime() - start);
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error reading from %s at position %s", this.getId(), position), (Throwable)e);
        }
    }

    public Optional<org.apache.parquet.internal.column.columnindex.ColumnIndex> readColumnIndex(ColumnChunkMetaData column) throws IOException {
        IndexReference indexRef = column.getColumnIndexReference();
        if (indexRef == null) {
            return Optional.empty();
        }
        this.inputStream.seek(indexRef.getOffset());
        return Optional.of(ParquetMetadataConverter.fromParquetColumnIndex((PrimitiveType)column.getPrimitiveType(), (ColumnIndex)Util.readColumnIndex((InputStream)this.inputStream)));
    }

    public Optional<org.apache.parquet.internal.column.columnindex.OffsetIndex> readOffsetIndex(ColumnChunkMetaData column) throws IOException {
        IndexReference indexRef = column.getOffsetIndexReference();
        if (indexRef == null) {
            return Optional.empty();
        }
        this.inputStream.seek(indexRef.getOffset());
        return Optional.of(ParquetMetadataConverter.fromParquetOffsetIndex((OffsetIndex)Util.readOffsetIndex((InputStream)this.inputStream)));
    }

    public static HdfsParquetDataSource buildHdfsParquetDataSource(FileSystem fileSystem, Path path, long start, long length, FileFormatDataSourceStats stats) {
        try {
            FSDataInputStream inputStream = fileSystem.open(path);
            return new HdfsParquetDataSource(new ParquetDataSourceId(path.toString()), inputStream, stats);
        }
        catch (Exception e) {
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage()), (Throwable)e);
        }
    }

    public static HdfsParquetDataSource buildHdfsParquetDataSource(FSDataInputStream inputStream, Path path, FileFormatDataSourceStats stats) {
        return new HdfsParquetDataSource(new ParquetDataSourceId(path.toString()), inputStream, stats);
    }
}

