/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rule;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.expressions.DynamicFilters;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTableProperties;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.HiveWarningCode;
import com.facebook.presto.hive.SubfieldExtractor;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorPlanRewriter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class HiveFilterPushdown
implements ConnectorPlanOptimizer {
    private static final ConnectorTableLayout EMPTY_TABLE_LAYOUT = new ConnectorTableLayout(new ConnectorTableLayoutHandle(){}, Optional.empty(), TupleDomain.none(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
    protected final HiveTransactionManager transactionManager;
    protected final RowExpressionService rowExpressionService;
    protected final StandardFunctionResolution functionResolution;
    protected final HivePartitionManager partitionManager;
    protected final FunctionMetadataManager functionMetadataManager;

    public HiveFilterPushdown(HiveTransactionManager transactionManager, RowExpressionService rowExpressionService, StandardFunctionResolution functionResolution, HivePartitionManager partitionManager, FunctionMetadataManager functionMetadataManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
    }

    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        return ConnectorPlanRewriter.rewriteWith((ConnectorPlanRewriter)new Rewriter(session, idAllocator), (PlanNode)maxSubplan);
    }

    protected boolean useDynamicFilter(RowExpression expression, ConnectorTableHandle tableHandle, Map<String, ColumnHandle> columnHandleMap) {
        return false;
    }

    protected ConnectorPushdownFilterResult pushdownFilter(ConnectorSession session, HiveMetadata metadata, ConnectorTableHandle tableHandle, RowExpression filter, Optional<ConnectorTableLayoutHandle> currentLayoutHandle) {
        return this.pushdownFilter(session, metadata, metadata.getMetastore(), tableHandle, filter, currentLayoutHandle);
    }

    public ConnectorPushdownFilterResult pushdownFilter(ConnectorSession session, ConnectorMetadata metadata, SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, RowExpression filter, Optional<ConnectorTableLayoutHandle> currentLayoutHandle) {
        LogicalRowExpressions logicalRowExpressions;
        RowExpression deterministicPredicate;
        ConstantExpression constantExpression;
        Preconditions.checkArgument((!LogicalRowExpressions.FALSE_CONSTANT.equals((Object)filter) ? 1 : 0) != 0, (Object)"Cannot pushdown filter that is always false");
        if (LogicalRowExpressions.TRUE_CONSTANT.equals((Object)filter) && currentLayoutHandle.isPresent()) {
            return new ConnectorPushdownFilterResult(metadata.getTableLayout(session, currentLayoutHandle.get()), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
        }
        DomainTranslator.ExtractionResult decomposedFilter = this.rowExpressionService.getDomainTranslator().fromPredicate(session, filter, new SubfieldExtractor(this.functionResolution, this.rowExpressionService.getExpressionOptimizer(), session).toColumnExtractor());
        if (currentLayoutHandle.isPresent()) {
            HiveTableLayoutHandle currentHiveLayout = (HiveTableLayoutHandle)currentLayoutHandle.get();
            decomposedFilter = HiveFilterPushdown.intersectExtractionResult(new DomainTranslator.ExtractionResult(currentHiveLayout.getDomainPredicate(), currentHiveLayout.getRemainingPredicate()), decomposedFilter);
        }
        if (decomposedFilter.getTupleDomain().isNone()) {
            return new ConnectorPushdownFilterResult(EMPTY_TABLE_LAYOUT, (RowExpression)LogicalRowExpressions.FALSE_CONSTANT);
        }
        RowExpression optimizedRemainingExpression = this.rowExpressionService.getExpressionOptimizer().optimize(decomposedFilter.getRemainingExpression(), ExpressionOptimizer.Level.OPTIMIZED, session);
        if (optimizedRemainingExpression instanceof ConstantExpression && (LogicalRowExpressions.FALSE_CONSTANT.equals((Object)(constantExpression = (ConstantExpression)optimizedRemainingExpression)) || constantExpression.getValue() == null)) {
            return new ConnectorPushdownFilterResult(EMPTY_TABLE_LAYOUT, (RowExpression)LogicalRowExpressions.FALSE_CONSTANT);
        }
        Map columnHandles = metadata.getColumnHandles(session, tableHandle);
        TupleDomain entireColumnDomain = decomposedFilter.getTupleDomain().transform(subfield -> HiveFilterPushdown.isEntireColumn(subfield) ? subfield.getRootName() : null).transform(columnHandles::get);
        if (currentLayoutHandle.isPresent()) {
            entireColumnDomain = entireColumnDomain.intersect(((HiveTableLayoutHandle)currentLayoutHandle.get()).getPartitionColumnPredicate());
        }
        Constraint constraint = new Constraint(entireColumnDomain);
        if (!LogicalRowExpressions.TRUE_CONSTANT.equals((Object)decomposedFilter.getRemainingExpression()) && !LogicalRowExpressions.TRUE_CONSTANT.equals((Object)(deterministicPredicate = (logicalRowExpressions = new LogicalRowExpressions(this.rowExpressionService.getDeterminismEvaluator(), this.functionResolution, this.functionMetadataManager)).filterDeterministicConjuncts(decomposedFilter.getRemainingExpression())))) {
            ConstraintEvaluator evaluator = new ConstraintEvaluator(this.rowExpressionService, session, columnHandles, deterministicPredicate);
            constraint = new Constraint(entireColumnDomain, x$0 -> evaluator.isCandidate(x$0));
        }
        HivePartitionResult hivePartitionResult = this.partitionManager.getPartitions(metastore, tableHandle, (Constraint<ColumnHandle>)constraint, session);
        TupleDomain domainPredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().putAll((Map)hivePartitionResult.getUnenforcedConstraint().transform(HiveFilterPushdown::toSubfield).getDomains().orElse(ImmutableMap.of())).putAll((Map)decomposedFilter.getTupleDomain().transform(subfield -> !HiveFilterPushdown.isEntireColumn(subfield) ? subfield : null).getDomains().orElse(ImmutableMap.of())).build());
        HashSet predicateColumnNames = new HashSet();
        ((Map)domainPredicate.getDomains().get()).keySet().stream().map(Subfield::getRootName).forEach(predicateColumnNames::add);
        HiveFilterPushdown.extractVariableExpressions(optimizedRemainingExpression).stream().map(VariableReferenceExpression::getName).forEach(predicateColumnNames::add);
        Map predicateColumns = (Map)predicateColumnNames.stream().map(columnHandles::get).map(HiveColumnHandle.class::cast).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, (Function)Functions.identity()));
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        LogicalRowExpressions logicalRowExpressions2 = new LogicalRowExpressions(this.rowExpressionService.getDeterminismEvaluator(), this.functionResolution, this.functionMetadataManager);
        List conjuncts = LogicalRowExpressions.extractConjuncts((RowExpression)decomposedFilter.getRemainingExpression());
        ImmutableList.Builder dynamicConjuncts = ImmutableList.builder();
        ImmutableList.Builder staticConjuncts = ImmutableList.builder();
        for (RowExpression conjunct : conjuncts) {
            if (DynamicFilters.isDynamicFilter((RowExpression)conjunct) || this.useDynamicFilter(conjunct, tableHandle, columnHandles)) {
                dynamicConjuncts.add((Object)conjunct);
                continue;
            }
            staticConjuncts.add((Object)conjunct);
        }
        RowExpression dynamicFilterExpression = logicalRowExpressions2.combineConjuncts((Collection)dynamicConjuncts.build());
        RowExpression remainingExpression = logicalRowExpressions2.combineConjuncts((Collection)staticConjuncts.build());
        remainingExpression = DynamicFilters.removeNestedDynamicFilters((RowExpression)remainingExpression);
        MetastoreContext context = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), MetastoreUtil.isUserDefinedTypeEncodingEnabled((ConnectorSession)session), metastore.getColumnConverterProvider());
        Table table = (Table)metastore.getTable(context, hiveTableHandle).orElseThrow(() -> new TableNotFoundException(tableName));
        String layoutString = HiveFilterPushdown.createTableLayoutString(session, this.rowExpressionService, tableName, hivePartitionResult.getBucketHandle(), hivePartitionResult.getBucketFilter(), remainingExpression, (TupleDomain<Subfield>)domainPredicate);
        Optional<Set<HiveColumnHandle>> requestedColumns = currentLayoutHandle.map(layout -> ((HiveTableLayoutHandle)layout).getRequestedColumns()).orElse(Optional.empty());
        boolean appendRowNumbereEnabled = currentLayoutHandle.map(layout -> ((HiveTableLayoutHandle)layout).isAppendRowNumberEnabled()).orElse(false);
        return new ConnectorPushdownFilterResult(metadata.getTableLayout(session, (ConnectorTableLayoutHandle)new HiveTableLayoutHandle.Builder().setSchemaTableName(tableName).setTablePath(table.getStorage().getLocation()).setPartitionColumns(hivePartitionResult.getPartitionColumns()).setDataColumns(HiveFilterPushdown.pruneColumnComments(hivePartitionResult.getDataColumns())).setTableParameters(hivePartitionResult.getTableParameters()).setDomainPredicate((TupleDomain<Subfield>)domainPredicate).setRemainingPredicate(remainingExpression).setPredicateColumns(predicateColumns).setPartitionColumnPredicate(hivePartitionResult.getEnforcedConstraint()).setPartitions(hivePartitionResult.getPartitions()).setBucketHandle(hivePartitionResult.getBucketHandle()).setBucketFilter(hivePartitionResult.getBucketFilter()).setPushdownFilterEnabled(true).setLayoutString(layoutString).setRequestedColumns(requestedColumns).setPartialAggregationsPushedDown(false).setAppendRowNumberEnabled(appendRowNumbereEnabled).setHiveTableHandle(hiveTableHandle).build()), dynamicFilterExpression);
    }

    protected HiveMetadata getMetadata(TableHandle tableHandle) {
        TransactionalMetadata metadata = this.transactionManager.get(tableHandle.getTransaction());
        Preconditions.checkState((boolean)(metadata instanceof HiveMetadata), (Object)"metadata must be HiveMetadata");
        return (HiveMetadata)metadata;
    }

    private static String getColumnName(ConnectorSession session, HiveMetadata metadata, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return metadata.getColumnMetadata(session, tableHandle, columnHandle).getName();
    }

    protected boolean isPushdownFilterSupported(ConnectorSession session, TableHandle tableHandle) {
        HiveStorageFormat hiveStorageFormat;
        Preconditions.checkArgument((boolean)(tableHandle.getConnectorHandle() instanceof HiveTableHandle), (Object)"pushdownFilter is never supported on a non-hive TableHandle");
        boolean pushdownFilterEnabled = HiveSessionProperties.isPushdownFilterEnabled(session);
        return pushdownFilterEnabled && ((hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(this.getMetadata(tableHandle).getTableMetadata(session, tableHandle.getConnectorHandle()).getProperties())) == HiveStorageFormat.ORC || hiveStorageFormat == HiveStorageFormat.DWRF || hiveStorageFormat == HiveStorageFormat.PARQUET && HiveSessionProperties.isParquetPushdownFilterEnabled(session));
    }

    private static DomainTranslator.ExtractionResult intersectExtractionResult(DomainTranslator.ExtractionResult left, DomainTranslator.ExtractionResult right) {
        RowExpression newRemainingExpression = right.getRemainingExpression().equals((Object)LogicalRowExpressions.TRUE_CONSTANT) ? left.getRemainingExpression() : (left.getRemainingExpression().equals((Object)LogicalRowExpressions.TRUE_CONSTANT) ? right.getRemainingExpression() : LogicalRowExpressions.and((RowExpression[])new RowExpression[]{left.getRemainingExpression(), right.getRemainingExpression()}));
        return new DomainTranslator.ExtractionResult(left.getTupleDomain().intersect(right.getTupleDomain()), newRemainingExpression);
    }

    private static boolean isEntireColumn(Subfield subfield) {
        return subfield.getPath().isEmpty();
    }

    private static List<Column> pruneColumnComments(List<Column> columns) {
        return (List)columns.stream().map(column -> new Column(column.getName(), column.getType(), Optional.empty(), column.getTypeMetadata())).collect(ImmutableList.toImmutableList());
    }

    private static String createTableLayoutString(ConnectorSession session, RowExpressionService rowExpressionService, SchemaTableName tableName, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter, RowExpression remainingPredicate, TupleDomain<Subfield> domainPredicate) {
        return MoreObjects.toStringHelper((String)tableName.toString()).omitNullValues().add("buckets", bucketHandle.map(HiveBucketHandle::getReadBucketCount).orElse(null)).add("bucketsToKeep", bucketFilter.map(HiveBucketing.HiveBucketFilter::getBucketsToKeep).orElse(null)).add("filter", LogicalRowExpressions.TRUE_CONSTANT.equals((Object)remainingPredicate) ? null : rowExpressionService.formatRowExpression(session, remainingPredicate)).add("domains", domainPredicate.isAll() ? null : domainPredicate.toString(session.getSqlFunctionProperties())).toString();
    }

    public static Set<VariableReferenceExpression> extractVariableExpressions(RowExpression expression) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        expression.accept((RowExpressionVisitor)new VariableReferenceBuilderVisitor(), (Object)builder);
        return builder.build();
    }

    private static Subfield toSubfield(ColumnHandle columnHandle) {
        return new Subfield(((HiveColumnHandle)columnHandle).getName(), (List)ImmutableList.of());
    }

    private static class VariableReferenceBuilderVisitor
    extends DefaultRowExpressionTraversalVisitor<ImmutableSet.Builder<VariableReferenceExpression>> {
        private VariableReferenceBuilderVisitor() {
        }

        public Void visitVariableReference(VariableReferenceExpression variable, ImmutableSet.Builder<VariableReferenceExpression> builder) {
            builder.add((Object)variable);
            return null;
        }
    }

    private static class ConstraintEvaluator {
        private final Map<String, ColumnHandle> assignments;
        private final RowExpressionService evaluator;
        private final ConnectorSession session;
        private final RowExpression expression;
        private final Set<ColumnHandle> arguments;

        public ConstraintEvaluator(RowExpressionService evaluator, ConnectorSession session, Map<String, ColumnHandle> assignments, RowExpression expression) {
            this.assignments = assignments;
            this.evaluator = evaluator;
            this.session = session;
            this.expression = expression;
            this.arguments = (Set)ImmutableSet.copyOf(HiveFilterPushdown.extractVariableExpressions(expression)).stream().map(VariableReferenceExpression::getName).map(assignments::get).collect(ImmutableSet.toImmutableSet());
        }

        private boolean isCandidate(Map<ColumnHandle, NullableValue> bindings) {
            if (Sets.intersection(bindings.keySet(), this.arguments).isEmpty()) {
                return true;
            }
            Function<VariableReferenceExpression, Object> variableResolver = variable -> {
                ColumnHandle column = this.assignments.get(variable.getName());
                Preconditions.checkArgument((column != null ? 1 : 0) != 0, (String)"Missing column assignment for %s", (Object)variable);
                if (!bindings.containsKey(column)) {
                    return variable;
                }
                return ((NullableValue)bindings.get(column)).getValue();
            };
            Object optimized = null;
            try {
                optimized = this.evaluator.getExpressionOptimizer().optimize(this.expression, ExpressionOptimizer.Level.OPTIMIZED, this.session, variableResolver);
            }
            catch (PrestoException e) {
                ConstraintEvaluator.propagateIfUnhandled(e);
                return true;
            }
            return !Boolean.FALSE.equals(optimized) && optimized != null && (!(optimized instanceof ConstantExpression) || !((ConstantExpression)optimized).isNull());
        }

        private static void propagateIfUnhandled(PrestoException e) throws PrestoException {
            int errorCode = e.getErrorCode().getCode();
            if (errorCode == StandardErrorCode.DIVISION_BY_ZERO.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode().getCode()) {
                return;
            }
            throw e;
        }
    }

    private class Rewriter
    extends ConnectorPlanRewriter<Void> {
        private final ConnectorSession session;
        private final PlanNodeIdAllocator idAllocator;

        Rewriter(ConnectorSession session, PlanNodeIdAllocator idAllocator) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        public PlanNode visitFilter(FilterNode filter, ConnectorPlanRewriter.RewriteContext<Void> context) {
            if (!(filter.getSource() instanceof TableScanNode)) {
                return this.visitPlan((PlanNode)filter, context);
            }
            TableScanNode tableScan = (TableScanNode)filter.getSource();
            if (!HiveFilterPushdown.this.isPushdownFilterSupported(this.session, tableScan.getTable())) {
                return filter;
            }
            RowExpression expression = filter.getPredicate();
            TableHandle handle = tableScan.getTable();
            HiveMetadata hiveMetadata = HiveFilterPushdown.this.getMetadata(handle);
            BiMap symbolToColumnMapping = (BiMap)tableScan.getAssignments().entrySet().stream().collect(ImmutableBiMap.toImmutableBiMap(Map.Entry::getKey, entry -> new VariableReferenceExpression(Optional.empty(), HiveFilterPushdown.getColumnName(this.session, hiveMetadata, handle.getConnectorHandle(), (ColumnHandle)entry.getValue()), ((VariableReferenceExpression)entry.getKey()).getType())));
            RowExpression replacedExpression = RowExpressionNodeInliner.replaceExpression((RowExpression)expression, (Map)symbolToColumnMapping);
            if (LogicalRowExpressions.FALSE_CONSTANT.equals((Object)replacedExpression)) {
                this.session.getWarningCollector().add(new PrestoWarning((WarningCodeSupplier)HiveWarningCode.HIVE_TABLESCAN_CONVERTED_TO_VALUESNODE, String.format("Table '%s' returns 0 rows, and is converted to an empty %s by %s", tableScan.getTable().getConnectorHandle(), ValuesNode.class.getSimpleName(), HiveFilterPushdown.class.getSimpleName())));
                return new ValuesNode(tableScan.getSourceLocation(), this.idAllocator.getNextId(), tableScan.getOutputVariables(), (List)ImmutableList.of(), Optional.of(tableScan.getTable().getConnectorHandle().toString()));
            }
            ConnectorPushdownFilterResult pushdownFilterResult = HiveFilterPushdown.this.pushdownFilter(this.session, hiveMetadata, handle.getConnectorHandle(), replacedExpression, handle.getLayout());
            ConnectorTableLayout layout = pushdownFilterResult.getLayout();
            if (layout.getPredicate().isNone()) {
                this.session.getWarningCollector().add(new PrestoWarning((WarningCodeSupplier)HiveWarningCode.HIVE_TABLESCAN_CONVERTED_TO_VALUESNODE, String.format("Table '%s' returns 0 rows, and is converted to an empty %s by %s", tableScan.getTable().getConnectorHandle(), ValuesNode.class.getSimpleName(), HiveFilterPushdown.class.getSimpleName())));
                return new ValuesNode(tableScan.getSourceLocation(), this.idAllocator.getNextId(), tableScan.getOutputVariables(), (List)ImmutableList.of(), Optional.of(tableScan.getTable().getConnectorHandle().toString()));
            }
            TableScanNode node = new TableScanNode(tableScan.getSourceLocation(), tableScan.getId(), new TableHandle(handle.getConnectorId(), handle.getConnectorHandle(), handle.getTransaction(), Optional.of(pushdownFilterResult.getLayout().getHandle())), tableScan.getOutputVariables(), tableScan.getAssignments(), tableScan.getTableConstraints(), layout.getPredicate(), TupleDomain.all());
            RowExpression unenforcedFilter = pushdownFilterResult.getUnenforcedConstraint();
            if (!LogicalRowExpressions.TRUE_CONSTANT.equals((Object)unenforcedFilter)) {
                return new FilterNode(tableScan.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)node, RowExpressionNodeInliner.replaceExpression((RowExpression)unenforcedFilter, (Map)symbolToColumnMapping.inverse()));
            }
            return node;
        }

        public PlanNode visitTableScan(TableScanNode tableScan, ConnectorPlanRewriter.RewriteContext<Void> context) {
            if (!HiveFilterPushdown.this.isPushdownFilterSupported(this.session, tableScan.getTable())) {
                return tableScan;
            }
            TableHandle handle = tableScan.getTable();
            HiveMetadata hiveMetadata = HiveFilterPushdown.this.getMetadata(handle);
            ConnectorPushdownFilterResult pushdownFilterResult = HiveFilterPushdown.this.pushdownFilter(this.session, hiveMetadata, handle.getConnectorHandle(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, handle.getLayout());
            if (pushdownFilterResult.getLayout().getPredicate().isNone()) {
                this.session.getWarningCollector().add(new PrestoWarning((WarningCodeSupplier)HiveWarningCode.HIVE_TABLESCAN_CONVERTED_TO_VALUESNODE, String.format("Table '%s' returns 0 rows, and is converted to an empty %s by %s", tableScan.getTable().getConnectorHandle(), ValuesNode.class.getSimpleName(), HiveFilterPushdown.class.getSimpleName())));
                return new ValuesNode(tableScan.getSourceLocation(), this.idAllocator.getNextId(), tableScan.getOutputVariables(), (List)ImmutableList.of(), Optional.of(tableScan.getTable().getConnectorHandle().toString()));
            }
            TableScanNode node = new TableScanNode(tableScan.getSourceLocation(), tableScan.getId(), new TableHandle(handle.getConnectorId(), handle.getConnectorHandle(), handle.getTransaction(), Optional.of(pushdownFilterResult.getLayout().getHandle())), tableScan.getOutputVariables(), tableScan.getAssignments(), tableScan.getTableConstraints(), pushdownFilterResult.getLayout().getPredicate(), TupleDomain.all());
            RowExpression unenforcedFilter = pushdownFilterResult.getUnenforcedConstraint();
            if (!LogicalRowExpressions.TRUE_CONSTANT.equals((Object)unenforcedFilter)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unenforced filter found %s but not handled", unenforcedFilter));
            }
            return node;
        }
    }

    public static class ConnectorPushdownFilterResult {
        private final ConnectorTableLayout layout;
        private final RowExpression unenforcedConstraint;

        public ConnectorPushdownFilterResult(ConnectorTableLayout layout, RowExpression unenforcedConstraint) {
            this.layout = Objects.requireNonNull(layout, "layout is null");
            this.unenforcedConstraint = Objects.requireNonNull(unenforcedConstraint, "unenforcedConstraint is null");
        }

        public ConnectorTableLayout getLayout() {
            return this.layout;
        }

        public RowExpression getUnenforcedConstraint() {
            return this.unenforcedConstraint;
        }
    }
}

