/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.presto.hive.security.LegacySecurityModule;
import com.facebook.presto.hive.security.SecurityConfig;
import com.facebook.presto.hive.security.SqlStandardSecurityModule;
import com.facebook.presto.hive.security.ranger.RangerBasedAccessControlModule;
import com.facebook.presto.plugin.base.security.FileBasedAccessControlModule;
import com.facebook.presto.plugin.base.security.ReadOnlySecurityModule;
import com.google.inject.Binder;
import com.google.inject.Module;

public class HiveSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindSecurityModule("legacy", new LegacySecurityModule());
        this.bindSecurityModule("file", (Module)new FileBasedAccessControlModule());
        this.bindSecurityModule("read-only", (Module)new ReadOnlySecurityModule());
        this.bindSecurityModule("sql-standard", new SqlStandardSecurityModule());
        this.bindSecurityModule("ranger", (Module)new RangerBasedAccessControlModule());
    }

    private void bindSecurityModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(SecurityConfig.class, security -> name.equalsIgnoreCase(security.getSecuritySystem()), (Module)module));
    }
}

