/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.HiveSplitWeightProvider;
import com.facebook.presto.spi.SplitWeight;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.Objects;

public class SizeBasedSplitWeightProvider
implements HiveSplitWeightProvider {
    private final double minimumWeight;
    private final double targetSplitSizeInBytes;

    public SizeBasedSplitWeightProvider(double minimumWeight, DataSize targetSplitSize) {
        Preconditions.checkArgument((Double.isFinite(minimumWeight) && minimumWeight > 0.0 && minimumWeight <= 1.0 ? 1 : 0) != 0, (String)"minimumWeight must be > 0 and <= 1, found: %s", (Object)minimumWeight);
        this.minimumWeight = minimumWeight;
        long targetSizeInBytes = Objects.requireNonNull(targetSplitSize, "targetSplitSize is null").toBytes();
        Preconditions.checkArgument((targetSizeInBytes > 0L ? 1 : 0) != 0, (String)"targetSplitSize must be > 0, found: %s", (Object)targetSplitSize);
        this.targetSplitSizeInBytes = targetSizeInBytes;
    }

    @Override
    public SplitWeight weightForSplitSizeInBytes(long splitSizeInBytes) {
        return SplitWeight.fromProportion((double)Math.min(Math.max((double)splitSizeInBytes / this.targetSplitSizeInBytes, this.minimumWeight), 1.0));
    }
}

