/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.hive.ManifestPartitionLoader;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.PartitionLoader;
import com.facebook.presto.hive.StoragePartitionLoader;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DelegatingPartitionLoader
extends PartitionLoader {
    private final ConnectorSession session;
    private final PartitionLoader storagePartitionLoader;
    private final PartitionLoader manifestPartitionLoader;

    public DelegatingPartitionLoader(Table table, Optional<Domain> pathDomain, Optional<StoragePartitionLoader.BucketSplitInfo> tableBucketInfo, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Deque<Iterator<InternalHiveSplit>> fileIterators, boolean recursiveDirWalkerEnabled, boolean schedulerUsesHostAddresses, boolean partialAggregationsPushedDown) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.storagePartitionLoader = new StoragePartitionLoader(table, pathDomain, tableBucketInfo, session, hdfsEnvironment, namenodeStats, directoryLister, fileIterators, recursiveDirWalkerEnabled, schedulerUsesHostAddresses, partialAggregationsPushedDown);
        this.manifestPartitionLoader = new ManifestPartitionLoader(table, pathDomain, session, hdfsEnvironment, namenodeStats, directoryLister, recursiveDirWalkerEnabled, schedulerUsesHostAddresses);
    }

    @Override
    public ListenableFuture<?> loadPartition(HivePartitionMetadata partition, HiveSplitSource hiveSplitSource, boolean stopped) throws IOException {
        if (DelegatingPartitionLoader.isListFilesLoadedPartition(this.session, partition.getPartition())) {
            return this.manifestPartitionLoader.loadPartition(partition, hiveSplitSource, stopped);
        }
        return this.storagePartitionLoader.loadPartition(partition, hiveSplitSource, stopped);
    }

    private static boolean isListFilesLoadedPartition(ConnectorSession session, Optional<Partition> partition) {
        if (partition.isPresent() && HiveSessionProperties.isPreferManifestsToListFiles(session)) {
            Map parameters = partition.get().getParameters();
            return parameters.containsKey("MANIFEST_VERSION");
        }
        return false;
    }
}

