/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.event.client.EventModule;
import com.facebook.airlift.json.JsonModule;
import com.facebook.airlift.json.smile.SmileModule;
import com.facebook.presto.cache.CachingModule;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveAnalyzeProperties;
import com.facebook.presto.hive.HiveClientModule;
import com.facebook.presto.hive.HiveCommonModule;
import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.hive.HiveConnector;
import com.facebook.presto.hive.HiveHandleResolver;
import com.facebook.presto.hive.HiveMetadataFactory;
import com.facebook.presto.hive.HiveProcedureModule;
import com.facebook.presto.hive.HiveSchemaProperties;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveTableProperties;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.RebindSafeMBeanServer;
import com.facebook.presto.hive.authentication.HiveAuthenticationModule;
import com.facebook.presto.hive.gcs.HiveGcsModule;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HiveMetastoreModule;
import com.facebook.presto.hive.s3.HiveS3Module;
import com.facebook.presto.hive.security.HiveSecurityModule;
import com.facebook.presto.hive.security.SystemTableAwareAccessControl;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorMetadataUpdaterProvider;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTypeSerdeProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorSplitManager;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeNodePartitioningProvider;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterStatsCalculatorService;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.MBeanModule;

public class HiveConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final ClassLoader classLoader;
    private final Optional<ExtendedHiveMetastore> metastore;

    public HiveConnectorFactory(String name, ClassLoader classLoader, Optional<ExtendedHiveMetastore> metastore) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new HiveHandleResolver();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new EventModule(), new MBeanModule(), new JsonModule(), new SmileModule(), new HiveClientModule(catalogName), new HiveS3Module(catalogName), new HiveGcsModule(), new HiveMetastoreModule(catalogName, this.metastore), new HiveSecurityModule(), new HiveAuthenticationModule(), new HiveProcedureModule(), new CachingModule(), new HiveCommonModule(), binder -> {
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                binder.bind(MBeanServer.class).toInstance((Object)new RebindSafeMBeanServer(platformMBeanServer));
                binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
                binder.bind(PageSorter.class).toInstance((Object)context.getPageSorter());
                binder.bind(StandardFunctionResolution.class).toInstance((Object)context.getStandardFunctionResolution());
                binder.bind(FunctionMetadataManager.class).toInstance((Object)context.getFunctionMetadataManager());
                binder.bind(RowExpressionService.class).toInstance((Object)context.getRowExpressionService());
                binder.bind(FilterStatsCalculatorService.class).toInstance((Object)context.getFilterStatsCalculatorService());
                binder.bind(BlockEncodingSerde.class).toInstance((Object)context.getBlockEncodingSerde());
            }});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).quiet().initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            HiveMetadataFactory metadataFactory = (HiveMetadataFactory)injector.getInstance(HiveMetadataFactory.class);
            HiveTransactionManager transactionManager = (HiveTransactionManager)injector.getInstance(HiveTransactionManager.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorPageSinkProvider pageSinkProvider = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            HiveSessionProperties hiveSessionProperties = (HiveSessionProperties)injector.getInstance(HiveSessionProperties.class);
            HiveCommonSessionProperties hiveCommonSessionProperties = (HiveCommonSessionProperties)injector.getInstance(HiveCommonSessionProperties.class);
            HiveTableProperties hiveTableProperties = (HiveTableProperties)injector.getInstance(HiveTableProperties.class);
            HiveAnalyzeProperties hiveAnalyzeProperties = (HiveAnalyzeProperties)injector.getInstance(HiveAnalyzeProperties.class);
            SystemTableAwareAccessControl accessControl = new SystemTableAwareAccessControl((ConnectorAccessControl)injector.getInstance(ConnectorAccessControl.class));
            Set procedures = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Procedure>>(){}));
            ConnectorPlanOptimizerProvider planOptimizerProvider = (ConnectorPlanOptimizerProvider)injector.getInstance(ConnectorPlanOptimizerProvider.class);
            ConnectorMetadataUpdaterProvider metadataUpdaterProvider = (ConnectorMetadataUpdaterProvider)injector.getInstance(ConnectorMetadataUpdaterProvider.class);
            ConnectorTypeSerdeProvider connectorTypeSerdeProvider = (ConnectorTypeSerdeProvider)injector.getInstance(ConnectorTypeSerdeProvider.class);
            ArrayList allSessionProperties = new ArrayList(hiveSessionProperties.getSessionProperties());
            allSessionProperties.addAll(hiveCommonSessionProperties.getSessionProperties());
            HiveConnector hiveConnector = new HiveConnector(lifeCycleManager, metadataFactory, transactionManager, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, this.classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, this.classLoader), (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(pageSinkProvider, this.classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, this.classLoader), (Set<SystemTable>)ImmutableSet.of(), procedures, allSessionProperties, HiveSchemaProperties.SCHEMA_PROPERTIES, hiveTableProperties.getTableProperties(), hiveAnalyzeProperties.getAnalyzeProperties(), (ConnectorAccessControl)accessControl, planOptimizerProvider, metadataUpdaterProvider, connectorTypeSerdeProvider, this.classLoader);
            return hiveConnector;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

