/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.hive.CopyOnFirstWriteConfiguration;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HiveDirectoryContext;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.cache.HiveCachingHdfsConfiguration;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.HiveFileIterator;
import com.facebook.presto.spi.ConnectorSession;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;

public class HudiDirectoryLister
implements DirectoryLister {
    private static final Logger log = Logger.get(HudiDirectoryLister.class);
    private final HoodieTableFileSystemView fileSystemView;
    private final HoodieTableMetaClient metaClient;
    private final boolean metadataEnabled;

    public HudiDirectoryLister(Configuration conf, ConnectorSession session, Table table) {
        log.info("Using Hudi Directory Lister.");
        this.metadataEnabled = HiveSessionProperties.isHudiMetadataEnabled(session);
        Configuration actualConfig = ((HiveCachingHdfsConfiguration.CachingJobConf)conf).getConfig();
        if (actualConfig instanceof CopyOnFirstWriteConfiguration) {
            actualConfig = ((CopyOnFirstWriteConfiguration)actualConfig).getConfig();
        }
        this.metaClient = HoodieTableMetaClient.builder().setConf(actualConfig).setBasePath(table.getStorage().getLocation()).build();
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(actualConfig);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(this.metadataEnabled).build();
        this.fileSystemView = FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)engineContext, (HoodieTableMetaClient)this.metaClient, (HoodieMetadataConfig)metadataConfig);
    }

    public HoodieTableMetaClient getMetaClient() {
        return this.metaClient;
    }

    @Override
    public Iterator<HiveFileInfo> list(ExtendedFileSystem fileSystem, Table table, Path path, Optional<Partition> partition, NamenodeStats namenodeStats, HiveDirectoryContext hiveDirectoryContext) {
        log.debug("Listing path using Hudi directory lister: %s", new Object[]{path.toString()});
        return new HiveFileIterator(path, p -> new HudiFileInfoIterator(this.fileSystemView, this.metadataEnabled ? Optional.empty() : Optional.of(fileSystem.listStatus(p)), table.getStorage().getLocation(), p), namenodeStats, hiveDirectoryContext.getNestedDirectoryPolicy());
    }

    public static class HudiFileInfoIterator
    implements RemoteIterator<HiveFileInfo> {
        private final Iterator<HoodieBaseFile> hoodieBaseFileIterator;

        public HudiFileInfoIterator(HoodieTableFileSystemView fileSystemView, Optional<FileStatus[]> fileStatuses, String tablePath, Path directory) {
            String partition = FSUtils.getRelativePartitionPath((Path)new Path(tablePath), (Path)directory);
            if (fileStatuses.isPresent()) {
                fileSystemView.addFilesToView(fileStatuses.get());
                this.hoodieBaseFileIterator = fileSystemView.fetchLatestBaseFiles(partition).iterator();
            } else {
                this.hoodieBaseFileIterator = fileSystemView.getLatestBaseFiles(partition).iterator();
            }
        }

        public boolean hasNext() {
            return this.hoodieBaseFileIterator.hasNext();
        }

        public HiveFileInfo next() throws IOException {
            FileStatus fileStatus = this.hoodieBaseFileIterator.next().getFileStatus();
            String[] name = new String[]{"localhost:50010"};
            String[] host = new String[]{"localhost"};
            LocatedFileStatus hoodieFileStatus = new LocatedFileStatus(fileStatus, new BlockLocation[]{new BlockLocation(name, host, 0L, fileStatus.getLen())});
            return HiveFileInfo.createHiveFileInfo((LocatedFileStatus)hoodieFileStatus, Optional.empty());
        }
    }
}

