/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rule;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTableProperties;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.rule.BaseSubfieldExtractionRewriter;
import com.facebook.presto.hive.rule.FilterPushdownUtils;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorPlanRewriter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class HiveFilterPushdown
implements ConnectorPlanOptimizer {
    private final RowExpressionService rowExpressionService;
    private final StandardFunctionResolution functionResolution;
    private final FunctionMetadataManager functionMetadataManager;
    protected final HiveTransactionManager transactionManager;
    private final HivePartitionManager partitionManager;

    public HiveFilterPushdown(RowExpressionService rowExpressionService, StandardFunctionResolution functionResolution, FunctionMetadataManager functionMetadataManager, HiveTransactionManager transactionManager, HivePartitionManager partitionManager) {
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
    }

    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        return ConnectorPlanRewriter.rewriteWith((ConnectorPlanRewriter)new SubfieldExtractionRewriter(session, idAllocator, this.rowExpressionService, this.functionResolution, this.functionMetadataManager, this.transactionManager, this.partitionManager, tableHandle -> HiveFilterPushdown.getConnectorMetadata(this.transactionManager, tableHandle)), (PlanNode)maxSubplan);
    }

    public static ConnectorMetadata getConnectorMetadata(HiveTransactionManager transactionManager, TableHandle tableHandle) {
        Objects.requireNonNull(transactionManager, "transactionManager is null");
        TransactionalMetadata metadata = transactionManager.get(tableHandle.getTransaction());
        Preconditions.checkState((boolean)(metadata instanceof HiveMetadata), (Object)"metadata must be HiveMetadata");
        return metadata;
    }

    private static List<Column> pruneColumnComments(List<Column> columns) {
        return (List)columns.stream().map(column -> new Column(column.getName(), column.getType(), Optional.empty(), column.getTypeMetadata())).collect(ImmutableList.toImmutableList());
    }

    private static String createTableLayoutString(ConnectorSession session, RowExpressionService rowExpressionService, SchemaTableName tableName, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter, RowExpression remainingPredicate, TupleDomain<Subfield> domainPredicate) {
        return MoreObjects.toStringHelper((String)tableName.toString()).omitNullValues().add("buckets", bucketHandle.map(HiveBucketHandle::getReadBucketCount).orElse(null)).add("bucketsToKeep", bucketFilter.map(HiveBucketing.HiveBucketFilter::getBucketsToKeep).orElse(null)).add("filter", LogicalRowExpressions.TRUE_CONSTANT.equals((Object)remainingPredicate) ? null : rowExpressionService.formatRowExpression(session, remainingPredicate)).add("domains", domainPredicate.isAll() ? null : domainPredicate.toString(session.getSqlFunctionProperties())).toString();
    }

    public static class SubfieldExtractionRewriter
    extends BaseSubfieldExtractionRewriter {
        private final HivePartitionManager partitionManager;

        public SubfieldExtractionRewriter(ConnectorSession session, PlanNodeIdAllocator idAllocator, RowExpressionService rowExpressionService, StandardFunctionResolution functionResolution, FunctionMetadataManager functionMetadataManager, HiveTransactionManager transactionManager, HivePartitionManager partitionManager, Function<TableHandle, ConnectorMetadata> transactionToMetadata) {
            super(session, idAllocator, rowExpressionService, functionResolution, functionMetadataManager, transactionToMetadata);
            this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        }

        public BaseSubfieldExtractionRewriter.ConnectorPushdownFilterResult getConnectorPushdownFilterResult(Map<String, ColumnHandle> columnHandles, ConnectorMetadata metadata, ConnectorSession session, BaseSubfieldExtractionRewriter.RemainingExpressions remainingExpressions, DomainTranslator.ExtractionResult<Subfield> decomposedFilter, RowExpression optimizedRemainingExpression, Constraint<ColumnHandle> constraint, Optional<ConnectorTableLayoutHandle> currentLayoutHandle, ConnectorTableHandle tableHandle) {
            HivePartitionResult hivePartitionResult = this.partitionManager.getPartitions(((HiveMetadata)metadata).getMetastore(), tableHandle, constraint, session);
            TupleDomain<ColumnHandle> unenforcedConstraint = hivePartitionResult.getUnenforcedConstraint();
            TupleDomain domainPredicate = FilterPushdownUtils.getDomainPredicate(decomposedFilter, unenforcedConstraint);
            Set predicateColumnNames = FilterPushdownUtils.getPredicateColumnNames((RowExpression)optimizedRemainingExpression, (TupleDomain)domainPredicate);
            Map predicateColumns = (Map)predicateColumnNames.stream().map(columnHandles::get).map(HiveColumnHandle.class::cast).collect(ImmutableMap.toImmutableMap(BaseHiveColumnHandle::getName, (Function)Functions.identity()));
            HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
            SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
            SemiTransactionalHiveMetastore metastore = ((HiveMetadata)metadata).getMetastore();
            MetastoreContext context = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), MetastoreUtil.isUserDefinedTypeEncodingEnabled((ConnectorSession)session), metastore.getColumnConverterProvider(), session.getWarningCollector());
            Table table = (Table)metastore.getTable(context, hiveTableHandle).orElseThrow(() -> new TableNotFoundException(tableName));
            String layoutString = HiveFilterPushdown.createTableLayoutString(session, this.rowExpressionService, tableName, hivePartitionResult.getBucketHandle(), hivePartitionResult.getBucketFilter(), remainingExpressions.getRemainingExpression(), (TupleDomain<Subfield>)domainPredicate);
            Optional<Set<HiveColumnHandle>> requestedColumns = currentLayoutHandle.map(layout -> ((HiveTableLayoutHandle)((Object)layout)).getRequestedColumns()).orElse(Optional.empty());
            boolean appendRowNumbereEnabled = currentLayoutHandle.map(layout -> ((HiveTableLayoutHandle)((Object)layout)).isAppendRowNumberEnabled()).orElse(false);
            return new BaseSubfieldExtractionRewriter.ConnectorPushdownFilterResult(metadata.getTableLayout(session, (ConnectorTableLayoutHandle)new HiveTableLayoutHandle.Builder().setSchemaTableName(tableName).setTablePath(table.getStorage().getLocation()).setPartitionColumns(hivePartitionResult.getPartitionColumns()).setDataColumns(HiveFilterPushdown.pruneColumnComments(hivePartitionResult.getDataColumns())).setTableParameters(hivePartitionResult.getTableParameters()).setDomainPredicate((TupleDomain<Subfield>)domainPredicate).setRemainingPredicate(remainingExpressions.getRemainingExpression()).setPredicateColumns(predicateColumns).setPartitionColumnPredicate(hivePartitionResult.getEnforcedConstraint()).setPartitions(hivePartitionResult.getPartitions()).setBucketHandle(hivePartitionResult.getBucketHandle()).setBucketFilter(hivePartitionResult.getBucketFilter()).setPushdownFilterEnabled(true).setLayoutString(layoutString).setRequestedColumns(requestedColumns).setPartialAggregationsPushedDown(false).setAppendRowNumberEnabled(appendRowNumbereEnabled).setHiveTableHandle(hiveTableHandle).build()), remainingExpressions.getDynamicFilterExpression());
        }

        protected boolean isPushdownFilterSupported(ConnectorSession session, TableHandle tableHandle) {
            Preconditions.checkArgument((boolean)(tableHandle.getConnectorHandle() instanceof HiveTableHandle), (Object)"pushdownFilter is never supported on a non-hive TableHandle");
            boolean pushdownFilterEnabled = HiveSessionProperties.isPushdownFilterEnabled(session);
            if (pushdownFilterEnabled) {
                HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(((ConnectorMetadata)this.transactionToMetadata.apply(tableHandle)).getTableMetadata(session, tableHandle.getConnectorHandle()).getProperties());
                return hiveStorageFormat == HiveStorageFormat.ORC || hiveStorageFormat == HiveStorageFormat.DWRF || hiveStorageFormat == HiveStorageFormat.PARQUET && HiveSessionProperties.isParquetPushdownFilterEnabled(session);
            }
            return false;
        }
    }
}

