/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rule;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.hive.rule.HiveAddRequestedColumnsToLayout;
import com.facebook.presto.hive.rule.HiveFilterPushdown;
import com.facebook.presto.hive.rule.HiveParquetDereferencePushDown;
import com.facebook.presto.hive.rule.HivePartialAggregationPushdown;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class HivePlanOptimizerProvider
implements ConnectorPlanOptimizerProvider {
    private final Set<ConnectorPlanOptimizer> planOptimizers;

    @Inject
    public HivePlanOptimizerProvider(HiveTransactionManager transactionManager, RowExpressionService rowExpressionService, StandardFunctionResolution functionResolution, HivePartitionManager partitionManager, FunctionMetadataManager functionMetadataManager, TypeManager typeManager, Supplier<TransactionalMetadata> metadataFactory) {
        Objects.requireNonNull(transactionManager, "transactionManager is null");
        Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        Objects.requireNonNull(functionResolution, "functionResolution is null");
        Objects.requireNonNull(partitionManager, "partitionManager is null");
        Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.planOptimizers = ImmutableSet.of((Object)new HiveFilterPushdown(rowExpressionService, functionResolution, functionMetadataManager, transactionManager, partitionManager), (Object)new HiveAddRequestedColumnsToLayout(), (Object)((Object)new HiveParquetDereferencePushDown(transactionManager, rowExpressionService)), (Object)new HivePartialAggregationPushdown(functionMetadataManager, functionResolution, metadataFactory));
    }

    public Set<ConnectorPlanOptimizer> getLogicalPlanOptimizers() {
        return this.planOptimizers;
    }

    public Set<ConnectorPlanOptimizer> getPhysicalPlanOptimizers() {
        return this.planOptimizers;
    }
}

