/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3select;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.s3.PrestoS3ClientFactory;
import com.facebook.presto.hive.s3select.S3SelectCsvRecordReader;
import com.facebook.presto.hive.s3select.S3SelectDataType;
import com.facebook.presto.hive.s3select.S3SelectJsonRecordReader;
import com.facebook.presto.hive.s3select.S3SelectLineRecordReader;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class S3SelectLineRecordReaderProvider {
    private S3SelectLineRecordReaderProvider() {
    }

    public static Optional<S3SelectLineRecordReader> get(Configuration configuration, HiveClientConfig clientConfig, Path path, long start, long length, long fileSize, Properties schema, String ionSqlQuery, PrestoS3ClientFactory s3ClientFactory, S3SelectDataType dataType) {
        switch (dataType) {
            case CSV: {
                return Optional.of(new S3SelectCsvRecordReader(configuration, clientConfig, path, start, length, fileSize, schema, ionSqlQuery, s3ClientFactory));
            }
            case JSON: {
                return Optional.of(new S3SelectJsonRecordReader(configuration, clientConfig, path, start, length, fileSize, schema, ionSqlQuery, s3ClientFactory));
            }
        }
        return Optional.empty();
    }
}

