/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3select;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.IonSqlQueryBuilder;
import com.facebook.presto.hive.s3.PrestoS3ClientFactory;
import com.facebook.presto.hive.s3select.S3SelectDataType;
import com.facebook.presto.hive.s3select.S3SelectLineRecordReader;
import com.facebook.presto.hive.s3select.S3SelectLineRecordReaderProvider;
import com.facebook.presto.hive.s3select.S3SelectRecordCursor;
import com.facebook.presto.hive.s3select.S3SelectSerDeDataTypeMapper;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.RecordReader;
import org.joda.time.DateTimeZone;

public class S3SelectRecordCursorProvider
implements HiveRecordCursorProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final HiveClientConfig clientConfig;
    private final PrestoS3ClientFactory s3ClientFactory;

    @Inject
    public S3SelectRecordCursorProvider(HdfsEnvironment hdfsEnvironment, HiveClientConfig clientConfig, PrestoS3ClientFactory s3ClientFactory) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.clientConfig = Objects.requireNonNull(clientConfig, "clientConfig is null");
        this.s3ClientFactory = Objects.requireNonNull(s3ClientFactory, "s3ClientFactory is null");
    }

    @Override
    public Optional<RecordCursor> createRecordCursor(Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, boolean s3SelectPushdownEnabled) {
        if (!s3SelectPushdownEnabled) {
            return Optional.empty();
        }
        Path path = new Path(fileSplit.getPath());
        try {
            this.hdfsEnvironment.getFileSystem(session.getUser(), path, configuration);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + path, (Throwable)e);
        }
        if (!S3SelectRecordCursorProvider.hasFilters(schema, effectivePredicate, columns)) {
            return Optional.empty();
        }
        String serdeName = HiveUtil.getDeserializerClassName(schema);
        Optional<S3SelectDataType> s3SelectDataTypeOptional = S3SelectSerDeDataTypeMapper.getDataType(serdeName);
        if (s3SelectDataTypeOptional.isPresent()) {
            S3SelectDataType s3SelectDataType = s3SelectDataTypeOptional.get();
            IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(typeManager, s3SelectDataType);
            String ionSqlQuery = queryBuilder.buildSql(columns, effectivePredicate);
            Optional<S3SelectLineRecordReader> recordReader = S3SelectLineRecordReaderProvider.get(configuration, this.clientConfig, path, fileSplit.getStart(), fileSplit.getLength(), fileSplit.getFileSize(), schema, ionSqlQuery, this.s3ClientFactory, s3SelectDataType);
            return recordReader.map(s3SelectLineRecordReader -> new S3SelectRecordCursor<LongWritable, Text>(configuration, path, (RecordReader<LongWritable, Text>)s3SelectLineRecordReader, fileSplit.getLength(), schema, columns, hiveStorageTimeZone, typeManager));
        }
        return Optional.empty();
    }

    private static boolean hasFilters(Properties schema, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> projectedColumns) {
        if (effectivePredicate.isAll()) {
            return !S3SelectRecordCursorProvider.areColumnsEquivalent(projectedColumns, schema);
        }
        return true;
    }

    private static boolean areColumnsEquivalent(List<HiveColumnHandle> projectedColumns, Properties schema) {
        ImmutableSet schemaColumnNames;
        Set projectedColumnNames = (Set)projectedColumns.stream().map(BaseHiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        String columnNameProperty = schema.getProperty("columns");
        if (columnNameProperty.length() == 0) {
            schemaColumnNames = ImmutableSet.of();
        } else {
            String columnNameDelimiter = (String)schema.getOrDefault((Object)"column.name.delimiter", ",");
            schemaColumnNames = ImmutableSet.copyOf((Object[])columnNameProperty.split(columnNameDelimiter));
        }
        return projectedColumnNames.equals(schemaColumnNames);
    }
}

