/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreUtil;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.RoleGrant;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class SqlStandardAccessControl
implements ConnectorAccessControl {
    public static final String ADMIN_ROLE_NAME = "admin";
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private static final SchemaTableName ROLES = new SchemaTableName("information_schema", "roles");
    private final String connectorId;
    private final HiveTransactionManager hiveTransactionManager;

    @Inject
    public SqlStandardAccessControl(HiveConnectorId connectorId, HiveTransactionManager hiveTransactionManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.hiveTransactionManager = Objects.requireNonNull(hiveTransactionManager, "hiveTransactionManager is null");
    }

    public void checkCanCreateSchema(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isAdmin(transaction, identity, metastoreContext)) {
            AccessDeniedException.denyCreateSchema((String)schemaName);
        }
    }

    public void checkCanDropSchema(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isDatabaseOwner(transaction, identity, metastoreContext, schemaName)) {
            AccessDeniedException.denyDropSchema((String)schemaName);
        }
    }

    public void checkCanRenameSchema(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, String schemaName, String newSchemaName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isDatabaseOwner(transaction, identity, metastoreContext, schemaName)) {
            AccessDeniedException.denyRenameSchema((String)schemaName, (String)newSchemaName);
        }
    }

    public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context) {
    }

    public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isDatabaseOwner(transaction, identity, metastoreContext, tableName.getSchemaName())) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
    }

    public void checkCanDropTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isTableOwner(transaction, identity, metastoreContext, tableName)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isTableOwner(transaction, identity, metastoreContext, tableName)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isTableOwner(transaction, identity, metastoreContext, tableName)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isTableOwner(transaction, identity, metastoreContext, tableName)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isTableOwner(transaction, identity, metastoreContext, tableName)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanSelectFromColumns(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<Subfield> columnOrSubfieldNames) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.checkTablePermission(transaction, identity, metastoreContext, tableName, HivePrivilegeInfo.HivePrivilege.SELECT, false)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.checkTablePermission(transaction, identity, metastoreContext, tableName, HivePrivilegeInfo.HivePrivilege.INSERT, false)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.checkTablePermission(transaction, identity, metastoreContext, tableName, HivePrivilegeInfo.HivePrivilege.DELETE, false)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
    }

    public void checkCanTruncateTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.checkTablePermission(transaction, identity, metastoreContext, tableName, HivePrivilegeInfo.HivePrivilege.DELETE, false)) {
            AccessDeniedException.denyTruncateTable((String)tableName.toString());
        }
    }

    public void checkCanUpdateTableColumns(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<String> updatedColumns) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.checkTablePermission(transaction, identity, metastoreContext, tableName, HivePrivilegeInfo.HivePrivilege.UPDATE, false)) {
            AccessDeniedException.denyUpdateTableColumns((String)tableName.toString(), updatedColumns);
        }
    }

    public void checkCanCreateView(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName viewName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isDatabaseOwner(transaction, identity, metastoreContext, viewName.getSchemaName())) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanDropView(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName viewName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isTableOwner(transaction, identity, metastoreContext, viewName)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<String> columnNames) {
        this.checkCanSelectFromColumns(transaction, identity, context, tableName, (Set)columnNames.stream().map(column -> new Subfield(column)).collect(ImmutableSet.toImmutableSet()));
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.checkTablePermission(transaction, identity, metastoreContext, tableName, HivePrivilegeInfo.HivePrivilege.SELECT, true)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (ConnectorIdentity)identity);
        }
    }

    public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, String propertyName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isAdmin(transaction, identity, metastoreContext)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)this.connectorId, (String)propertyName);
        }
    }

    public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (this.isTableOwner(transaction, identity, metastoreContext, tableName)) {
            return;
        }
        if (!this.hasGrantOptionForPrivilege(transaction, identity, metastoreContext, privilege, tableName)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (this.isTableOwner(transaction, identity, metastoreContext, tableName)) {
            return;
        }
        if (!this.hasGrantOptionForPrivilege(transaction, identity, metastoreContext, privilege, tableName)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanCreateRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String role, Optional<PrestoPrincipal> grantor) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support WITH ADMIN statement");
        }
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isAdmin(transactionHandle, identity, metastoreContext)) {
            AccessDeniedException.denyCreateRole((String)role);
        }
    }

    public void checkCanDropRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String role) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isAdmin(transactionHandle, identity, metastoreContext)) {
            AccessDeniedException.denyDropRole((String)role);
        }
    }

    public void checkCanGrantRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support GRANTED BY statement");
        }
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.hasAdminOptionForRoles(transactionHandle, identity, metastoreContext, roles)) {
            AccessDeniedException.denyGrantRoles(roles, grantees);
        }
    }

    public void checkCanRevokeRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support GRANTED BY statement");
        }
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.hasAdminOptionForRoles(transactionHandle, identity, metastoreContext, roles)) {
            AccessDeniedException.denyRevokeRoles(roles, grantees);
        }
    }

    public void checkCanSetRole(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, String role, String catalogName) {
        SemiTransactionalHiveMetastore metastore = this.getMetastore(transaction);
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!ThriftMetastoreUtil.isRoleApplicable((SemiTransactionalHiveMetastore)metastore, (ConnectorIdentity)identity, (PrestoPrincipal)new PrestoPrincipal(PrincipalType.USER, identity.getUser()), (MetastoreContext)metastoreContext, (String)role)) {
            AccessDeniedException.denySetRole((String)role);
        }
    }

    public void checkCanShowRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String catalogName) {
        MetastoreContext metastoreContext = new MetastoreContext(identity, context.getQueryId().getId(), context.getClientInfo(), context.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, context.getWarningCollector());
        if (!this.isAdmin(transactionHandle, identity, metastoreContext)) {
            AccessDeniedException.denyShowRoles((String)catalogName);
        }
    }

    public void checkCanShowCurrentRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String catalogName) {
    }

    public void checkCanShowRoleGrants(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String catalogName) {
    }

    private boolean isAdmin(ConnectorTransactionHandle transaction, ConnectorIdentity identity, MetastoreContext metastoreContext) {
        SemiTransactionalHiveMetastore metastore = this.getMetastore(transaction);
        return ThriftMetastoreUtil.isRoleEnabled((ConnectorIdentity)identity, p -> metastore.listRoleGrants(metastoreContext, p), (String)ADMIN_ROLE_NAME);
    }

    private boolean isDatabaseOwner(ConnectorTransactionHandle transaction, ConnectorIdentity identity, MetastoreContext metastoreContext, String databaseName) {
        if ("default".equalsIgnoreCase(databaseName)) {
            return true;
        }
        if (this.isAdmin(transaction, identity, metastoreContext)) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.getMetastore(transaction);
        Optional databaseMetadata = metastore.getDatabase(metastoreContext, databaseName);
        if (!databaseMetadata.isPresent()) {
            return false;
        }
        Database database = (Database)databaseMetadata.get();
        if (database.getOwnerType() == PrincipalType.USER && identity.getUser().equals(database.getOwnerName())) {
            return true;
        }
        return database.getOwnerType() == PrincipalType.ROLE && ThriftMetastoreUtil.isRoleEnabled((ConnectorIdentity)identity, p -> metastore.listRoleGrants(metastoreContext, p), (String)database.getOwnerName());
    }

    private boolean isTableOwner(ConnectorTransactionHandle transaction, ConnectorIdentity identity, MetastoreContext metastoreContext, SchemaTableName tableName) {
        return this.checkTablePermission(transaction, identity, metastoreContext, tableName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP, false);
    }

    private boolean checkTablePermission(ConnectorTransactionHandle transaction, ConnectorIdentity identity, MetastoreContext metastoreContext, SchemaTableName tableName, HivePrivilegeInfo.HivePrivilege requiredPrivilege, boolean grantOptionRequired) {
        if (this.isAdmin(transaction, identity, metastoreContext)) {
            return true;
        }
        if (tableName.equals((Object)ROLES)) {
            return false;
        }
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.getMetastore(transaction);
        return ThriftMetastoreUtil.listEnabledTablePrivileges((SemiTransactionalHiveMetastore)metastore, (String)tableName.getSchemaName(), (String)tableName.getTableName(), (ConnectorIdentity)identity, (MetastoreContext)metastoreContext).filter(privilegeInfo -> !grantOptionRequired || privilegeInfo.isGrantOption()).anyMatch(privilegeInfo -> privilegeInfo.getHivePrivilege().equals((Object)requiredPrivilege));
    }

    private boolean hasGrantOptionForPrivilege(ConnectorTransactionHandle transaction, ConnectorIdentity identity, MetastoreContext metastoreContext, Privilege privilege, SchemaTableName tableName) {
        if (this.isAdmin(transaction, identity, metastoreContext)) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.getMetastore(transaction);
        return ThriftMetastoreUtil.listApplicableTablePrivileges((SemiTransactionalHiveMetastore)metastore, (ConnectorIdentity)identity, (MetastoreContext)metastoreContext, (String)tableName.getSchemaName(), (String)tableName.getTableName(), (String)identity.getUser()).anyMatch(privilegeInfo -> privilegeInfo.getHivePrivilege().equals((Object)HivePrivilegeInfo.toHivePrivilege((Privilege)privilege)) && privilegeInfo.isGrantOption());
    }

    private boolean hasAdminOptionForRoles(ConnectorTransactionHandle transaction, ConnectorIdentity identity, MetastoreContext metastoreContext, Set<String> roles) {
        if (this.isAdmin(transaction, identity, metastoreContext)) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.getMetastore(transaction);
        Set rolesWithGrantOption = ThriftMetastoreUtil.listApplicableRoles((PrestoPrincipal)new PrestoPrincipal(PrincipalType.USER, identity.getUser()), p -> metastore.listRoleGrants(metastoreContext, p)).filter(RoleGrant::isGrantable).map(RoleGrant::getRoleName).collect(Collectors.toSet());
        return rolesWithGrantOption.containsAll(roles);
    }

    private SemiTransactionalHiveMetastore getMetastore(ConnectorTransactionHandle transaction) {
        TransactionalMetadata metadata = this.hiveTransactionManager.get(transaction);
        return metadata.getMetastore();
    }
}

