/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security.ranger;

import com.facebook.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class RangerBasedAccessControlConfig {
    public static final String RANGER_POLICY_REFRESH_PERIOD = "hive.ranger.refresh-policy-period";
    public static final String RANGER_HTTP_END_POINT = "hive.ranger.rest-endpoint";
    public static final String RANGER_REST_POLICY_HIVE_SERVICE_NAME = "hive.ranger.policy.hive-servicename";
    public static final String RANGER_REST_USER_GROUPS_AUTH_USERNAME = "hive.ranger.service.basic-auth-username";
    public static final String RANGER_REST_USER_GROUPS_AUTH_PASSWORD = "hive.ranger.service.basic-auth-password";
    public static final String RANGER_HIVE_AUDIT_PATH = "hive.ranger.audit.path";
    public static final String RANGER_REST_POLICY_MGR_DOWNLOAD_URL = "/service/plugins/policies/download";
    public static final String RANGER_REST_USER_GROUP_URL = "/service/xusers/users";
    public static final String RANGER_REST_USER_ROLES_URL = "/service/roles/roles/user";
    private String rangerHttpEndPoint;
    private String rangerHiveServiceName;
    private Duration refreshPeriod = new Duration(60.0, TimeUnit.SECONDS);
    private String basicAuthUser;
    private String basicAuthPassword;
    private String rangerHiveAuditPath;

    @MinDuration(value="60s")
    public Duration getRefreshPeriod() {
        return this.refreshPeriod;
    }

    @Config(value="hive.ranger.refresh-policy-period")
    public RangerBasedAccessControlConfig setRefreshPeriod(Duration refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
        return this;
    }

    @NotNull
    public String getRangerHiveServiceName() {
        return this.rangerHiveServiceName;
    }

    @Config(value="hive.ranger.policy.hive-servicename")
    public RangerBasedAccessControlConfig setRangerHiveServiceName(String rangerHiveServiceName) {
        this.rangerHiveServiceName = rangerHiveServiceName;
        return this;
    }

    @NotNull
    public String getRangerHttpEndPoint() {
        return this.rangerHttpEndPoint;
    }

    @Config(value="hive.ranger.rest-endpoint")
    public RangerBasedAccessControlConfig setRangerHttpEndPoint(String rangerHttpEndPoint) {
        this.rangerHttpEndPoint = rangerHttpEndPoint;
        return this;
    }

    public String getBasicAuthUser() {
        return this.basicAuthUser;
    }

    @Config(value="hive.ranger.service.basic-auth-username")
    public RangerBasedAccessControlConfig setBasicAuthUser(String basicAuthUser) {
        this.basicAuthUser = basicAuthUser;
        return this;
    }

    public String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    @Config(value="hive.ranger.service.basic-auth-password")
    public RangerBasedAccessControlConfig setBasicAuthPassword(String basicAuthPassword) {
        this.basicAuthPassword = basicAuthPassword;
        return this;
    }

    public String getRangerHiveAuditPath() {
        return this.rangerHiveAuditPath;
    }

    @Config(value="hive.ranger.audit.path")
    public RangerBasedAccessControlConfig setRangerHiveAuditPath(String rangerHiveAuditPath) {
        this.rangerHiveAuditPath = rangerHiveAuditPath;
        return this;
    }
}

