/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security.ranger;

import com.facebook.airlift.http.client.BasicAuthRequestFilter;
import com.facebook.airlift.http.client.HttpRequestFilter;
import com.facebook.airlift.http.client.Request;
import com.facebook.presto.hive.security.ranger.RangerBasedAccessControlConfig;
import java.util.Objects;
import javax.inject.Inject;

public class RangerBasicAuthHttpRequestFilter
implements HttpRequestFilter {
    private final BasicAuthRequestFilter filter;

    @Inject
    public RangerBasicAuthHttpRequestFilter(RangerBasedAccessControlConfig config) {
        String username = Objects.requireNonNull(config.getBasicAuthUser(), "username cannot be null when using basic authentication");
        String password = Objects.requireNonNull(config.getBasicAuthPassword(), "password cannot be null when using basic authentication");
        this.filter = new BasicAuthRequestFilter(username, password);
    }

    public Request filterRequest(Request request) {
        return this.filter.filterRequest(request);
    }
}

