/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;

public interface ResumableTask {
    public ResumableTaskStatus process();

    public static class ResumableTaskStatus {
        private final boolean finished;
        private final ListenableFuture<?> continuationFuture;

        private ResumableTaskStatus(boolean finished, ListenableFuture<?> continuationFuture) {
            this.finished = finished;
            this.continuationFuture = continuationFuture;
        }

        public static ResumableTaskStatus finished() {
            return new ResumableTaskStatus(true, Futures.immediateFuture(null));
        }

        public static ResumableTaskStatus continueOn(ListenableFuture<?> continuationFuture) {
            return new ResumableTaskStatus(false, continuationFuture);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public ListenableFuture<?> getContinuationFuture() {
            return this.continuationFuture;
        }
    }
}

