/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;

public class HiveCoercionRecordCursor
implements RecordCursor {
    private final RecordCursor delegate;
    private final List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Coercer[] coercers;
    private final BridgingRecordCursor bridgingRecordCursor;

    public HiveCoercionRecordCursor(List<HivePageSourceProvider.ColumnMapping> columnMappings, TypeManager typeManager, RecordCursor delegate) {
        Objects.requireNonNull(columnMappings, "columns is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.bridgingRecordCursor = new BridgingRecordCursor();
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = ImmutableList.copyOf(columnMappings);
        int size = columnMappings.size();
        this.coercers = new Coercer[size];
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            if (!columnMapping.getCoercionFrom().isPresent()) continue;
            this.coercers[columnIndex] = HiveCoercionRecordCursor.createCoercer(typeManager, columnMapping.getCoercionFrom().get(), columnMapping.getHiveColumnHandle().getHiveType(), this.bridgingRecordCursor);
        }
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public Type getType(int field) {
        return this.delegate.getType(field);
    }

    public boolean advanceNextPosition() {
        for (int i = 0; i < this.columnMappings.size(); ++i) {
            if (this.coercers[i] == null) continue;
            this.coercers[i].reset();
        }
        return this.delegate.advanceNextPosition();
    }

    public boolean getBoolean(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.getBoolean(field);
        }
        return this.coercers[field].getBoolean(this.delegate, field);
    }

    public long getLong(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.getLong(field);
        }
        return this.coercers[field].getLong(this.delegate, field);
    }

    public double getDouble(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.getDouble(field);
        }
        return this.coercers[field].getDouble(this.delegate, field);
    }

    public Slice getSlice(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.getSlice(field);
        }
        return this.coercers[field].getSlice(this.delegate, field);
    }

    public Object getObject(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.getObject(field);
        }
        return this.coercers[field].getObject(this.delegate, field);
    }

    public boolean isNull(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.isNull(field);
        }
        return this.coercers[field].isNull(this.delegate, field);
    }

    public void close() {
        this.delegate.close();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    @VisibleForTesting
    RecordCursor getRegularColumnRecordCursor() {
        return this.delegate;
    }

    private static Coercer createCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType, BridgingRecordCursor bridgingRecordCursor) {
        Type fromType = typeManager.getType(fromHiveType.getTypeSignature());
        Type toType = typeManager.getType(toHiveType.getTypeSignature());
        if (toType instanceof VarcharType && (fromHiveType.equals((Object)HiveType.HIVE_BYTE) || fromHiveType.equals((Object)HiveType.HIVE_SHORT) || fromHiveType.equals((Object)HiveType.HIVE_INT) || fromHiveType.equals((Object)HiveType.HIVE_LONG))) {
            return new IntegerNumberToVarcharCoercer();
        }
        if (fromType instanceof VarcharType && (toHiveType.equals((Object)HiveType.HIVE_BYTE) || toHiveType.equals((Object)HiveType.HIVE_SHORT) || toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG))) {
            return new VarcharToIntegerNumberCoercer(toHiveType);
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_BYTE) && toHiveType.equals((Object)HiveType.HIVE_SHORT) || toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer();
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_SHORT) && toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer();
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_INT) && toHiveType.equals((Object)HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer();
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_FLOAT) && toHiveType.equals((Object)HiveType.HIVE_DOUBLE)) {
            return new FloatToDoubleCoercer();
        }
        if (MetastoreUtil.isArrayType((Type)fromType) && MetastoreUtil.isArrayType((Type)toType)) {
            return new ListCoercer(typeManager, fromHiveType, toHiveType, bridgingRecordCursor);
        }
        if (MetastoreUtil.isMapType((Type)fromType) && MetastoreUtil.isMapType((Type)toType)) {
            return new MapCoercer(typeManager, fromHiveType, toHiveType, bridgingRecordCursor);
        }
        if (MetastoreUtil.isRowType((Type)fromType) && MetastoreUtil.isRowType((Type)toType)) {
            return new StructCoercer(typeManager, fromHiveType, toHiveType, bridgingRecordCursor);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported coercion from %s to %s", fromHiveType, toHiveType));
    }

    private static void rewriteBlock(Type fromType, Type toType, Block block, int position, BlockBuilder blockBuilder, Coercer coercer, BridgingRecordCursor bridgingRecordCursor) {
        Class fromJavaType = fromType.getJavaType();
        if (fromJavaType == Long.TYPE) {
            bridgingRecordCursor.setValue(fromType.getLong(block, position));
        } else if (fromJavaType == Double.TYPE) {
            bridgingRecordCursor.setValue(fromType.getDouble(block, position));
        } else if (fromJavaType == Boolean.TYPE) {
            bridgingRecordCursor.setValue(fromType.getBoolean(block, position));
        } else if (fromJavaType == Slice.class) {
            bridgingRecordCursor.setValue(fromType.getSlice(block, position));
        } else if (fromJavaType == Block.class) {
            bridgingRecordCursor.setValue(fromType.getObject(block, position));
        } else {
            bridgingRecordCursor.setValue(null);
        }
        coercer.reset();
        Class toJaveType = toType.getJavaType();
        if (coercer.isNull(bridgingRecordCursor, 0)) {
            blockBuilder.appendNull();
        } else if (toJaveType == Long.TYPE) {
            toType.writeLong(blockBuilder, coercer.getLong(bridgingRecordCursor, 0));
        } else if (toJaveType == Double.TYPE) {
            toType.writeDouble(blockBuilder, coercer.getDouble(bridgingRecordCursor, 0));
        } else if (toJaveType == Boolean.TYPE) {
            toType.writeBoolean(blockBuilder, coercer.getBoolean(bridgingRecordCursor, 0));
        } else if (toJaveType == Slice.class) {
            toType.writeSlice(blockBuilder, coercer.getSlice(bridgingRecordCursor, 0));
        } else if (toJaveType == Block.class) {
            toType.writeObject(blockBuilder, coercer.getObject(bridgingRecordCursor, 0));
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported coercion from %s to %s", fromType.getDisplayName(), toType.getDisplayName()));
        }
        coercer.reset();
        bridgingRecordCursor.close();
    }

    private static class BridgingRecordCursor
    implements RecordCursor {
        private Object value;

        private BridgingRecordCursor() {
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            throw new UnsupportedOperationException();
        }

        public boolean advanceNextPosition() {
            return true;
        }

        public boolean getBoolean(int field) {
            return (Boolean)this.value;
        }

        public long getLong(int field) {
            return (Long)this.value;
        }

        public double getDouble(int field) {
            return (Double)this.value;
        }

        public Slice getSlice(int field) {
            return (Slice)this.value;
        }

        public Object getObject(int field) {
            return this.value;
        }

        public boolean isNull(int field) {
            return this.value == null;
        }

        public void close() {
            this.value = null;
        }
    }

    private static class StructCoercer
    extends Coercer {
        private final Type toType;
        private final List<Type> fromFieldTypes;
        private final List<Type> toFieldTypes;
        private final Coercer[] coercers;
        private final BridgingRecordCursor bridgingRecordCursor;
        private final PageBuilder pageBuilder;

        public StructCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType, BridgingRecordCursor bridgingRecordCursor) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            this.bridgingRecordCursor = Objects.requireNonNull(bridgingRecordCursor, "bridgingRecordCursor is null");
            List<HiveType> fromFieldHiveTypes = HiveUtil.extractStructFieldTypes(fromHiveType);
            List<HiveType> toFieldHiveTypes = HiveUtil.extractStructFieldTypes(toHiveType);
            this.fromFieldTypes = fromHiveType.getType(typeManager).getTypeParameters();
            this.toType = toHiveType.getType(typeManager);
            this.toFieldTypes = this.toType.getTypeParameters();
            this.coercers = new Coercer[toFieldHiveTypes.size()];
            for (int i = 0; i < Math.min(fromFieldHiveTypes.size(), toFieldHiveTypes.size()); ++i) {
                if (this.fromFieldTypes.get(i).equals(this.toFieldTypes.get(i))) continue;
                this.coercers[i] = HiveCoercionRecordCursor.createCoercer(typeManager, fromFieldHiveTypes.get(i), toFieldHiveTypes.get(i), bridgingRecordCursor);
            }
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)this.toType));
        }

        @Override
        public void coerce(RecordCursor delegate, int field) {
            if (delegate.isNull(field)) {
                this.setIsNull(true);
                return;
            }
            Block block = (Block)delegate.getObject(field);
            if (this.pageBuilder.isFull()) {
                this.pageBuilder.reset();
            }
            BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
            BlockBuilder rowBuilder = blockBuilder.beginBlockEntry();
            for (int i = 0; i < this.toFieldTypes.size(); ++i) {
                if (i >= this.fromFieldTypes.size() || block.isNull(i)) {
                    rowBuilder.appendNull();
                    continue;
                }
                if (this.coercers[i] == null) {
                    this.toFieldTypes.get(i).appendTo(block, i, rowBuilder);
                    continue;
                }
                HiveCoercionRecordCursor.rewriteBlock(this.fromFieldTypes.get(i), this.toFieldTypes.get(i), block, i, rowBuilder, this.coercers[i], this.bridgingRecordCursor);
            }
            blockBuilder.closeEntry();
            this.pageBuilder.declarePosition();
            this.setObject(this.toType.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1));
        }
    }

    private static class MapCoercer
    extends Coercer {
        private final List<Type> fromKeyValueTypes;
        private final Type toType;
        private final List<Type> toKeyValueTypes;
        private final Coercer[] coercers;
        private final BridgingRecordCursor bridgingRecordCursor;
        private final PageBuilder pageBuilder;

        public MapCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType, BridgingRecordCursor bridgingRecordCursor) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            this.bridgingRecordCursor = Objects.requireNonNull(bridgingRecordCursor, "bridgingRecordCursor is null");
            HiveType fromKeyHiveType = HiveType.valueOf((String)((MapTypeInfo)fromHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType fromValueHiveType = HiveType.valueOf((String)((MapTypeInfo)fromHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            HiveType toKeyHiveType = HiveType.valueOf((String)((MapTypeInfo)toHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType toValueHiveType = HiveType.valueOf((String)((MapTypeInfo)toHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            this.fromKeyValueTypes = fromHiveType.getType(typeManager).getTypeParameters();
            this.toType = toHiveType.getType(typeManager);
            this.toKeyValueTypes = this.toType.getTypeParameters();
            this.coercers = new Coercer[2];
            this.coercers[0] = fromKeyHiveType.equals((Object)toKeyHiveType) ? null : HiveCoercionRecordCursor.createCoercer(typeManager, fromKeyHiveType, toKeyHiveType, bridgingRecordCursor);
            this.coercers[1] = fromValueHiveType.equals((Object)toValueHiveType) ? null : HiveCoercionRecordCursor.createCoercer(typeManager, fromValueHiveType, toValueHiveType, bridgingRecordCursor);
            this.pageBuilder = this.coercers[0] == null && this.coercers[1] == null ? null : new PageBuilder((List)ImmutableList.of((Object)this.toType));
        }

        @Override
        public void coerce(RecordCursor delegate, int field) {
            if (delegate.isNull(field)) {
                this.setIsNull(true);
                return;
            }
            Block block = (Block)delegate.getObject(field);
            if (this.pageBuilder.isFull()) {
                this.pageBuilder.reset();
            }
            BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
            BlockBuilder mapBuilder = blockBuilder.beginBlockEntry();
            for (int i = 0; i < block.getPositionCount(); ++i) {
                int k = i % 2;
                if (this.coercers[k] == null) {
                    this.toKeyValueTypes.get(k).appendTo(block, i, mapBuilder);
                    continue;
                }
                if (block.isNull(i)) {
                    mapBuilder.appendNull();
                    continue;
                }
                HiveCoercionRecordCursor.rewriteBlock(this.fromKeyValueTypes.get(k), this.toKeyValueTypes.get(k), block, i, mapBuilder, this.coercers[k], this.bridgingRecordCursor);
            }
            blockBuilder.closeEntry();
            this.pageBuilder.declarePosition();
            this.setObject(this.toType.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1));
        }
    }

    private static class ListCoercer
    extends Coercer {
        private final Type fromElementType;
        private final Type toType;
        private final Type toElementType;
        private final Coercer elementCoercer;
        private final BridgingRecordCursor bridgingRecordCursor;
        private final PageBuilder pageBuilder;

        public ListCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType, BridgingRecordCursor bridgingRecordCursor) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            this.bridgingRecordCursor = Objects.requireNonNull(bridgingRecordCursor, "bridgingRecordCursor is null");
            HiveType fromElementHiveType = HiveType.valueOf((String)((ListTypeInfo)fromHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            HiveType toElementHiveType = HiveType.valueOf((String)((ListTypeInfo)toHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            this.fromElementType = fromElementHiveType.getType(typeManager);
            this.toType = toHiveType.getType(typeManager);
            this.toElementType = toElementHiveType.getType(typeManager);
            this.elementCoercer = fromElementHiveType.equals((Object)toElementHiveType) ? null : HiveCoercionRecordCursor.createCoercer(typeManager, fromElementHiveType, toElementHiveType, bridgingRecordCursor);
            this.pageBuilder = this.elementCoercer == null ? null : new PageBuilder((List)ImmutableList.of((Object)this.toType));
        }

        @Override
        public void coerce(RecordCursor delegate, int field) {
            if (delegate.isNull(field)) {
                this.setIsNull(true);
                return;
            }
            Block block = (Block)delegate.getObject(field);
            if (this.pageBuilder.isFull()) {
                this.pageBuilder.reset();
            }
            BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
            BlockBuilder listBuilder = blockBuilder.beginBlockEntry();
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (this.elementCoercer == null) {
                    this.toElementType.appendTo(block, i, listBuilder);
                    continue;
                }
                if (block.isNull(i)) {
                    listBuilder.appendNull();
                    continue;
                }
                HiveCoercionRecordCursor.rewriteBlock(this.fromElementType, this.toElementType, block, i, listBuilder, this.elementCoercer, this.bridgingRecordCursor);
            }
            blockBuilder.closeEntry();
            this.pageBuilder.declarePosition();
            this.setObject(this.toType.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1));
        }
    }

    private static class VarcharToIntegerNumberCoercer
    extends Coercer {
        private final long maxValue;
        private final long minValue;

        public VarcharToIntegerNumberCoercer(HiveType type) {
            if (type.equals((Object)HiveType.HIVE_BYTE)) {
                this.minValue = -128L;
                this.maxValue = 127L;
            } else if (type.equals((Object)HiveType.HIVE_SHORT)) {
                this.minValue = -32768L;
                this.maxValue = 32767L;
            } else if (type.equals((Object)HiveType.HIVE_INT)) {
                this.minValue = Integer.MIN_VALUE;
                this.maxValue = Integer.MAX_VALUE;
            } else if (type.equals((Object)HiveType.HIVE_LONG)) {
                this.minValue = Long.MIN_VALUE;
                this.maxValue = Long.MAX_VALUE;
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not create Coercer from varchar to %s", type));
            }
        }

        @Override
        public void coerce(RecordCursor delegate, int field) {
            try {
                long value = Long.parseLong(delegate.getSlice(field).toStringUtf8());
                if (this.minValue <= value && value <= this.maxValue) {
                    this.setLong(value);
                } else {
                    this.setIsNull(true);
                }
            }
            catch (NumberFormatException e) {
                this.setIsNull(true);
            }
        }
    }

    private static class FloatToDoubleCoercer
    extends Coercer {
        private FloatToDoubleCoercer() {
        }

        @Override
        protected void coerce(RecordCursor delegate, int field) {
            this.setDouble(Float.intBitsToFloat((int)delegate.getLong(field)));
        }
    }

    private static class IntegerNumberToVarcharCoercer
    extends Coercer {
        private IntegerNumberToVarcharCoercer() {
        }

        @Override
        public void coerce(RecordCursor delegate, int field) {
            this.setSlice(Slices.utf8Slice((String)String.valueOf(delegate.getLong(field))));
        }
    }

    private static class IntegerNumberUpscaleCoercer
    extends Coercer {
        private IntegerNumberUpscaleCoercer() {
        }

        @Override
        public void coerce(RecordCursor delegate, int field) {
            this.setLong(delegate.getLong(field));
        }
    }

    private static abstract class Coercer {
        private boolean isNull;
        private boolean loaded;
        private boolean booleanValue;
        private long longValue;
        private double doubleValue;
        private Slice sliceValue;
        private Object objectValue;

        private Coercer() {
        }

        public void reset() {
            this.isNull = false;
            this.loaded = false;
        }

        public boolean isNull(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.isNull;
        }

        public boolean getBoolean(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.booleanValue;
        }

        public long getLong(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.longValue;
        }

        public double getDouble(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.doubleValue;
        }

        public Slice getSlice(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.sliceValue;
        }

        public Object getObject(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.objectValue;
        }

        private void assureLoaded(RecordCursor delegate, int field) {
            if (!this.loaded) {
                this.isNull = delegate.isNull(field);
                if (!this.isNull) {
                    this.coerce(delegate, field);
                }
                this.loaded = true;
            }
        }

        protected abstract void coerce(RecordCursor var1, int var2);

        protected void setBoolean(boolean value) {
            this.booleanValue = value;
        }

        protected void setLong(long value) {
            this.longValue = value;
        }

        protected void setDouble(double value) {
            this.doubleValue = value;
        }

        protected void setSlice(Slice value) {
            this.sliceValue = value;
        }

        protected void setObject(Object value) {
            this.objectValue = value;
        }

        protected void setIsNull(boolean isNull) {
            this.isNull = isNull;
        }
    }
}

