/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.connector.ConnectorCommitHandle;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorMetadataUpdaterProvider;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.ConnectorTypeSerdeProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorMetadata;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class HiveConnector
implements Connector {
    private static final Logger log = Logger.get(HiveConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final Supplier<TransactionalMetadata> metadataFactory;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final ConnectorPageSinkProvider pageSinkProvider;
    private final ConnectorNodePartitioningProvider nodePartitioningProvider;
    private final Set<SystemTable> systemTables;
    private final Set<Procedure> procedures;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> schemaProperties;
    private final List<PropertyMetadata<?>> tableProperties;
    private final List<PropertyMetadata<?>> analyzeProperties;
    private final ConnectorAccessControl accessControl;
    private final ClassLoader classLoader;
    private final ConnectorPlanOptimizerProvider planOptimizerProvider;
    private final ConnectorMetadataUpdaterProvider metadataUpdaterProvider;
    private final ConnectorTypeSerdeProvider connectorTypeSerdeProvider;
    private final HiveTransactionManager transactionManager;

    public HiveConnector(LifeCycleManager lifeCycleManager, Supplier<TransactionalMetadata> metadataFactory, HiveTransactionManager transactionManager, ConnectorSplitManager splitManager, ConnectorPageSourceProvider pageSourceProvider, ConnectorPageSinkProvider pageSinkProvider, ConnectorNodePartitioningProvider nodePartitioningProvider, Set<SystemTable> systemTables, Set<Procedure> procedures, List<PropertyMetadata<?>> sessionProperties, List<PropertyMetadata<?>> schemaProperties, List<PropertyMetadata<?>> tableProperties, List<PropertyMetadata<?>> analyzeProperties, ConnectorAccessControl accessControl, ConnectorPlanOptimizerProvider planOptimizerProvider, ConnectorMetadataUpdaterProvider metadataUpdaterProvider, ConnectorTypeSerdeProvider connectorTypeSerdeProvider, ClassLoader classLoader) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadata is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.systemTables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(systemTables, "systemTables is null"));
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
        this.sessionProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(sessionProperties, "sessionProperties is null"));
        this.schemaProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(schemaProperties, "schemaProperties is null"));
        this.tableProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableProperties, "tableProperties is null"));
        this.analyzeProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(analyzeProperties, "analyzeProperties is null"));
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        this.planOptimizerProvider = Objects.requireNonNull(planOptimizerProvider, "planOptimizerProvider is null");
        this.metadataUpdaterProvider = Objects.requireNonNull(metadataUpdaterProvider, "metadataUpdaterProvider is null");
        this.connectorTypeSerdeProvider = Objects.requireNonNull(connectorTypeSerdeProvider, "connectorTypeSerdeProvider is null");
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        TransactionalMetadata metadata = this.transactionManager.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)metadata, this.classLoader);
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public ConnectorPlanOptimizerProvider getConnectorPlanOptimizerProvider() {
        return this.planOptimizerProvider;
    }

    public ConnectorMetadataUpdaterProvider getConnectorMetadataUpdaterProvider() {
        return this.metadataUpdaterProvider;
    }

    public ConnectorTypeSerdeProvider getConnectorTypeSerdeProvider() {
        return this.connectorTypeSerdeProvider;
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.schemaProperties;
    }

    public List<PropertyMetadata<?>> getAnalyzeProperties() {
        return this.analyzeProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl;
    }

    public boolean isSingleStatementWritesOnly() {
        return false;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (IsolationLevel)isolationLevel);
        HiveTransactionHandle transaction = new HiveTransactionHandle();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.transactionManager.put(transaction, this.metadataFactory.get());
        }
        return transaction;
    }

    public ConnectorCommitHandle commit(ConnectorTransactionHandle transaction) {
        TransactionalMetadata metadata = this.transactionManager.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorCommitHandle connectorCommitHandle = metadata.commit();
            return connectorCommitHandle;
        }
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        TransactionalMetadata metadata = this.transactionManager.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            metadata.rollback();
        }
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }

    public Set<ConnectorCapabilities> getCapabilities() {
        return ImmutableSet.of((Object)ConnectorCapabilities.SUPPORTS_REWINDABLE_SPLIT_SOURCE, (Object)ConnectorCapabilities.SUPPORTS_PAGE_SINK_COMMIT, (Object)ConnectorCapabilities.PRIMARY_KEY_CONSTRAINT, (Object)ConnectorCapabilities.UNIQUE_CONSTRAINT);
    }
}

