/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HiveFileSplit {
    private final String path;
    private final long start;
    private final long length;
    private final long fileSize;
    private final long fileModifiedTime;
    private final Optional<byte[]> extraFileInfo;
    private final Map<String, String> customSplitInfo;

    @JsonCreator
    public HiveFileSplit(@JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="fileSize") long fileSize, @JsonProperty(value="fileModifiedTime") long fileModifiedTime, @JsonProperty(value="extraFileInfo") Optional<byte[]> extraFileInfo, @JsonProperty(value="customSplitInfo") Map<String, String> customSplitInfo) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be non-negative");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length must be non-negative");
        Preconditions.checkArgument((fileSize >= 0L ? 1 : 0) != 0, (Object)"fileSize must be non-negative");
        Preconditions.checkArgument((fileModifiedTime >= 0L ? 1 : 0) != 0, (Object)"modificationTime must be non-negative");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(extraFileInfo, "extraFileInfo is null");
        Objects.requireNonNull(customSplitInfo, "customSplitInfo is null");
        this.path = path;
        this.start = start;
        this.length = length;
        this.fileSize = fileSize;
        this.fileModifiedTime = fileModifiedTime;
        this.extraFileInfo = extraFileInfo;
        this.customSplitInfo = ImmutableMap.copyOf(customSplitInfo);
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty
    public long getFileModifiedTime() {
        return this.fileModifiedTime;
    }

    @JsonProperty
    public Optional<byte[]> getExtraFileInfo() {
        return this.extraFileInfo;
    }

    @JsonProperty
    public Map<String, String> getCustomSplitInfo() {
        return this.customSplitInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveFileSplit fileSplit = (HiveFileSplit)o;
        return this.start == fileSplit.start && this.length == fileSplit.length && this.fileSize == fileSplit.fileSize && this.fileModifiedTime == fileSplit.fileModifiedTime && Objects.equals(this.path, fileSplit.path) && Objects.equals(this.extraFileInfo, fileSplit.extraFileInfo) && Objects.equals(this.customSplitInfo, fileSplit.customSplitInfo);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.start, this.length, this.fileSize, this.fileModifiedTime, this.extraFileInfo, this.customSplitInfo);
    }

    public String toString() {
        return "HiveFileSplit{path='" + this.path + '\'' + ", start=" + this.start + ", length=" + this.length + ", fileSize=" + this.fileSize + ", fileModifiedTime=" + this.fileModifiedTime + ", extraFileInfo=" + this.extraFileInfo + ", customSplitInfo=" + this.customSplitInfo + '}';
    }
}

