/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.http.client.thrift.ThriftProtocolException;
import com.facebook.airlift.http.client.thrift.ThriftProtocolUtils;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.presto.spi.ConnectorMetadataUpdateHandle;
import com.facebook.presto.spi.ConnectorTypeSerde;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slices;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class HiveMetadataUpdateHandleThriftSerde
implements ConnectorTypeSerde<ConnectorMetadataUpdateHandle> {
    private final ThriftCodecManager thriftCodecManager;
    private final Protocol thriftProtocol;
    private final int bufferSize;

    public HiveMetadataUpdateHandleThriftSerde(ThriftCodecManager thriftCodecManager, Protocol thriftProtocol, int bufferSize) {
        this.thriftCodecManager = Objects.requireNonNull(thriftCodecManager, "thriftCodecManager is null");
        this.thriftProtocol = Objects.requireNonNull(thriftProtocol, "thriftProtocol is null");
        this.bufferSize = bufferSize;
    }

    public byte[] serialize(ConnectorMetadataUpdateHandle value) {
        ThriftCodec codec = this.thriftCodecManager.getCodec(value.getClass());
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(this.bufferSize);
        try {
            ThriftProtocolUtils.write((Object)value, (ThriftCodec)codec, (Protocol)this.thriftProtocol, (OutputStream)dynamicSliceOutput);
            return dynamicSliceOutput.slice().getBytes();
        }
        catch (ThriftProtocolException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to Thrift", value.getClass().getName()), e);
        }
    }

    public ConnectorMetadataUpdateHandle deserialize(Class<? extends ConnectorMetadataUpdateHandle> connectorTypeClass, byte[] bytes) {
        try {
            ThriftCodec codec = this.thriftCodecManager.getCodec(connectorTypeClass);
            return (ConnectorMetadataUpdateHandle)ThriftProtocolUtils.read((ThriftCodec)codec, (Protocol)this.thriftProtocol, (InputStream)Slices.wrappedBuffer((byte[])bytes).getInput());
        }
        catch (ThriftProtocolException e) {
            throw new IllegalArgumentException(String.format("Invalid Thrift bytes for %s", connectorTypeClass), e);
        }
    }
}

