/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.BinaryExtraHiveFileInfo;
import com.facebook.presto.hive.BucketAdaptation;
import com.facebook.presto.hive.CacheQuota;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FilteringPageSource;
import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveAggregatedPageSourceFactory;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveBucketAdapterRecordCursor;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCoercer;
import com.facebook.presto.hive.HiveCoercionRecordCursor;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveEmptySplitPageSource;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HivePageSource;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSelectivePageSourceFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;

public class HivePageSourceProvider
implements ConnectorPageSourceProvider {
    private final DateTimeZone hiveStorageTimeZone;
    private final HdfsEnvironment hdfsEnvironment;
    private final Set<HiveRecordCursorProvider> cursorProviders;
    private final Set<HiveBatchPageSourceFactory> pageSourceFactories;
    private final Set<HiveSelectivePageSourceFactory> selectivePageSourceFactories;
    private final Set<HiveAggregatedPageSourceFactory> aggregatedPageSourceFactories;
    private final TypeManager typeManager;
    private final RowExpressionService rowExpressionService;
    private final LoadingCache<RowExpressionCacheKey, RowExpression> optimizedRowExpressionCache;

    @Inject
    public HivePageSourceProvider(HiveClientConfig hiveClientConfig, HdfsEnvironment hdfsEnvironment, Set<HiveRecordCursorProvider> cursorProviders, Set<HiveBatchPageSourceFactory> pageSourceFactories, Set<HiveSelectivePageSourceFactory> selectivePageSourceFactories, Set<HiveAggregatedPageSourceFactory> aggregatedPageSourceFactories, TypeManager typeManager, RowExpressionService rowExpressionService) {
        Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null");
        this.hiveStorageTimeZone = hiveClientConfig.getDateTimeZone();
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.cursorProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(cursorProviders, "cursorProviders is null"));
        this.pageSourceFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(pageSourceFactories, "pageSourceFactories is null"));
        this.selectivePageSourceFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(selectivePageSourceFactories, "selectivePageSourceFactories is null"));
        this.aggregatedPageSourceFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(aggregatedPageSourceFactories, "aggregatedPageSourceFactories is null"));
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.optimizedRowExpressionCache = CacheBuilder.newBuilder().recordStats().maximumSize(10000L).build(CacheLoader.from(cacheKey -> rowExpressionService.getExpressionOptimizer().optimize(((RowExpressionCacheKey)cacheKey).rowExpression, ExpressionOptimizer.Level.OPTIMIZED, ((RowExpressionCacheKey)cacheKey).session)));
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableLayoutHandle layout, List<ColumnHandle> columns, SplitContext splitContext) {
        Optional<ConnectorPageSource> selectivePageSource;
        HiveTableLayoutHandle hiveLayout = (HiveTableLayoutHandle)layout;
        List<HiveColumnHandle> selectedColumns = columns.stream().map(HiveColumnHandle.class::cast).collect(Collectors.toList());
        HiveSplit hiveSplit = (HiveSplit)split;
        Path path = new Path(hiveSplit.getFileSplit().getPath());
        Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsContext(session, hiveSplit.getDatabase(), hiveSplit.getTable(), hiveLayout.getTablePath(), false), path);
        Optional<EncryptionInformation> encryptionInformation = hiveSplit.getEncryptionInformation();
        CacheQuota cacheQuota = HivePageSourceProvider.generateCacheQuota(hiveSplit);
        HiveFileContext fileContext = new HiveFileContext(splitContext.isCacheable(), cacheQuota, hiveSplit.getFileSplit().getExtraFileInfo().map(BinaryExtraHiveFileInfo::new), OptionalLong.of(hiveSplit.getFileSplit().getFileSize()), OptionalLong.of(hiveSplit.getFileSplit().getStart()), OptionalLong.of(hiveSplit.getFileSplit().getLength()), hiveSplit.getFileSplit().getFileModifiedTime(), HiveSessionProperties.isVerboseRuntimeStatsEnabled(session));
        if (columns.stream().anyMatch(columnHandle -> ((HiveColumnHandle)((Object)columnHandle)).getColumnType().equals((Object)BaseHiveColumnHandle.ColumnType.AGGREGATED))) {
            Preconditions.checkArgument((boolean)columns.stream().allMatch(columnHandle -> ((HiveColumnHandle)((Object)columnHandle)).getColumnType().equals((Object)BaseHiveColumnHandle.ColumnType.AGGREGATED)), (Object)"Not all columns are of 'AGGREGATED' type");
            if (hiveLayout.isFooterStatsUnreliable()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Partial aggregation pushdown is not supported when footer stats are unreliable. Table %s has file %s with unreliable footer stats. Set session property [catalog-name].pushdown_partial_aggregations_into_scan=false and execute query again.", hiveLayout.getSchemaTableName(), hiveSplit.getFileSplit().getPath()));
            }
            return this.createAggregatedPageSource(this.aggregatedPageSourceFactories, configuration, session, hiveSplit, hiveLayout, selectedColumns, fileContext, encryptionInformation);
        }
        if (hiveLayout.isPushdownFilterEnabled() && (selectivePageSource = HivePageSourceProvider.createSelectivePageSource(this.selectivePageSourceFactories, configuration, session, hiveSplit, hiveLayout, selectedColumns, this.hiveStorageTimeZone, this.typeManager, this.optimizedRowExpressionCache, splitContext, fileContext, encryptionInformation)).isPresent()) {
            return selectivePageSource.get();
        }
        TupleDomain effectivePredicate = hiveLayout.getDomainPredicate().transform(Subfield::getRootName).transform(hiveLayout.getPredicateColumns()::get);
        if (HivePageSourceProvider.shouldSkipBucket(hiveLayout, hiveSplit, splitContext)) {
            return new HiveEmptySplitPageSource();
        }
        if (HivePageSourceProvider.shouldSkipPartition(this.typeManager, hiveLayout, this.hiveStorageTimeZone, hiveSplit, splitContext)) {
            return new HiveEmptySplitPageSource();
        }
        Optional<ConnectorPageSource> pageSource = HivePageSourceProvider.createHivePageSource(this.cursorProviders, this.pageSourceFactories, configuration, session, hiveSplit.getFileSplit(), hiveSplit.getTableBucketNumber(), hiveSplit.getStorage(), (TupleDomain<HiveColumnHandle>)splitContext.getDynamicFilterPredicate().map(filter -> filter.transform(handle -> (HiveColumnHandle)((Object)((Object)handle))).intersect(effectivePredicate)).orElse(effectivePredicate), selectedColumns, hiveLayout.getPredicateColumns(), hiveSplit.getPartitionKeys(), this.hiveStorageTimeZone, this.typeManager, hiveLayout.getSchemaTableName(), hiveLayout.getPartitionColumns().stream().map(HiveColumnHandle.class::cast).collect(Collectors.toList()), hiveLayout.getDataColumns(), hiveLayout.getTableParameters(), hiveSplit.getPartitionDataColumnCount(), hiveSplit.getTableToPartitionMapping(), hiveSplit.getBucketConversion(), hiveSplit.isS3SelectPushdownEnabled(), fileContext, hiveLayout.getRemainingPredicate(), hiveLayout.isPushdownFilterEnabled(), this.rowExpressionService, encryptionInformation, hiveSplit.getRowIdPartitionComponent());
        if (pageSource.isPresent()) {
            return pageSource.get();
        }
        throw new IllegalStateException("Could not find a file reader for split " + hiveSplit);
    }

    private ConnectorPageSource createAggregatedPageSource(Set<HiveAggregatedPageSourceFactory> aggregatedPageSourceFactories, Configuration configuration, ConnectorSession session, HiveSplit hiveSplit, HiveTableLayoutHandle hiveLayout, List<HiveColumnHandle> selectedColumns, HiveFileContext fileContext, Optional<EncryptionInformation> encryptionInformation) {
        List<ColumnMapping> columnMappings = ColumnMapping.buildColumnMappings(hiveSplit.getPartitionKeys(), selectedColumns, hiveSplit.getBucketConversion().map(HiveSplit.BucketConversion::getBucketColumnHandles).orElse((List)ImmutableList.of()), hiveSplit.getTableToPartitionMapping(), hiveSplit.getFileSplit(), hiveSplit.getTableBucketNumber());
        List<ColumnMapping> regularAndInterimColumnMappings = ColumnMapping.extractRegularAndInterimColumnMappings(columnMappings);
        for (HiveAggregatedPageSourceFactory pageSourceFactory : aggregatedPageSourceFactories) {
            Optional<? extends ConnectorPageSource> pageSource = pageSourceFactory.createPageSource(configuration, session, hiveSplit.getFileSplit(), hiveSplit.getStorage(), ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, true), fileContext, encryptionInformation, hiveLayout.isAppendRowNumberEnabled() || hiveLayout.isAppendRowId());
            if (!pageSource.isPresent()) continue;
            return pageSource.get();
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Table %s has file of format %s that does not support partial aggregation pushdown. Set session property [catalog-name].pushdown_partial_aggregations_into_scan=false and execute query again.", hiveLayout.getSchemaTableName(), hiveSplit.getStorage().getStorageFormat().getSerDe()));
    }

    @VisibleForTesting
    protected static CacheQuota generateCacheQuota(HiveSplit hiveSplit) {
        Optional quota = hiveSplit.getCacheQuotaRequirement().getQuota();
        switch (hiveSplit.getCacheQuotaRequirement().getCacheQuotaScope()) {
            case GLOBAL: {
                return new CacheQuota(".", quota);
            }
            case SCHEMA: {
                return new CacheQuota(hiveSplit.getDatabase(), quota);
            }
            case TABLE: {
                return new CacheQuota(hiveSplit.getDatabase() + "." + hiveSplit.getTable(), quota);
            }
            case PARTITION: {
                return new CacheQuota(hiveSplit.getDatabase() + "." + hiveSplit.getTable() + "." + hiveSplit.getPartitionName(), quota);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, String.format("%s is not supported", quota));
    }

    private static Optional<ConnectorPageSource> createSelectivePageSource(Set<HiveSelectivePageSourceFactory> selectivePageSourceFactories, Configuration configuration, ConnectorSession session, HiveSplit split, HiveTableLayoutHandle layout, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, LoadingCache<RowExpressionCacheKey, RowExpression> rowExpressionCache, SplitContext splitContext, HiveFileContext fileContext, Optional<EncryptionInformation> encryptionInformation) {
        ImmutableSet interimColumns = ImmutableSet.builder().addAll(layout.getPredicateColumns().values()).addAll((Iterable)split.getBucketConversion().map(HiveSplit.BucketConversion::getBucketColumnHandles).orElse((List)ImmutableList.of())).build();
        Set columnNames = (Set)columns.stream().map(BaseHiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        ImmutableList allColumns = ImmutableList.builder().addAll(columns).addAll((Iterable)interimColumns.stream().filter(column -> !columnNames.contains(column.getName())).collect(ImmutableList.toImmutableList())).build();
        List<ColumnMapping> columnMappings = ColumnMapping.buildColumnMappings(split.getPartitionKeys(), (List<HiveColumnHandle>)allColumns, (List<HiveColumnHandle>)ImmutableList.of(), split.getTableToPartitionMapping(), split.getFileSplit(), split.getTableBucketNumber());
        Optional<BucketAdaptation> bucketAdaptation = split.getBucketConversion().map(conversion -> HivePageSourceProvider.toBucketAdaptation(conversion, columnMappings, split.getTableBucketNumber(), mapping -> mapping.getHiveColumnHandle().getHiveColumnIndex()));
        Map prefilledValues = (Map)columnMappings.stream().filter(mapping -> mapping.getKind() == ColumnMappingKind.PREFILLED).collect(ImmutableMap.toImmutableMap(mapping -> mapping.getHiveColumnHandle().getHiveColumnIndex(), ColumnMapping::getPrefilledValue));
        Map coercers = (Map)columnMappings.stream().filter(mapping -> mapping.getCoercionFrom().isPresent()).collect(ImmutableMap.toImmutableMap(mapping -> mapping.getHiveColumnHandle().getHiveColumnIndex(), mapping -> HiveCoercer.createCoercer(typeManager, mapping.getCoercionFrom().get(), mapping.getHiveColumnHandle().getHiveType())));
        List outputColumns = (List)columns.stream().map(HiveColumnHandle::getHiveColumnIndex).collect(ImmutableList.toImmutableList());
        RowExpression optimizedRemainingPredicate = (RowExpression)rowExpressionCache.getUnchecked((Object)new RowExpressionCacheKey(layout.getRemainingPredicate(), session));
        if (HivePageSourceProvider.shouldSkipBucket(layout, split, splitContext)) {
            return Optional.of(new HiveEmptySplitPageSource());
        }
        if (HivePageSourceProvider.shouldSkipPartition(typeManager, layout, hiveStorageTimeZone, split, splitContext)) {
            return Optional.of(new HiveEmptySplitPageSource());
        }
        TupleDomain domainPredicate = splitContext.getDynamicFilterPredicate().map(filter -> filter.transform(handle -> new Subfield(((HiveColumnHandle)((Object)((Object)handle))).getName())).intersect(layout.getDomainPredicate())).orElse(layout.getDomainPredicate());
        for (HiveSelectivePageSourceFactory pageSourceFactory : selectivePageSourceFactories) {
            Optional<? extends ConnectorPageSource> pageSource = pageSourceFactory.createPageSource(configuration, session, split.getFileSplit(), split.getStorage(), ColumnMapping.toColumnHandles(columnMappings, true), prefilledValues, coercers, bucketAdaptation, outputColumns, (TupleDomain<Subfield>)domainPredicate, optimizedRemainingPredicate, hiveStorageTimeZone, fileContext, encryptionInformation, layout.isAppendRowNumberEnabled() || layout.isAppendRowId());
            if (!pageSource.isPresent()) continue;
            return Optional.of(pageSource.get());
        }
        return Optional.empty();
    }

    public static Optional<ConnectorPageSource> createHivePageSource(Set<HiveRecordCursorProvider> cursorProviders, Set<HiveBatchPageSourceFactory> pageSourceFactories, Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, OptionalInt tableBucketNumber, Storage storage, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> hiveColumns, Map<String, HiveColumnHandle> predicateColumns, List<HivePartitionKey> partitionKeys, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, SchemaTableName tableName, List<HiveColumnHandle> partitionKeyColumnHandles, List<Column> tableDataColumns, Map<String, String> tableParameters, int partitionDataColumnCount, TableToPartitionMapping tableToPartitionMapping, Optional<HiveSplit.BucketConversion> bucketConversion, boolean s3SelectPushdownEnabled, HiveFileContext hiveFileContext, RowExpression remainingPredicate, boolean isPushdownFilterEnabled, RowExpressionService rowExpressionService, Optional<EncryptionInformation> encryptionInformation, Optional<byte[]> rowIdPartitionComponent) {
        ImmutableList allColumns;
        if (isPushdownFilterEnabled) {
            Set columnNames = (Set)hiveColumns.stream().map(BaseHiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
            List additionalColumns = (List)predicateColumns.values().stream().filter(column -> !columnNames.contains(column.getName())).collect(ImmutableList.toImmutableList());
            allColumns = ImmutableList.builder().addAll(hiveColumns).addAll((Iterable)additionalColumns).build();
        } else {
            allColumns = hiveColumns;
        }
        List<ColumnMapping> columnMappings = ColumnMapping.buildColumnMappings(partitionKeys, allColumns, bucketConversion.map(HiveSplit.BucketConversion::getBucketColumnHandles).orElse((List)ImmutableList.of()), tableToPartitionMapping, fileSplit, tableBucketNumber);
        Set outputIndices = (Set)hiveColumns.stream().map(HiveColumnHandle::getHiveColumnIndex).collect(ImmutableSet.toImmutableSet());
        List<ColumnMapping> regularAndInterimColumnMappings = ColumnMapping.extractRegularAndInterimColumnMappings(columnMappings);
        Optional<BucketAdaptation> bucketAdaptation = bucketConversion.map(conversion -> HivePageSourceProvider.toBucketAdaptation(conversion, regularAndInterimColumnMappings, tableBucketNumber, ColumnMapping::getIndex));
        if (HiveSessionProperties.isUseRecordPageSourceForCustomSplit(session) && HiveUtil.shouldUseRecordReaderFromInputFormat(configuration, storage, fileSplit.getCustomSplitInfo())) {
            return HivePageSourceProvider.getPageSourceFromCursorProvider(cursorProviders, configuration, session, fileSplit, storage, effectivePredicate, hiveStorageTimeZone, typeManager, tableName, partitionKeyColumnHandles, tableDataColumns, tableParameters, partitionDataColumnCount, tableToPartitionMapping, s3SelectPushdownEnabled, remainingPredicate, isPushdownFilterEnabled, rowExpressionService, (List<HiveColumnHandle>)allColumns, columnMappings, outputIndices, regularAndInterimColumnMappings, bucketAdaptation);
        }
        for (HiveBatchPageSourceFactory pageSourceFactory : pageSourceFactories) {
            Optional<? extends ConnectorPageSource> pageSource = pageSourceFactory.createPageSource(configuration, session, fileSplit, storage, tableName, tableParameters, ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, true), effectivePredicate, hiveStorageTimeZone, hiveFileContext, encryptionInformation);
            if (!pageSource.isPresent()) continue;
            HivePageSource hivePageSource = new HivePageSource(columnMappings, bucketAdaptation, hiveStorageTimeZone, typeManager, pageSource.get(), fileSplit.getPath(), rowIdPartitionComponent);
            if (isPushdownFilterEnabled) {
                return Optional.of(new FilteringPageSource(columnMappings, effectivePredicate, remainingPredicate, typeManager, rowExpressionService, session, outputIndices, hivePageSource));
            }
            return Optional.of(hivePageSource);
        }
        return HivePageSourceProvider.getPageSourceFromCursorProvider(cursorProviders, configuration, session, fileSplit, storage, effectivePredicate, hiveStorageTimeZone, typeManager, tableName, partitionKeyColumnHandles, tableDataColumns, tableParameters, partitionDataColumnCount, tableToPartitionMapping, s3SelectPushdownEnabled, remainingPredicate, isPushdownFilterEnabled, rowExpressionService, (List<HiveColumnHandle>)allColumns, columnMappings, outputIndices, regularAndInterimColumnMappings, bucketAdaptation);
    }

    private static Optional<ConnectorPageSource> getPageSourceFromCursorProvider(Set<HiveRecordCursorProvider> cursorProviders, Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, Storage storage, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, SchemaTableName tableName, List<HiveColumnHandle> partitionKeyColumnHandles, List<Column> tableDataColumns, Map<String, String> tableParameters, int partitionDataColumnCount, TableToPartitionMapping tableToPartitionMapping, boolean s3SelectPushdownEnabled, RowExpression remainingPredicate, boolean isPushdownFilterEnabled, RowExpressionService rowExpressionService, List<HiveColumnHandle> allColumns, List<ColumnMapping> columnMappings, Set<Integer> outputIndices, List<ColumnMapping> regularAndInterimColumnMappings, Optional<BucketAdaptation> bucketAdaptation) {
        for (HiveRecordCursorProvider provider : cursorProviders) {
            boolean doCoercion;
            boolean bl = doCoercion = !(provider instanceof GenericHiveRecordCursorProvider);
            List partitionDataColumns = MetastoreUtil.reconstructPartitionSchema(tableDataColumns, (int)partitionDataColumnCount, tableToPartitionMapping.getPartitionSchemaDifference(), tableToPartitionMapping.getTableToPartitionColumns());
            Properties schema = MetastoreUtil.getHiveSchema((Storage)storage, (List)partitionDataColumns, tableDataColumns, tableParameters, (String)tableName.getSchemaName(), (String)tableName.getTableName(), (List)((List)partitionKeyColumnHandles.stream().map(BaseHiveColumnHandle::getName).collect(ImmutableList.toImmutableList())), (List)((List)partitionKeyColumnHandles.stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList())));
            Optional<RecordCursor> cursor = provider.createRecordCursor(configuration, session, fileSplit, schema, ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, doCoercion), effectivePredicate, hiveStorageTimeZone, typeManager, s3SelectPushdownEnabled);
            if (!cursor.isPresent()) continue;
            RecordCursor delegate = cursor.get();
            if (bucketAdaptation.isPresent()) {
                delegate = new HiveBucketAdapterRecordCursor(bucketAdaptation.get().getBucketColumnIndices(), bucketAdaptation.get().getBucketColumnHiveTypes(), bucketAdaptation.get().getTableBucketCount(), bucketAdaptation.get().getPartitionBucketCount(), bucketAdaptation.get().getBucketToKeep(), typeManager, delegate);
            }
            if (doCoercion) {
                delegate = new HiveCoercionRecordCursor(regularAndInterimColumnMappings, typeManager, delegate);
            }
            HiveRecordCursor hiveRecordCursor = new HiveRecordCursor(columnMappings, hiveStorageTimeZone, typeManager, delegate);
            List columnTypes = allColumns.stream().map(input -> typeManager.getType(input.getTypeSignature())).collect(Collectors.toList());
            RecordPageSource recordPageSource = new RecordPageSource(columnTypes, (RecordCursor)hiveRecordCursor);
            if (isPushdownFilterEnabled) {
                return Optional.of(new FilteringPageSource(columnMappings, effectivePredicate, remainingPredicate, typeManager, rowExpressionService, session, outputIndices, (ConnectorPageSource)recordPageSource));
            }
            return Optional.of(recordPageSource);
        }
        return Optional.empty();
    }

    private static boolean shouldSkipBucket(HiveTableLayoutHandle hiveLayout, HiveSplit hiveSplit, SplitContext splitContext) {
        if (!(splitContext.getDynamicFilterPredicate().isPresent() && hiveSplit.getReadBucketNumber().isPresent() && hiveSplit.getStorage().getBucketProperty().isPresent())) {
            return false;
        }
        TupleDomain dynamicFilter = (TupleDomain)splitContext.getDynamicFilterPredicate().get();
        Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter = HiveBucketing.getHiveBucketFilter(hiveSplit.getStorage().getBucketProperty(), hiveLayout.getDataColumns(), (TupleDomain<ColumnHandle>)dynamicFilter);
        return hiveBucketFilter.map(filter -> !filter.getBucketsToKeep().contains(hiveSplit.getReadBucketNumber().getAsInt())).orElse(false);
    }

    private static boolean shouldSkipPartition(TypeManager typeManager, HiveTableLayoutHandle hiveLayout, DateTimeZone hiveStorageTimeZone, HiveSplit hiveSplit, SplitContext splitContext) {
        List partitionColumns = hiveLayout.getPartitionColumns().stream().map(HiveColumnHandle.class::cast).collect(Collectors.toList());
        List partitionTypes = partitionColumns.stream().map(column -> typeManager.getType(column.getTypeSignature())).collect(Collectors.toList());
        List<HivePartitionKey> partitionKeys = hiveSplit.getPartitionKeys();
        if (!splitContext.getDynamicFilterPredicate().isPresent() || hiveSplit.getPartitionKeys().isEmpty() || partitionColumns.isEmpty() || partitionColumns.size() != partitionKeys.size()) {
            return false;
        }
        TupleDomain dynamicFilter = (TupleDomain)splitContext.getDynamicFilterPredicate().get();
        Map domains = (Map)dynamicFilter.getDomains().get();
        for (int i = 0; i < partitionKeys.size(); ++i) {
            Type type = (Type)partitionTypes.get(i);
            HivePartitionKey hivePartitionKey = partitionKeys.get(i);
            HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)((Object)partitionColumns.get(i));
            Domain allowedDomain = (Domain)domains.get((Object)hiveColumnHandle);
            NullableValue value = HiveUtil.parsePartitionValue(hivePartitionKey, type, hiveStorageTimeZone);
            if (allowedDomain == null || allowedDomain.includesNullableValue(value.getValue())) continue;
            return true;
        }
        return false;
    }

    private static BucketAdaptation toBucketAdaptation(HiveSplit.BucketConversion conversion, List<ColumnMapping> columnMappings, OptionalInt tableBucketNumber, Function<ColumnMapping, Integer> bucketColumnIndexProducer) {
        ImmutableMap hiveIndexToBlockIndex = Maps.uniqueIndex(columnMappings, columnMapping -> columnMapping.getHiveColumnHandle().getHiveColumnIndex());
        int[] bucketColumnIndices = conversion.getBucketColumnHandles().stream().map(HiveColumnHandle::getHiveColumnIndex).map(((Map)hiveIndexToBlockIndex)::get).mapToInt(bucketColumnIndexProducer::apply).toArray();
        List bucketColumnHiveTypes = (List)conversion.getBucketColumnHandles().stream().map(HiveColumnHandle::getHiveColumnIndex).map(((Map)hiveIndexToBlockIndex)::get).map(ColumnMapping::getHiveColumnHandle).map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList());
        return new BucketAdaptation(bucketColumnIndices, bucketColumnHiveTypes, conversion.getTableBucketCount(), conversion.getPartitionBucketCount(), tableBucketNumber.getAsInt());
    }

    private static final class RowExpressionCacheKey {
        private final RowExpression rowExpression;
        private final ConnectorSession session;

        RowExpressionCacheKey(RowExpression rowExpression, ConnectorSession session) {
            this.rowExpression = rowExpression;
            this.session = session;
        }

        public int hashCode() {
            return System.identityHashCode(this.rowExpression);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RowExpressionCacheKey other = (RowExpressionCacheKey)obj;
            return this.rowExpression == other.rowExpression;
        }
    }

    public static enum ColumnMappingKind {
        REGULAR,
        PREFILLED,
        INTERIM,
        AGGREGATED,
        POSTFILLED;

    }

    public static class ColumnMapping {
        private final ColumnMappingKind kind;
        private final HiveColumnHandle hiveColumnHandle;
        private final Optional<String> prefilledValue;
        private final OptionalInt index;
        private final Optional<HiveType> coercionFrom;

        public static ColumnMapping regular(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> coerceFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == BaseHiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.REGULAR, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), coerceFrom);
        }

        public static ColumnMapping aggregated(HiveColumnHandle hiveColumnHandle, int index) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == BaseHiveColumnHandle.ColumnType.AGGREGATED ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.REGULAR, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), Optional.empty());
        }

        public static ColumnMapping prefilled(HiveColumnHandle hiveColumnHandle, Optional<String> prefilledValue, Optional<HiveType> coerceFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == BaseHiveColumnHandle.ColumnType.PARTITION_KEY || hiveColumnHandle.getColumnType() == BaseHiveColumnHandle.ColumnType.SYNTHESIZED ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.PREFILLED, hiveColumnHandle, prefilledValue, OptionalInt.empty(), coerceFrom);
        }

        public static ColumnMapping interim(HiveColumnHandle hiveColumnHandle, int index) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == BaseHiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.INTERIM, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), Optional.empty());
        }

        private ColumnMapping(ColumnMappingKind kind, HiveColumnHandle hiveColumnHandle, Optional<String> prefilledValue, OptionalInt index, Optional<HiveType> coerceFrom) {
            this.kind = Objects.requireNonNull(kind, "kind is null");
            this.hiveColumnHandle = Objects.requireNonNull(hiveColumnHandle, "hiveColumnHandle is null");
            this.prefilledValue = Objects.requireNonNull(prefilledValue, "prefilledValue is null");
            this.index = Objects.requireNonNull(index, "index is null");
            this.coercionFrom = Objects.requireNonNull(coerceFrom, "coerceFrom is null");
        }

        public ColumnMappingKind getKind() {
            return this.kind;
        }

        public String getPrefilledValue() {
            Preconditions.checkState((this.kind == ColumnMappingKind.PREFILLED ? 1 : 0) != 0);
            return this.prefilledValue.orElse("\\N");
        }

        public HiveColumnHandle getHiveColumnHandle() {
            return this.hiveColumnHandle;
        }

        public int getIndex() {
            Preconditions.checkState((this.kind == ColumnMappingKind.REGULAR || this.kind == ColumnMappingKind.INTERIM ? 1 : 0) != 0);
            return this.index.getAsInt();
        }

        public Optional<HiveType> getCoercionFrom() {
            return this.coercionFrom;
        }

        public static List<ColumnMapping> buildColumnMappings(List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, List<HiveColumnHandle> requiredInterimColumns, TableToPartitionMapping tableToPartitionMapping, HiveFileSplit fileSplit, OptionalInt bucketNumber) {
            ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
            int regularIndex = 0;
            HashSet<Integer> regularColumnIndices = new HashSet<Integer>();
            ImmutableList.Builder columnMappings = ImmutableList.builder();
            for (HiveColumnHandle column : columns) {
                Optional<Column> partitionColumn = tableToPartitionMapping.getPartitionColumn(column.getHiveColumnIndex());
                Optional<HiveType> coercionFrom = Optional.empty();
                if (partitionColumn.isPresent() && !partitionColumn.get().getType().equals((Object)column.getHiveType())) {
                    coercionFrom = Optional.of(partitionColumn.get().getType());
                }
                if (column.getColumnType() == BaseHiveColumnHandle.ColumnType.REGULAR) {
                    Preconditions.checkArgument((boolean)regularColumnIndices.add(column.getHiveColumnIndex()), (Object)"duplicate hiveColumnIndex in columns list");
                    columnMappings.add((Object)ColumnMapping.regular(column, regularIndex, coercionFrom));
                    ++regularIndex;
                    continue;
                }
                if (column.getColumnType() == BaseHiveColumnHandle.ColumnType.AGGREGATED) {
                    columnMappings.add((Object)ColumnMapping.aggregated(column, regularIndex));
                    ++regularIndex;
                    continue;
                }
                if (HiveColumnHandle.isPushedDownSubfield(column)) {
                    Optional<Object> coercionFromType = ColumnMapping.getHiveType(coercionFrom, (Subfield)Iterables.getOnlyElement((Iterable)column.getRequiredSubfields()));
                    HiveType coercionToType = column.getHiveType();
                    if (coercionFromType.isPresent() && coercionFromType.get().equals((Object)coercionToType)) {
                        coercionFromType = Optional.empty();
                    }
                    ColumnMapping columnMapping = new ColumnMapping(ColumnMappingKind.REGULAR, column, Optional.empty(), OptionalInt.of(regularIndex), coercionFromType);
                    columnMappings.add((Object)columnMapping);
                    ++regularIndex;
                    continue;
                }
                if (HiveColumnHandle.isRowIdColumnHandle(column)) {
                    ColumnMapping columnMapping = new ColumnMapping(ColumnMappingKind.POSTFILLED, column, Optional.empty(), OptionalInt.empty(), coercionFrom);
                    columnMappings.add((Object)columnMapping);
                    continue;
                }
                columnMappings.add((Object)ColumnMapping.prefilled(column, HiveUtil.getPrefilledColumnValue(column, (HivePartitionKey)partitionKeysByName.get(column.getName()), fileSplit, bucketNumber), coercionFrom));
            }
            for (HiveColumnHandle column : requiredInterimColumns) {
                Preconditions.checkArgument((column.getColumnType() == BaseHiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
                if (regularColumnIndices.contains(column.getHiveColumnIndex())) continue;
                columnMappings.add((Object)ColumnMapping.interim(column, regularIndex));
                ++regularIndex;
            }
            return columnMappings.build();
        }

        private static Optional<HiveType> getHiveType(Optional<HiveType> baseType, Subfield subfield) {
            List pathElements = subfield.getPath();
            ImmutableList.Builder nestedColumnPathBuilder = ImmutableList.builder();
            for (Subfield.PathElement pathElement : pathElements) {
                Preconditions.checkArgument((boolean)(pathElement instanceof Subfield.NestedField), (Object)("Unsupported subfield. Expected only nested path elements. " + subfield));
                nestedColumnPathBuilder.add((Object)((Subfield.NestedField)pathElement).getName());
            }
            return baseType.flatMap(type -> type.findChildType((List)nestedColumnPathBuilder.build()));
        }

        public static List<ColumnMapping> extractRegularAndInterimColumnMappings(List<ColumnMapping> columnMappings) {
            return (List)columnMappings.stream().filter(columnMapping -> columnMapping.getKind() == ColumnMappingKind.REGULAR || columnMapping.getKind() == ColumnMappingKind.INTERIM).collect(ImmutableList.toImmutableList());
        }

        public static List<HiveColumnHandle> toColumnHandles(List<ColumnMapping> regularColumnMappings, boolean doCoercion) {
            return regularColumnMappings.stream().map(columnMapping -> {
                HiveColumnHandle columnHandle = columnMapping.getHiveColumnHandle();
                if (!doCoercion || !columnMapping.getCoercionFrom().isPresent()) {
                    return columnHandle;
                }
                return new HiveColumnHandle(columnHandle.getName(), columnMapping.getCoercionFrom().get(), columnMapping.getCoercionFrom().get().getTypeSignature(), columnHandle.getHiveColumnIndex(), columnHandle.getColumnType(), Optional.empty(), columnHandle.getRequiredSubfields(), columnHandle.getPartialAggregation());
            }).collect(Collectors.toList());
        }
    }
}

